% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFCalendar366.R
\docType{class}
\name{CFCalendar366}
\alias{CFCalendar366}
\title{366-day CF calendar}
\description{
This class represents a CF calendar of 366 days per year, having
leap days in every year. This calendar is not compatible with the standard
POSIXt calendar.

This calendar supports dates before year 1 and includes the year 0.
}
\section{Super class}{
\code{\link[CFtime:CFCalendar]{CFtime::CFCalendar}} -> \code{CFCalendar366}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CFCalendar366-new}{\code{CFCalendar366$new()}}
\item \href{#method-CFCalendar366-valid_days}{\code{CFCalendar366$valid_days()}}
\item \href{#method-CFCalendar366-month_days}{\code{CFCalendar366$month_days()}}
\item \href{#method-CFCalendar366-leap_year}{\code{CFCalendar366$leap_year()}}
\item \href{#method-CFCalendar366-date2offset}{\code{CFCalendar366$date2offset()}}
\item \href{#method-CFCalendar366-offset2date}{\code{CFCalendar366$offset2date()}}
\item \href{#method-CFCalendar366-clone}{\code{CFCalendar366$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="CFtime" data-topic="CFCalendar" data-id="POSIX_compatible"><a href='../../CFtime/html/CFCalendar.html#method-CFCalendar-POSIX_compatible'><code>CFtime::CFCalendar$POSIX_compatible()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CFtime" data-topic="CFCalendar" data-id="is_compatible"><a href='../../CFtime/html/CFCalendar.html#method-CFCalendar-is_compatible'><code>CFtime::CFCalendar$is_compatible()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CFtime" data-topic="CFCalendar" data-id="is_equivalent"><a href='../../CFtime/html/CFCalendar.html#method-CFCalendar-is_equivalent'><code>CFtime::CFCalendar$is_equivalent()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CFtime" data-topic="CFCalendar" data-id="offsets2time"><a href='../../CFtime/html/CFCalendar.html#method-CFCalendar-offsets2time'><code>CFtime::CFCalendar$offsets2time()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CFtime" data-topic="CFCalendar" data-id="parse"><a href='../../CFtime/html/CFCalendar.html#method-CFCalendar-parse'><code>CFtime::CFCalendar$parse()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CFtime" data-topic="CFCalendar" data-id="print"><a href='../../CFtime/html/CFCalendar.html#method-CFCalendar-print'><code>CFtime::CFCalendar$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFCalendar366-new"></a>}}
\if{latex}{\out{\hypertarget{method-CFCalendar366-new}{}}}
\subsection{Method \code{new()}}{
Create a new CF calendar of 366 days per year.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFCalendar366$new(nm, definition)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nm}}{The name of the calendar. This must be "366_day" or "all_leap".}

\item{\code{definition}}{The string that defines the units and the origin, as
per the CF Metadata Conventions.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new instance of this class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFCalendar366-valid_days"></a>}}
\if{latex}{\out{\hypertarget{method-CFCalendar366-valid_days}{}}}
\subsection{Method \code{valid_days()}}{
Indicate which of the supplied dates are valid.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFCalendar366$valid_days(ymd)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ymd}}{\code{data.frame} with dates parsed into their parts in columns
\code{year}, \code{month} and \code{day}. Any other columns are disregarded.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Logical vector with the same length as argument \code{ymd} has rows
with \code{TRUE} for valid days and \code{FALSE} for invalid days, or \code{NA} where
the row in argument \code{ymd} has \code{NA} values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFCalendar366-month_days"></a>}}
\if{latex}{\out{\hypertarget{method-CFCalendar366-month_days}{}}}
\subsection{Method \code{month_days()}}{
Determine the number of days in the month of the calendar.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFCalendar366$month_days(ymd = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ymd}}{\code{data.frame}, optional, with dates parsed into their parts.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A vector indicating the number of days in each month for the
dates supplied as argument \code{ymd}. If no dates are supplied, the number
of days per month for the calendar as a vector of length 12.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFCalendar366-leap_year"></a>}}
\if{latex}{\out{\hypertarget{method-CFCalendar366-leap_year}{}}}
\subsection{Method \code{leap_year()}}{
Indicate which years are leap years.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFCalendar366$leap_year(yr)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{yr}}{Integer vector of years to test.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Logical vector with the same length as argument \code{yr}. Since in
this calendar all years have a leap day, all values will be \code{TRUE}, or
\code{NA} where argument \code{yr} is \code{NA}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFCalendar366-date2offset"></a>}}
\if{latex}{\out{\hypertarget{method-CFCalendar366-date2offset}{}}}
\subsection{Method \code{date2offset()}}{
Calculate difference in days between a \code{data.frame} of time
parts and the origin.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFCalendar366$date2offset(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{\code{data.frame}. Dates to calculate the difference for.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Integer vector of a length equal to the number of rows in
argument \code{x} indicating the number of days between \code{x} and the \code{origin},
or \code{NA} for rows in \code{x} with \code{NA} values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFCalendar366-offset2date"></a>}}
\if{latex}{\out{\hypertarget{method-CFCalendar366-offset2date}{}}}
\subsection{Method \code{offset2date()}}{
Calculate date parts from day differences from the origin. This
only deals with days as these are impacted by the calendar.
Hour-minute-second timestamp parts are handled in \link{CFCalendar}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFCalendar366$offset2date(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Integer vector of days to add to the origin.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{data.frame} with columns 'year', 'month' and 'day' and as many
rows as the length of vector \code{x}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFCalendar366-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CFCalendar366-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFCalendar366$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
