/**
 * Update the fields of `O` with the ones of `O1`
 * (only the existing fields will be updated)
 * @param O to update
 * @param O1 to update with
 * @returns [[Object]]
 * @example
 * ```ts
 * ```
 */
export declare type Overwrite<O extends object, O1 extends object> = {
    [K in keyof O]: K extends keyof O1 ? O1[K] : O[K];
} & {};
