// Copyright 2021 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package retail provides access to the Retail API.
//
// For product documentation, see: https://cloud.google.com/recommendations
//
// Creating a client
//
// Usage example:
//
//   import "google.golang.org/api/retail/v2"
//   ...
//   ctx := context.Background()
//   retailService, err := retail.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//   retailService, err := retail.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//   config := &oauth2.Config{...}
//   // ...
//   token, err := config.Exchange(ctx, ...)
//   retailService, err := retail.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package retail // import "google.golang.org/api/retail/v2"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "retail:v2"
const apiName = "retail"
const apiVersion = "v2"
const basePath = "https://retail.googleapis.com/"
const mtlsBasePath = "https://retail.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := option.WithScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Catalogs = NewProjectsLocationsCatalogsService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Catalogs *ProjectsLocationsCatalogsService

	Operations *ProjectsLocationsOperationsService
}

func NewProjectsLocationsCatalogsService(s *Service) *ProjectsLocationsCatalogsService {
	rs := &ProjectsLocationsCatalogsService{s: s}
	rs.Branches = NewProjectsLocationsCatalogsBranchesService(s)
	rs.CompletionData = NewProjectsLocationsCatalogsCompletionDataService(s)
	rs.Operations = NewProjectsLocationsCatalogsOperationsService(s)
	rs.Placements = NewProjectsLocationsCatalogsPlacementsService(s)
	rs.UserEvents = NewProjectsLocationsCatalogsUserEventsService(s)
	return rs
}

type ProjectsLocationsCatalogsService struct {
	s *Service

	Branches *ProjectsLocationsCatalogsBranchesService

	CompletionData *ProjectsLocationsCatalogsCompletionDataService

	Operations *ProjectsLocationsCatalogsOperationsService

	Placements *ProjectsLocationsCatalogsPlacementsService

	UserEvents *ProjectsLocationsCatalogsUserEventsService
}

func NewProjectsLocationsCatalogsBranchesService(s *Service) *ProjectsLocationsCatalogsBranchesService {
	rs := &ProjectsLocationsCatalogsBranchesService{s: s}
	rs.Operations = NewProjectsLocationsCatalogsBranchesOperationsService(s)
	rs.Products = NewProjectsLocationsCatalogsBranchesProductsService(s)
	return rs
}

type ProjectsLocationsCatalogsBranchesService struct {
	s *Service

	Operations *ProjectsLocationsCatalogsBranchesOperationsService

	Products *ProjectsLocationsCatalogsBranchesProductsService
}

func NewProjectsLocationsCatalogsBranchesOperationsService(s *Service) *ProjectsLocationsCatalogsBranchesOperationsService {
	rs := &ProjectsLocationsCatalogsBranchesOperationsService{s: s}
	return rs
}

type ProjectsLocationsCatalogsBranchesOperationsService struct {
	s *Service
}

func NewProjectsLocationsCatalogsBranchesProductsService(s *Service) *ProjectsLocationsCatalogsBranchesProductsService {
	rs := &ProjectsLocationsCatalogsBranchesProductsService{s: s}
	return rs
}

type ProjectsLocationsCatalogsBranchesProductsService struct {
	s *Service
}

func NewProjectsLocationsCatalogsCompletionDataService(s *Service) *ProjectsLocationsCatalogsCompletionDataService {
	rs := &ProjectsLocationsCatalogsCompletionDataService{s: s}
	return rs
}

type ProjectsLocationsCatalogsCompletionDataService struct {
	s *Service
}

func NewProjectsLocationsCatalogsOperationsService(s *Service) *ProjectsLocationsCatalogsOperationsService {
	rs := &ProjectsLocationsCatalogsOperationsService{s: s}
	return rs
}

type ProjectsLocationsCatalogsOperationsService struct {
	s *Service
}

func NewProjectsLocationsCatalogsPlacementsService(s *Service) *ProjectsLocationsCatalogsPlacementsService {
	rs := &ProjectsLocationsCatalogsPlacementsService{s: s}
	return rs
}

type ProjectsLocationsCatalogsPlacementsService struct {
	s *Service
}

func NewProjectsLocationsCatalogsUserEventsService(s *Service) *ProjectsLocationsCatalogsUserEventsService {
	rs := &ProjectsLocationsCatalogsUserEventsService{s: s}
	return rs
}

type ProjectsLocationsCatalogsUserEventsService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

// GoogleApiHttpBody: Message that represents an arbitrary HTTP body. It
// should only be used for payload formats that can't be represented as
// JSON, such as raw binary or an HTML page. This message can be used
// both in streaming and non-streaming API methods in the request as
// well as the response. It can be used as a top-level request field,
// which is convenient if one wants to extract parameters from either
// the URL or HTTP template into the request fields and also want access
// to the raw HTTP body. Example: message GetResourceRequest { // A
// unique request id. string request_id = 1; // The raw HTTP body is
// bound to this field. google.api.HttpBody http_body = 2; } service
// ResourceService { rpc GetResource(GetResourceRequest) returns
// (google.api.HttpBody); rpc UpdateResource(google.api.HttpBody)
// returns (google.protobuf.Empty); } Example with streaming methods:
// service CaldavService { rpc GetCalendar(stream google.api.HttpBody)
// returns (stream google.api.HttpBody); rpc UpdateCalendar(stream
// google.api.HttpBody) returns (stream google.api.HttpBody); } Use of
// this type only changes how the request and response bodies are
// handled, all other features will continue to work unchanged.
type GoogleApiHttpBody struct {
	// ContentType: The HTTP Content-Type header value specifying the
	// content type of the body.
	ContentType string `json:"contentType,omitempty"`

	// Data: The HTTP request/response body as raw binary.
	Data string `json:"data,omitempty"`

	// Extensions: Application specific response metadata. Must be set in
	// the first response for streaming APIs.
	Extensions []googleapi.RawMessage `json:"extensions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ContentType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContentType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleApiHttpBody) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiHttpBody
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailLoggingErrorContext: A description of the context in
// which an error occurred.
type GoogleCloudRetailLoggingErrorContext struct {
	// HttpRequest: The HTTP request which was processed when the error was
	// triggered.
	HttpRequest *GoogleCloudRetailLoggingHttpRequestContext `json:"httpRequest,omitempty"`

	// ReportLocation: The location in the source code where the decision
	// was made to report the error, usually the place where it was logged.
	ReportLocation *GoogleCloudRetailLoggingSourceLocation `json:"reportLocation,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HttpRequest") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HttpRequest") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailLoggingErrorContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailLoggingErrorContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailLoggingErrorLog: An error log which is reported to
// the Error Reporting system. This proto a superset of
// google.devtools.clouderrorreporting.v1beta1.ReportedErrorEvent.
type GoogleCloudRetailLoggingErrorLog struct {
	// Context: A description of the context in which the error occurred.
	Context *GoogleCloudRetailLoggingErrorContext `json:"context,omitempty"`

	// ImportPayload: The error payload that is populated on LRO import
	// APIs.
	ImportPayload *GoogleCloudRetailLoggingImportErrorContext `json:"importPayload,omitempty"`

	// Message: A message describing the error.
	Message string `json:"message,omitempty"`

	// RequestPayload: The API request payload, represented as a protocol
	// buffer. Most API request types are supported. For example:
	// "type.googleapis.com/google.cloud.retail.v2.ProductService.CreateProdu
	// ctRequest"
	// "type.googleapis.com/google.cloud.retail.v2.UserEventService.WriteUser
	// EventRequest"
	RequestPayload googleapi.RawMessage `json:"requestPayload,omitempty"`

	// ResponsePayload: The API response payload, represented as a protocol
	// buffer. This is used to log some "soft errors", where the response is
	// valid but we consider there are some quality issues like unjoined
	// events. The following API responses are supported and no PII is
	// included: "google.cloud.retail.v2.PredictionService.Predict"
	// "google.cloud.retail.v2.UserEventService.WriteUserEvent"
	// "google.cloud.retail.v2.UserEventService.CollectUserEvent"
	ResponsePayload googleapi.RawMessage `json:"responsePayload,omitempty"`

	// ServiceContext: The service context in which this error has occurred.
	ServiceContext *GoogleCloudRetailLoggingServiceContext `json:"serviceContext,omitempty"`

	// Status: The RPC status associated with the error log.
	Status *GoogleRpcStatus `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Context") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Context") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailLoggingErrorLog) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailLoggingErrorLog
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailLoggingHttpRequestContext: HTTP request data that is
// related to a reported error.
type GoogleCloudRetailLoggingHttpRequestContext struct {
	// ResponseStatusCode: The HTTP response status code for the request.
	ResponseStatusCode int64 `json:"responseStatusCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResponseStatusCode")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResponseStatusCode") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailLoggingHttpRequestContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailLoggingHttpRequestContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailLoggingImportErrorContext: The error payload that is
// populated on LRO import APIs. Including:
// "google.cloud.retail.v2.ProductService.ImportProducts"
// "google.cloud.retail.v2.EventService.ImportUserEvents"
type GoogleCloudRetailLoggingImportErrorContext struct {
	// CatalogItem: The detailed content which caused the error on importing
	// a catalog item.
	CatalogItem string `json:"catalogItem,omitempty"`

	// GcsPath: Cloud Storage file path of the import source. Can be set for
	// batch operation error.
	GcsPath string `json:"gcsPath,omitempty"`

	// LineNumber: Line number of the content in file. Should be empty for
	// permission or batch operation error.
	LineNumber string `json:"lineNumber,omitempty"`

	// OperationName: The operation resource name of the LRO.
	OperationName string `json:"operationName,omitempty"`

	// Product: The detailed content which caused the error on importing a
	// product.
	Product string `json:"product,omitempty"`

	// UserEvent: The detailed content which caused the error on importing a
	// user event.
	UserEvent string `json:"userEvent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CatalogItem") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CatalogItem") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailLoggingImportErrorContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailLoggingImportErrorContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailLoggingServiceContext: Describes a running service
// that sends errors.
type GoogleCloudRetailLoggingServiceContext struct {
	// Service: An identifier of the service. For example,
	// "retail.googleapis.com".
	Service string `json:"service,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Service") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Service") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailLoggingServiceContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailLoggingServiceContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailLoggingSourceLocation: Indicates a location in the
// source code of the service for which errors are reported.
type GoogleCloudRetailLoggingSourceLocation struct {
	// FunctionName: Human-readable name of a function or method. For
	// example, "google.cloud.retail.v2.UserEventService.ImportUserEvents".
	FunctionName string `json:"functionName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FunctionName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FunctionName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailLoggingSourceLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailLoggingSourceLocation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2AddFulfillmentPlacesMetadata: Metadata related to
// the progress of the AddFulfillmentPlaces operation. Currently empty
// because there is no meaningful metadata populated from the
// AddFulfillmentPlaces method.
type GoogleCloudRetailV2AddFulfillmentPlacesMetadata struct {
}

// GoogleCloudRetailV2AddFulfillmentPlacesRequest: Request message for
// AddFulfillmentPlaces method.
type GoogleCloudRetailV2AddFulfillmentPlacesRequest struct {
	// AddTime: The time when the fulfillment updates are issued, used to
	// prevent out-of-order updates on fulfillment information. If not
	// provided, the internal system time will be used.
	AddTime string `json:"addTime,omitempty"`

	// AllowMissing: If set to true, and the Product is not found, the
	// fulfillment information will still be processed and retained for at
	// most 1 day and processed once the Product is created. If set to
	// false, a NOT_FOUND error is returned if the Product is not found.
	AllowMissing bool `json:"allowMissing,omitempty"`

	// PlaceIds: Required. The IDs for this type, such as the store IDs for
	// "pickup-in-store" or the region IDs for "same-day-delivery" to be
	// added for this type. Duplicate IDs will be automatically ignored. At
	// least 1 value is required, and a maximum of 2000 values are allowed.
	// Each value must be a string with a length limit of 10 characters,
	// matching the pattern `[a-zA-Z0-9_-]+`, such as "store1" or
	// "REGION-2". Otherwise, an INVALID_ARGUMENT error is returned. If the
	// total number of place IDs exceeds 2000 for this type after adding,
	// then the update will be rejected.
	PlaceIds []string `json:"placeIds,omitempty"`

	// Type: Required. The fulfillment type, including commonly used types
	// (such as pickup in store and same day delivery), and custom types.
	// Supported values: * "pickup-in-store" * "ship-to-store" *
	// "same-day-delivery" * "next-day-delivery" * "custom-type-1" *
	// "custom-type-2" * "custom-type-3" * "custom-type-4" * "custom-type-5"
	// If this field is set to an invalid value other than these, an
	// INVALID_ARGUMENT error is returned. This field directly corresponds
	// to Product.fulfillment_info.type.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AddTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AddTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2AddFulfillmentPlacesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2AddFulfillmentPlacesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2AddFulfillmentPlacesResponse: Response of the
// AddFulfillmentPlacesRequest. Currently empty because there is no
// meaningful response populated from the AddFulfillmentPlaces method.
type GoogleCloudRetailV2AddFulfillmentPlacesResponse struct {
}

// GoogleCloudRetailV2Audience: An intended audience of the Product for
// whom it's sold.
type GoogleCloudRetailV2Audience struct {
	// AgeGroups: The age groups of the audience. Strongly encouraged to use
	// the standard values: "newborn" (up to 3 months old), "infant" (3–12
	// months old), "toddler" (1–5 years old), "kids" (5–13 years old),
	// "adult" (typically teens or older). At most 5 values are allowed.
	// Each value must be a UTF-8 encoded string with a length limit of 128
	// characters. Otherwise, an INVALID_ARGUMENT error is returned. Google
	// Merchant Center property age_group
	// (https://support.google.com/merchants/answer/6324463). Schema.org
	// property Product.audience.suggestedMinAge
	// (https://schema.org/suggestedMinAge) and
	// Product.audience.suggestedMaxAge
	// (https://schema.org/suggestedMaxAge).
	AgeGroups []string `json:"ageGroups,omitempty"`

	// Genders: The genders of the audience. Strongly encouraged to use the
	// standard values: "male", "female", "unisex". At most 5 values are
	// allowed. Each value must be a UTF-8 encoded string with a length
	// limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is
	// returned. Google Merchant Center property gender
	// (https://support.google.com/merchants/answer/6324479). Schema.org
	// property Product.audience.suggestedGender
	// (https://schema.org/suggestedGender).
	Genders []string `json:"genders,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AgeGroups") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AgeGroups") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2Audience) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2Audience
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2BigQuerySource: BigQuery source import data from.
type GoogleCloudRetailV2BigQuerySource struct {
	// DataSchema: The schema to use when parsing the data from the source.
	// Supported values for product imports: * `product` (default): One JSON
	// Product per line. Each product must have a valid Product.id. *
	// `product_merchant_center`: See Importing catalog data from Merchant
	// Center
	// (https://cloud.google.com/retail/recommendations-ai/docs/upload-catalog#mc).
	// Supported values for user events imports: * `user_event` (default):
	// One JSON UserEvent per line. * `user_event_ga360`: Using
	// https://support.google.com/analytics/answer/3437719.
	DataSchema string `json:"dataSchema,omitempty"`

	// DatasetId: Required. The BigQuery data set to copy the data from with
	// a length limit of 1,024 characters.
	DatasetId string `json:"datasetId,omitempty"`

	// GcsStagingDir: Intermediate Cloud Storage directory used for the
	// import with a length limit of 2,000 characters. Can be specified if
	// one wants to have the BigQuery export to a specific Cloud Storage
	// directory.
	GcsStagingDir string `json:"gcsStagingDir,omitempty"`

	// PartitionDate: BigQuery time partitioned table's _PARTITIONDATE in
	// YYYY-MM-DD format. Only supported when
	// ImportProductsRequest.reconciliation_mode is set to `FULL`.
	PartitionDate *GoogleTypeDate `json:"partitionDate,omitempty"`

	// ProjectId: The project ID (can be project # or ID) that the BigQuery
	// source is in with a length limit of 128 characters. If not specified,
	// inherits the project ID from the parent request.
	ProjectId string `json:"projectId,omitempty"`

	// TableId: Required. The BigQuery table to copy the data from with a
	// length limit of 1,024 characters.
	TableId string `json:"tableId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DataSchema") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataSchema") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2BigQuerySource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2BigQuerySource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2Catalog: The catalog configuration.
type GoogleCloudRetailV2Catalog struct {
	// DisplayName: Required. Immutable. The catalog display name. This
	// field must be a UTF-8 encoded string with a length limit of 128
	// characters. Otherwise, an INVALID_ARGUMENT error is returned.
	DisplayName string `json:"displayName,omitempty"`

	// Name: Required. Immutable. The fully qualified resource name of the
	// catalog.
	Name string `json:"name,omitempty"`

	// ProductLevelConfig: Required. The product level configuration.
	ProductLevelConfig *GoogleCloudRetailV2ProductLevelConfig `json:"productLevelConfig,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2Catalog) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2Catalog
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2ColorInfo: The color information of a Product.
type GoogleCloudRetailV2ColorInfo struct {
	// ColorFamilies: The standard color families. Strongly recommended to
	// use the following standard color groups: "Red", "Pink", "Orange",
	// "Yellow", "Purple", "Green", "Cyan", "Blue", "Brown", "White",
	// "Gray", "Black" and "Mixed". Normally it is expected to have only 1
	// color family. May consider using single "Mixed" instead of multiple
	// values. A maximum of 5 values are allowed. Each value must be a UTF-8
	// encoded string with a length limit of 128 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned. Google Merchant Center property
	// color (https://support.google.com/merchants/answer/6324487).
	// Schema.org property Product.color (https://schema.org/color).
	ColorFamilies []string `json:"colorFamilies,omitempty"`

	// Colors: The color display names, which may be different from standard
	// color family names, such as the color aliases used in the website
	// frontend. Normally it is expected to have only 1 color. May consider
	// using single "Mixed" instead of multiple values. A maximum of 25
	// colors are allowed. Each value must be a UTF-8 encoded string with a
	// length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error
	// is returned. Google Merchant Center property color
	// (https://support.google.com/merchants/answer/6324487). Schema.org
	// property Product.color (https://schema.org/color).
	Colors []string `json:"colors,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ColorFamilies") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ColorFamilies") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2ColorInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ColorInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2CompleteQueryResponse: Response of the
// auto-complete query.
type GoogleCloudRetailV2CompleteQueryResponse struct {
	// AttributionToken: A unique complete token. This should be included in
	// the SearchRequest resulting from this completion, which enables
	// accurate attribution of complete model performance.
	AttributionToken string `json:"attributionToken,omitempty"`

	// CompletionResults: Results of the matching suggestions. The result
	// list is ordered and the first result is top suggestion.
	CompletionResults []*GoogleCloudRetailV2CompleteQueryResponseCompletionResult `json:"completionResults,omitempty"`

	// RecentSearchResults: Matched recent searches of this user. The
	// maximum number of recent searches is 10. This field is a restricted
	// feature. Contact Retail Search support team if you are interested in
	// enabling it. This feature is only available when
	// CompleteQueryRequest.visitor_id field is set and UserEvent is
	// imported. The recent searches satisfy the follow rules: * They are
	// ordered from latest to oldest. * They are matched with
	// CompleteQueryRequest.query case insensitively. * They are transformed
	// to lower cases. * They are UTF-8 safe. Recent searches are
	// deduplicated. More recent searches will be reserved when duplication
	// happens.
	RecentSearchResults []*GoogleCloudRetailV2CompleteQueryResponseRecentSearchResult `json:"recentSearchResults,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AttributionToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttributionToken") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2CompleteQueryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2CompleteQueryResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2CompleteQueryResponseCompletionResult: Resource
// that represents completion results.
type GoogleCloudRetailV2CompleteQueryResponseCompletionResult struct {
	// Attributes: Additional custom attributes ingested through BigQuery.
	Attributes map[string]GoogleCloudRetailV2CustomAttribute `json:"attributes,omitempty"`

	// Suggestion: The suggestion for the query.
	Suggestion string `json:"suggestion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Attributes") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2CompleteQueryResponseCompletionResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2CompleteQueryResponseCompletionResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2CompleteQueryResponseRecentSearchResult: Recent
// search of this user.
type GoogleCloudRetailV2CompleteQueryResponseRecentSearchResult struct {
	// RecentSearch: The recent search query.
	RecentSearch string `json:"recentSearch,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RecentSearch") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RecentSearch") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2CompleteQueryResponseRecentSearchResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2CompleteQueryResponseRecentSearchResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2CompletionDataInputConfig: The input config source
// for completion data.
type GoogleCloudRetailV2CompletionDataInputConfig struct {
	// BigQuerySource: Required. BigQuery input source. Add the IAM
	// permission "BigQuery Data Viewer" for
	// cloud-retail-customer-data-access@system.gserviceaccount.com before
	// using this feature otherwise an error is thrown.
	BigQuerySource *GoogleCloudRetailV2BigQuerySource `json:"bigQuerySource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BigQuerySource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigQuerySource") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2CompletionDataInputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2CompletionDataInputConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2CompletionDetail: Detailed completion information
// including completion attribution token and clicked completion info.
type GoogleCloudRetailV2CompletionDetail struct {
	// CompletionAttributionToken: Completion attribution token in
	// CompleteQueryResponse.attribution_token.
	CompletionAttributionToken string `json:"completionAttributionToken,omitempty"`

	// SelectedPosition: End user selected
	// CompleteQueryResponse.CompletionResult.suggestion position, starting
	// from 0.
	SelectedPosition int64 `json:"selectedPosition,omitempty"`

	// SelectedSuggestion: End user selected
	// CompleteQueryResponse.CompletionResult.suggestion.
	SelectedSuggestion string `json:"selectedSuggestion,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "CompletionAttributionToken") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "CompletionAttributionToken") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2CompletionDetail) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2CompletionDetail
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2CustomAttribute: A custom attribute that is not
// explicitly modeled in Product.
type GoogleCloudRetailV2CustomAttribute struct {
	// Indexable: If true, custom attribute values are indexed, so that it
	// can be filtered, faceted or boosted in SearchService.Search. This
	// field is ignored in a UserEvent. See SearchRequest.filter,
	// SearchRequest.facet_specs and SearchRequest.boost_spec for more
	// details.
	Indexable bool `json:"indexable,omitempty"`

	// Numbers: The numerical values of this custom attribute. For example,
	// `[2.3, 15.4]` when the key is "lengths_cm". At most 400 values are
	// allowed.Otherwise, an INVALID_ARGUMENT error is returned. Exactly one
	// of text or numbers should be set. Otherwise, an INVALID_ARGUMENT
	// error is returned.
	Numbers []float64 `json:"numbers,omitempty"`

	// Searchable: If true, custom attribute values are searchable by text
	// queries in SearchService.Search. This field is ignored in a
	// UserEvent. Only set if type text is set. Otherwise, a
	// INVALID_ARGUMENT error is returned.
	Searchable bool `json:"searchable,omitempty"`

	// Text: The textual values of this custom attribute. For example,
	// `["yellow", "green"]` when the key is "color". At most 400 values are
	// allowed. Empty values are not allowed. Each value must be a UTF-8
	// encoded string with a length limit of 256 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned. Exactly one of text or numbers
	// should be set. Otherwise, an INVALID_ARGUMENT error is returned.
	Text []string `json:"text,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Indexable") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Indexable") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2CustomAttribute) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2CustomAttribute
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2FulfillmentInfo: Fulfillment information, such as
// the store IDs for in-store pickup or region IDs for different
// shipping methods.
type GoogleCloudRetailV2FulfillmentInfo struct {
	// PlaceIds: The IDs for this type, such as the store IDs for
	// FulfillmentInfo.type.pickup-in-store or the region IDs for
	// FulfillmentInfo.type.same-day-delivery. A maximum of 3000 values are
	// allowed. Each value must be a string with a length limit of 30
	// characters, matching the pattern `[a-zA-Z0-9_-]+`, such as "store1"
	// or "REGION-2". Otherwise, an INVALID_ARGUMENT error is returned.
	PlaceIds []string `json:"placeIds,omitempty"`

	// Type: The fulfillment type, including commonly used types (such as
	// pickup in store and same day delivery), and custom types. Customers
	// have to map custom types to their display names before rendering UI.
	// Supported values: * "pickup-in-store" * "ship-to-store" *
	// "same-day-delivery" * "next-day-delivery" * "custom-type-1" *
	// "custom-type-2" * "custom-type-3" * "custom-type-4" * "custom-type-5"
	// If this field is set to an invalid value other than these, an
	// INVALID_ARGUMENT error is returned.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PlaceIds") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PlaceIds") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2FulfillmentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2FulfillmentInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2GcsSource: Google Cloud Storage location for input
// content. format.
type GoogleCloudRetailV2GcsSource struct {
	// DataSchema: The schema to use when parsing the data from the source.
	// Supported values for product imports: * `product` (default): One JSON
	// Product per line. Each product must have a valid Product.id. *
	// `product_merchant_center`: See Importing catalog data from Merchant
	// Center
	// (https://cloud.google.com/retail/recommendations-ai/docs/upload-catalog#mc).
	// Supported values for user events imports: * `user_event` (default):
	// One JSON UserEvent per line. * `user_event_ga360`: Using
	// https://support.google.com/analytics/answer/3437719.
	DataSchema string `json:"dataSchema,omitempty"`

	// InputUris: Required. Google Cloud Storage URIs to input files. URI
	// can be up to 2000 characters long. URIs can match the full object
	// path (for example, `gs://bucket/directory/object.json`) or a pattern
	// matching one or more files, such as `gs://bucket/directory/*.json`. A
	// request can contain at most 100 files, and each file can be up to 2
	// GB. See Importing product information
	// (https://cloud.google.com/retail/recommendations-ai/docs/upload-catalog)
	// for the expected file format and setup instructions.
	InputUris []string `json:"inputUris,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DataSchema") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataSchema") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2GcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2GcsSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2GetDefaultBranchResponse: Response message of
// CatalogService.GetDefaultBranch.
type GoogleCloudRetailV2GetDefaultBranchResponse struct {
	// Branch: Full resource name of the branch id currently set as default
	// branch.
	Branch string `json:"branch,omitempty"`

	// Note: This corresponds to SetDefaultBranchRequest.note field, when
	// this branch was set as default.
	Note string `json:"note,omitempty"`

	// SetTime: The time when this branch is set to default.
	SetTime string `json:"setTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Branch") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Branch") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2GetDefaultBranchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2GetDefaultBranchResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2Image: Product thumbnail/detail image.
type GoogleCloudRetailV2Image struct {
	// Height: Height of the image in number of pixels. This field must be
	// nonnegative. Otherwise, an INVALID_ARGUMENT error is returned.
	Height int64 `json:"height,omitempty"`

	// Uri: Required. URI of the image. This field must be a valid UTF-8
	// encoded URI with a length limit of 5,000 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned. Google Merchant Center property
	// image_link (https://support.google.com/merchants/answer/6324350).
	// Schema.org property Product.image (https://schema.org/image).
	Uri string `json:"uri,omitempty"`

	// Width: Width of the image in number of pixels. This field must be
	// nonnegative. Otherwise, an INVALID_ARGUMENT error is returned.
	Width int64 `json:"width,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Height") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Height") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2Image) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2Image
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2ImportCompletionDataRequest: Request message for
// ImportCompletionData methods.
type GoogleCloudRetailV2ImportCompletionDataRequest struct {
	// InputConfig: Required. The desired input location of the data.
	InputConfig *GoogleCloudRetailV2CompletionDataInputConfig `json:"inputConfig,omitempty"`

	// NotificationPubsubTopic: Pub/Sub topic for receiving notification. If
	// this field is set, when the import is finished, a notification will
	// be sent to specified Pub/Sub topic. The message data will be JSON
	// string of a Operation. Format of the Pub/Sub topic is
	// `projects/{project}/topics/{topic}`.
	NotificationPubsubTopic string `json:"notificationPubsubTopic,omitempty"`

	// ForceSendFields is a list of field names (e.g. "InputConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InputConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2ImportCompletionDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ImportCompletionDataRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2ImportCompletionDataResponse: Response of the
// ImportCompletionDataRequest. If the long running operation is done,
// this message is returned by the
// google.longrunning.Operations.response field if the operation is
// successful.
type GoogleCloudRetailV2ImportCompletionDataResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorSamples") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2ImportCompletionDataResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ImportCompletionDataResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2ImportErrorsConfig: Configuration of destination
// for Import related errors.
type GoogleCloudRetailV2ImportErrorsConfig struct {
	// GcsPrefix: Google Cloud Storage path for import errors. This must be
	// an empty, existing Cloud Storage bucket. Import errors will be
	// written to a file in this bucket, one per line, as a JSON-encoded
	// `google.rpc.Status` message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsPrefix") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2ImportErrorsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ImportErrorsConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2ImportMetadata: Metadata related to the progress
// of the Import operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudRetailV2ImportMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// FailureCount: Count of entries that encountered errors while
	// processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`

	// NotificationPubsubTopic: Pub/Sub topic for receiving notification. If
	// this field is set, when the import is finished, a notification will
	// be sent to specified Pub/Sub topic. The message data will be JSON
	// string of a Operation. Format of the Pub/Sub topic is
	// `projects/{project}/topics/{topic}`.
	NotificationPubsubTopic string `json:"notificationPubsubTopic,omitempty"`

	// RequestId: Id of the request / operation. This is parroting back the
	// requestId that was passed in the request.
	RequestId string `json:"requestId,omitempty"`

	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2ImportMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ImportMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2ImportProductsRequest: Request message for Import
// methods.
type GoogleCloudRetailV2ImportProductsRequest struct {
	// ErrorsConfig: The desired location of errors incurred during the
	// Import.
	ErrorsConfig *GoogleCloudRetailV2ImportErrorsConfig `json:"errorsConfig,omitempty"`

	// InputConfig: Required. The desired input location of the data.
	InputConfig *GoogleCloudRetailV2ProductInputConfig `json:"inputConfig,omitempty"`

	// NotificationPubsubTopic: Pub/Sub topic for receiving notification. If
	// this field is set, when the import is finished, a notification will
	// be sent to specified Pub/Sub topic. The message data will be JSON
	// string of a Operation. Format of the Pub/Sub topic is
	// `projects/{project}/topics/{topic}`. Only supported when
	// ImportProductsRequest.reconciliation_mode is set to `FULL`.
	NotificationPubsubTopic string `json:"notificationPubsubTopic,omitempty"`

	// ReconciliationMode: The mode of reconciliation between existing
	// products and the products to be imported. Defaults to
	// ReconciliationMode.INCREMENTAL.
	//
	// Possible values:
	//   "RECONCILIATION_MODE_UNSPECIFIED" - Defaults to INCREMENTAL.
	//   "INCREMENTAL" - Inserts new products or updates existing products.
	//   "FULL" - Calculates diff and replaces the entire product dataset.
	// Existing products may be deleted if they are not present in the
	// source location. Can only be while using BigQuerySource. Add the IAM
	// permission "BigQuery Data Viewer" for
	// cloud-retail-customer-data-access@system.gserviceaccount.com before
	// using this feature otherwise an error is thrown. This feature is only
	// available for users who have Retail Search enabled. Please submit a
	// form [here](https://cloud.google.com/contact) to contact cloud sales
	// if you are interested in using Retail Search.
	ReconciliationMode string `json:"reconciliationMode,omitempty"`

	// RequestId: Unique identifier provided by client, within the ancestor
	// dataset scope. Ensures idempotency and used for request
	// deduplication. Server-generated if unspecified. Up to 128 characters
	// long and must match the pattern: `[a-zA-Z0-9_]+`. This is returned as
	// Operation.name in ImportMetadata. Only supported when
	// ImportProductsRequest.reconciliation_mode is set to `FULL`.
	RequestId string `json:"requestId,omitempty"`

	// UpdateMask: Indicates which fields in the provided imported
	// 'products' to update. If not set, will by default update all fields.
	UpdateMask string `json:"updateMask,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorsConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorsConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2ImportProductsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ImportProductsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2ImportProductsResponse: Response of the
// ImportProductsRequest. If the long running operation is done, then
// this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudRetailV2ImportProductsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ErrorsConfig: Echoes the destination for the complete errors in the
	// request if set.
	ErrorsConfig *GoogleCloudRetailV2ImportErrorsConfig `json:"errorsConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorSamples") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2ImportProductsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ImportProductsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2ImportUserEventsRequest: Request message for the
// ImportUserEvents request.
type GoogleCloudRetailV2ImportUserEventsRequest struct {
	// ErrorsConfig: The desired location of errors incurred during the
	// Import. Cannot be set for inline user event imports.
	ErrorsConfig *GoogleCloudRetailV2ImportErrorsConfig `json:"errorsConfig,omitempty"`

	// InputConfig: Required. The desired input location of the data.
	InputConfig *GoogleCloudRetailV2UserEventInputConfig `json:"inputConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorsConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorsConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2ImportUserEventsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ImportUserEventsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2ImportUserEventsResponse: Response of the
// ImportUserEventsRequest. If the long running operation was
// successful, then this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudRetailV2ImportUserEventsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ErrorsConfig: Echoes the destination for the complete errors if this
	// field was set in the request.
	ErrorsConfig *GoogleCloudRetailV2ImportErrorsConfig `json:"errorsConfig,omitempty"`

	// ImportSummary: Aggregated statistics of user event import status.
	ImportSummary *GoogleCloudRetailV2UserEventImportSummary `json:"importSummary,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorSamples") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2ImportUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ImportUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2Interval: A floating point interval.
type GoogleCloudRetailV2Interval struct {
	// ExclusiveMaximum: Exclusive upper bound.
	ExclusiveMaximum float64 `json:"exclusiveMaximum,omitempty"`

	// ExclusiveMinimum: Exclusive lower bound.
	ExclusiveMinimum float64 `json:"exclusiveMinimum,omitempty"`

	// Maximum: Inclusive upper bound.
	Maximum float64 `json:"maximum,omitempty"`

	// Minimum: Inclusive lower bound.
	Minimum float64 `json:"minimum,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExclusiveMaximum") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExclusiveMaximum") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2Interval) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2Interval
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudRetailV2Interval) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudRetailV2Interval
	var s1 struct {
		ExclusiveMaximum gensupport.JSONFloat64 `json:"exclusiveMaximum"`
		ExclusiveMinimum gensupport.JSONFloat64 `json:"exclusiveMinimum"`
		Maximum          gensupport.JSONFloat64 `json:"maximum"`
		Minimum          gensupport.JSONFloat64 `json:"minimum"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ExclusiveMaximum = float64(s1.ExclusiveMaximum)
	s.ExclusiveMinimum = float64(s1.ExclusiveMinimum)
	s.Maximum = float64(s1.Maximum)
	s.Minimum = float64(s1.Minimum)
	return nil
}

// GoogleCloudRetailV2ListCatalogsResponse: Response for
// CatalogService.ListCatalogs method.
type GoogleCloudRetailV2ListCatalogsResponse struct {
	// Catalogs: All the customer's Catalogs.
	Catalogs []*GoogleCloudRetailV2Catalog `json:"catalogs,omitempty"`

	// NextPageToken: A token that can be sent as
	// ListCatalogsRequest.page_token to retrieve the next page. If this
	// field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Catalogs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Catalogs") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2ListCatalogsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ListCatalogsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2ListProductsResponse: Response message for
// ProductService.ListProducts method.
type GoogleCloudRetailV2ListProductsResponse struct {
	// NextPageToken: A token that can be sent as
	// ListProductsRequest.page_token to retrieve the next page. If this
	// field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Products: The Products.
	Products []*GoogleCloudRetailV2Product `json:"products,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2ListProductsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ListProductsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2PredictRequest: Request message for Predict
// method.
type GoogleCloudRetailV2PredictRequest struct {
	// Filter: Filter for restricting prediction results with a length limit
	// of 5,000 characters. Accepts values for tags and the
	// `filterOutOfStockItems` flag. * Tag expressions. Restricts
	// predictions to products that match all of the specified tags. Boolean
	// operators `OR` and `NOT` are supported if the expression is enclosed
	// in parentheses, and must be separated from the tag values by a space.
	// `-"tagA" is also supported and is equivalent to `NOT "tagA". Tag
	// values must be double quoted UTF-8 encoded strings with a size limit
	// of 1,000 characters. Note: "Recently viewed" models don't support tag
	// filtering at the moment. * filterOutOfStockItems. Restricts
	// predictions to products that do not have a stockState value of
	// OUT_OF_STOCK. Examples: * tag=("Red" OR "Blue") tag="New-Arrival"
	// tag=(NOT "promotional") * filterOutOfStockItems tag=(-"promotional")
	// * filterOutOfStockItems If your filter blocks all prediction results,
	// nothing will be returned. If you want generic (unfiltered) popular
	// products to be returned instead, set `strictFiltering` to false in
	// `PredictRequest.params`.
	Filter string `json:"filter,omitempty"`

	// Labels: The labels applied to a resource must meet the following
	// requirements: * Each resource can have multiple labels, up to a
	// maximum of 64. * Each label must be a key-value pair. * Keys have a
	// minimum length of 1 character and a maximum length of 63 characters,
	// and cannot be empty. Values can be empty, and have a maximum length
	// of 63 characters. * Keys and values can contain only lowercase
	// letters, numeric characters, underscores, and dashes. All characters
	// must use UTF-8 encoding, and international characters are allowed. *
	// The key portion of a label must be unique. However, you can use the
	// same key with multiple resources. * Keys must start with a lowercase
	// letter or international character. See Google Cloud Document
	// (https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	Labels map[string]string `json:"labels,omitempty"`

	// PageSize: Maximum number of results to return per page. Set this
	// property to the number of prediction results needed. If zero, the
	// service will choose a reasonable default. The maximum allowed value
	// is 100. Values above 100 will be coerced to 100.
	PageSize int64 `json:"pageSize,omitempty"`

	// PageToken: The previous PredictResponse.next_page_token.
	PageToken string `json:"pageToken,omitempty"`

	// Params: Additional domain specific parameters for the predictions.
	// Allowed values: * `returnProduct`: Boolean. If set to true, the
	// associated product object will be returned in the `results.metadata`
	// field in the prediction response. * `returnScore`: Boolean. If set to
	// true, the prediction 'score' corresponding to each returned product
	// will be set in the `results.metadata` field in the prediction
	// response. The given 'score' indicates the probability of an product
	// being clicked/purchased given the user's context and history. *
	// `strictFiltering`: Boolean. True by default. If set to false, the
	// service will return generic (unfiltered) popular products instead of
	// empty if your filter blocks all prediction results. *
	// `priceRerankLevel`: String. Default empty. If set to be non-empty,
	// then it needs to be one of {'no-price-reranking',
	// 'low-price-reranking', 'medium-price-reranking',
	// 'high-price-reranking'}. This gives request-level control and adjusts
	// prediction results based on product price. * `diversityLevel`:
	// String. Default empty. If set to be non-empty, then it needs to be
	// one of {'no-diversity', 'low-diversity', 'medium-diversity',
	// 'high-diversity', 'auto-diversity'}. This gives request-level control
	// and adjusts prediction results based on product category.
	Params googleapi.RawMessage `json:"params,omitempty"`

	// UserEvent: Required. Context about the user, what they are looking at
	// and what action they took to trigger the predict request. Note that
	// this user event detail won't be ingested to userEvent logs. Thus, a
	// separate userEvent write request is required for event logging.
	UserEvent *GoogleCloudRetailV2UserEvent `json:"userEvent,omitempty"`

	// ValidateOnly: Use validate only mode for this prediction query. If
	// set to true, a dummy model will be used that returns arbitrary
	// products. Note that the validate only mode should only be used for
	// testing the API, or if the model is not ready.
	ValidateOnly bool `json:"validateOnly,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Filter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2PredictRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2PredictRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2PredictResponse: Response message for predict
// method.
type GoogleCloudRetailV2PredictResponse struct {
	// AttributionToken: A unique attribution token. This should be included
	// in the UserEvent logs resulting from this recommendation, which
	// enables accurate attribution of recommendation model performance.
	AttributionToken string `json:"attributionToken,omitempty"`

	// MissingIds: IDs of products in the request that were missing from the
	// inventory.
	MissingIds []string `json:"missingIds,omitempty"`

	// Results: A list of recommended products. The order represents the
	// ranking (from the most relevant product to the least).
	Results []*GoogleCloudRetailV2PredictResponsePredictionResult `json:"results,omitempty"`

	// ValidateOnly: True if the validateOnly property was set in the
	// request.
	ValidateOnly bool `json:"validateOnly,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AttributionToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttributionToken") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2PredictResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2PredictResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2PredictResponsePredictionResult: PredictionResult
// represents the recommendation prediction results.
type GoogleCloudRetailV2PredictResponsePredictionResult struct {
	// Id: ID of the recommended product
	Id string `json:"id,omitempty"`

	// Metadata: Additional product metadata / annotations. Possible values:
	// * `product`: JSON representation of the product. Will be set if
	// `returnProduct` is set to true in `PredictRequest.params`. * `score`:
	// Prediction score in double value. Will be set if `returnScore` is set
	// to true in `PredictRequest.params`.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2PredictResponsePredictionResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2PredictResponsePredictionResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2PriceInfo: The price information of a Product.
type GoogleCloudRetailV2PriceInfo struct {
	// Cost: The costs associated with the sale of a particular product.
	// Used for gross profit reporting. * Profit = price - cost Google
	// Merchant Center property cost_of_goods_sold
	// (https://support.google.com/merchants/answer/9017895).
	Cost float64 `json:"cost,omitempty"`

	// CurrencyCode: The 3-letter currency code defined in ISO 4217
	// (https://www.iso.org/iso-4217-currency-codes.html). If this field is
	// an unrecognizable currency code, an INVALID_ARGUMENT error is
	// returned. The Product.Type.VARIANT Products with the same
	// Product.primary_product_id must share the same currency_code.
	// Otherwise, a FAILED_PRECONDITION error is returned.
	CurrencyCode string `json:"currencyCode,omitempty"`

	// OriginalPrice: Price of the product without any discount. If zero, by
	// default set to be the price.
	OriginalPrice float64 `json:"originalPrice,omitempty"`

	// Price: Price of the product. Google Merchant Center property price
	// (https://support.google.com/merchants/answer/6324371). Schema.org
	// property Offer.priceSpecification
	// (https://schema.org/priceSpecification).
	Price float64 `json:"price,omitempty"`

	// PriceEffectiveTime: The timestamp when the price starts to be
	// effective. This can be set as a future timestamp, and the price is
	// only used for search after price_effective_time. If so, the
	// original_price must be set and original_price is used before
	// price_effective_time. Do not set if price is always effective because
	// it will cause additional latency during search.
	PriceEffectiveTime string `json:"priceEffectiveTime,omitempty"`

	// PriceExpireTime: The timestamp when the price stops to be effective.
	// The price is used for search before price_expire_time. If this field
	// is set, the original_price must be set and original_price is used
	// after price_expire_time. Do not set if price is always effective
	// because it will cause additional latency during search.
	PriceExpireTime string `json:"priceExpireTime,omitempty"`

	// PriceRange: Output only. The price range of all the child
	// Product.Type.VARIANT Products grouped together on the
	// Product.Type.PRIMARY Product. Only populated for Product.Type.PRIMARY
	// Products. Note: This field is OUTPUT_ONLY for
	// ProductService.GetProduct. Do not set this field in API requests.
	PriceRange *GoogleCloudRetailV2PriceInfoPriceRange `json:"priceRange,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cost") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cost") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2PriceInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2PriceInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudRetailV2PriceInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudRetailV2PriceInfo
	var s1 struct {
		Cost          gensupport.JSONFloat64 `json:"cost"`
		OriginalPrice gensupport.JSONFloat64 `json:"originalPrice"`
		Price         gensupport.JSONFloat64 `json:"price"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Cost = float64(s1.Cost)
	s.OriginalPrice = float64(s1.OriginalPrice)
	s.Price = float64(s1.Price)
	return nil
}

// GoogleCloudRetailV2PriceInfoPriceRange: The price range of all
// variant Product having the same Product.primary_product_id.
type GoogleCloudRetailV2PriceInfoPriceRange struct {
	// OriginalPrice: The inclusive Product.pricing_info.original_price
	// internal of all variant Product having the same
	// Product.primary_product_id.
	OriginalPrice *GoogleCloudRetailV2Interval `json:"originalPrice,omitempty"`

	// Price: The inclusive Product.pricing_info.price interval of all
	// variant Product having the same Product.primary_product_id.
	Price *GoogleCloudRetailV2Interval `json:"price,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OriginalPrice") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OriginalPrice") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2PriceInfoPriceRange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2PriceInfoPriceRange
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2Product: Product captures all metadata information
// of items to be recommended or searched.
type GoogleCloudRetailV2Product struct {
	// Attributes: Highly encouraged. Extra product attributes to be
	// included. For example, for products, this could include the store
	// name, vendor, style, color, etc. These are very strong signals for
	// recommendation model, thus we highly recommend providing the
	// attributes here. Features that can take on one of a limited number of
	// possible values. Two types of features can be set are: Textual
	// features. some examples would be the brand/maker of a product, or
	// country of a customer. Numerical features. Some examples would be the
	// height/weight of a product, or age of a customer. For example: `{
	// "vendor": {"text": ["vendor123", "vendor456"]}, "lengths_cm":
	// {"numbers":[2.3, 15.4]}, "heights_cm": {"numbers":[8.1, 6.4]} }`.
	// This field needs to pass all below criteria, otherwise an
	// INVALID_ARGUMENT error is returned: * Max entries count: 200. * The
	// key must be a UTF-8 encoded string with a length limit of 128
	// characters. * For indexable attribute, the key must match the
	// pattern: `a-zA-Z0-9*`. For example, key0LikeThis or KEY_1_LIKE_THIS.
	Attributes map[string]GoogleCloudRetailV2CustomAttribute `json:"attributes,omitempty"`

	// Audience: The target group associated with a given audience (e.g.
	// male, veterans, car owners, musicians, etc.) of the product.
	Audience *GoogleCloudRetailV2Audience `json:"audience,omitempty"`

	// Availability: The online availability of the Product. Default to
	// Availability.IN_STOCK. Google Merchant Center Property availability
	// (https://support.google.com/merchants/answer/6324448). Schema.org
	// Property Offer.availability (https://schema.org/availability).
	//
	// Possible values:
	//   "AVAILABILITY_UNSPECIFIED" - Default product availability. Default
	// to Availability.IN_STOCK if unset.
	//   "IN_STOCK" - Product in stock.
	//   "OUT_OF_STOCK" - Product out of stock.
	//   "PREORDER" - Product that is in pre-order state.
	//   "BACKORDER" - Product that is back-ordered (i.e. temporarily out of
	// stock).
	Availability string `json:"availability,omitempty"`

	// AvailableQuantity: The available quantity of the item.
	AvailableQuantity int64 `json:"availableQuantity,omitempty"`

	// AvailableTime: The timestamp when this Product becomes available for
	// SearchService.Search.
	AvailableTime string `json:"availableTime,omitempty"`

	// Brands: The brands of the product. A maximum of 30 brands are
	// allowed. Each brand must be a UTF-8 encoded string with a length
	// limit of 1,000 characters. Otherwise, an INVALID_ARGUMENT error is
	// returned. Google Merchant Center property brand
	// (https://support.google.com/merchants/answer/6324351). Schema.org
	// property Product.brand (https://schema.org/brand).
	Brands []string `json:"brands,omitempty"`

	// Categories: Product categories. This field is repeated for supporting
	// one product belonging to several parallel categories. Strongly
	// recommended using the full path for better search / recommendation
	// quality. To represent full path of category, use '>' sign to separate
	// different hierarchies. If '>' is part of the category name, please
	// replace it with other character(s). For example, if a shoes product
	// belongs to both ["Shoes & Accessories" -> "Shoes"] and ["Sports &
	// Fitness" -> "Athletic Clothing" -> "Shoes"], it could be represented
	// as: "categories": [ "Shoes & Accessories > Shoes", "Sports & Fitness
	// > Athletic Clothing > Shoes" ] Must be set for Type.PRIMARY Product
	// otherwise an INVALID_ARGUMENT error is returned. At most 250 values
	// are allowed per Product. Empty values are not allowed. Each value
	// must be a UTF-8 encoded string with a length limit of 5,000
	// characters. Otherwise, an INVALID_ARGUMENT error is returned. Google
	// Merchant Center property google_product_category. Schema.org property
	// [Product.category] (https://schema.org/category).
	// [mc_google_product_category]:
	// https://support.google.com/merchants/answer/6324436
	Categories []string `json:"categories,omitempty"`

	// CollectionMemberIds: The id of the collection members when type is
	// Type.COLLECTION. Should not set it for other types. A maximum of 1000
	// values are allowed. Otherwise, an INVALID_ARGUMENT error is return.
	CollectionMemberIds []string `json:"collectionMemberIds,omitempty"`

	// ColorInfo: The color of the product. Google Merchant Center property
	// color (https://support.google.com/merchants/answer/6324487).
	// Schema.org property Product.color (https://schema.org/color).
	ColorInfo *GoogleCloudRetailV2ColorInfo `json:"colorInfo,omitempty"`

	// Conditions: The condition of the product. Strongly encouraged to use
	// the standard values: "new", "refurbished", "used". A maximum of 5
	// values are allowed per Product. Each value must be a UTF-8 encoded
	// string with a length limit of 128 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned. Google Merchant Center property
	// condition (https://support.google.com/merchants/answer/6324469).
	// Schema.org property Offer.itemCondition
	// (https://schema.org/itemCondition).
	Conditions []string `json:"conditions,omitempty"`

	// Description: Product description. This field must be a UTF-8 encoded
	// string with a length limit of 5,000 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned. Google Merchant Center property
	// description (https://support.google.com/merchants/answer/6324468).
	// schema.org property Product.description
	// (https://schema.org/description).
	Description string `json:"description,omitempty"`

	// ExpireTime: The timestamp when this product becomes unavailable for
	// SearchService.Search. If it is set, the Product is not available for
	// SearchService.Search after expire_time. However, the product can
	// still be retrieved by ProductService.GetProduct and
	// ProductService.ListProducts. expire_time must be later than
	// available_time and publish_time, otherwise an INVALID_ARGUMENT error
	// is thrown. Google Merchant Center property expiration_date
	// (https://support.google.com/merchants/answer/6324499).
	ExpireTime string `json:"expireTime,omitempty"`

	// FulfillmentInfo: Fulfillment information, such as the store IDs for
	// in-store pickup or region IDs for different shipping methods. All the
	// elements must have distinct FulfillmentInfo.type. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	FulfillmentInfo []*GoogleCloudRetailV2FulfillmentInfo `json:"fulfillmentInfo,omitempty"`

	// Gtin: The Global Trade Item Number (GTIN) of the product. This field
	// must be a UTF-8 encoded string with a length limit of 128 characters.
	// Otherwise, an INVALID_ARGUMENT error is returned. This field must be
	// a Unigram. Otherwise, an INVALID_ARGUMENT error is returned. Google
	// Merchant Center property gtin
	// (https://support.google.com/merchants/answer/6324461). Schema.org
	// property Product.isbn (https://schema.org/isbn) or Product.gtin8
	// (https://schema.org/gtin8) or Product.gtin12
	// (https://schema.org/gtin12) or Product.gtin13
	// (https://schema.org/gtin13) or Product.gtin14
	// (https://schema.org/gtin14). If the value is not a valid GTIN, an
	// INVALID_ARGUMENT error is returned.
	Gtin string `json:"gtin,omitempty"`

	// Id: Immutable. Product identifier, which is the final component of
	// name. For example, this field is "id_1", if name is
	// `projects/*/locations/global/catalogs/default_catalog/branches/default
	// _branch/products/id_1`. This field must be a UTF-8 encoded string
	// with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT
	// error is returned. Google Merchant Center property id
	// (https://support.google.com/merchants/answer/6324405). Schema.org
	// Property Product.sku (https://schema.org/sku).
	Id string `json:"id,omitempty"`

	// Images: Product images for the product.Highly recommended to put the
	// main image to the first. A maximum of 300 images are allowed. Google
	// Merchant Center property image_link
	// (https://support.google.com/merchants/answer/6324350). Schema.org
	// property Product.image (https://schema.org/image).
	Images []*GoogleCloudRetailV2Image `json:"images,omitempty"`

	// LanguageCode: Language of the title/description and other string
	// attributes. Use language tags defined by BCP 47. For product
	// prediction, this field is ignored and the model automatically detects
	// the text language. The Product can include text in different
	// languages, but duplicating Products to provide text in multiple
	// languages can result in degraded model performance. For product
	// search this field is in use. It defaults to "en-US" if unset.
	LanguageCode string `json:"languageCode,omitempty"`

	// Materials: The material of the product. For example, "leather",
	// "wooden". A maximum of 20 values are allowed. Each value must be a
	// UTF-8 encoded string with a length limit of 128 characters.
	// Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant
	// Center property material
	// (https://support.google.com/merchants/answer/6324410). Schema.org
	// property Product.material (https://schema.org/material).
	Materials []string `json:"materials,omitempty"`

	// Name: Immutable. Full resource name of the product, such as
	// `projects/*/locations/global/catalogs/default_catalog/branches/default
	// _branch/products/product_id`.
	Name string `json:"name,omitempty"`

	// Patterns: The pattern or graphic print of the product. For example,
	// "striped", "polka dot", "paisley". A maximum of 20 values are allowed
	// per Product. Each value must be a UTF-8 encoded string with a length
	// limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is
	// returned. Google Merchant Center property pattern
	// (https://support.google.com/merchants/answer/6324483). Schema.org
	// property Product.pattern (https://schema.org/pattern).
	Patterns []string `json:"patterns,omitempty"`

	// PriceInfo: Product price and cost information. Google Merchant Center
	// property price (https://support.google.com/merchants/answer/6324371).
	PriceInfo *GoogleCloudRetailV2PriceInfo `json:"priceInfo,omitempty"`

	// PrimaryProductId: Variant group identifier. Must be an id, with the
	// same parent branch with this product. Otherwise, an error is thrown.
	// For Type.PRIMARY Products, this field can only be empty or set to the
	// same value as id. For VARIANT Products, this field cannot be empty. A
	// maximum of 2,000 products are allowed to share the same Type.PRIMARY
	// Product. Otherwise, an INVALID_ARGUMENT error is returned. Google
	// Merchant Center Property item_group_id
	// (https://support.google.com/merchants/answer/6324507). Schema.org
	// Property Product.inProductGroupWithID
	// (https://schema.org/inProductGroupWithID). This field must be enabled
	// before it can be used. Learn more
	// (/recommendations-ai/docs/catalog#item-group-id).
	PrimaryProductId string `json:"primaryProductId,omitempty"`

	// Promotions: The promotions applied to the product. A maximum of 10
	// values are allowed per Product.
	Promotions []*GoogleCloudRetailV2Promotion `json:"promotions,omitempty"`

	// PublishTime: The timestamp when the product is published by the
	// retailer for the first time, which indicates the freshness of the
	// products. Note that this field is different from available_time,
	// given it purely describes product freshness regardless of when it is
	// available on search and recommendation.
	PublishTime string `json:"publishTime,omitempty"`

	// Rating: The rating of this product.
	Rating *GoogleCloudRetailV2Rating `json:"rating,omitempty"`

	// RetrievableFields: Indicates which fields in the Products are
	// returned in SearchResponse. Supported fields for all types: *
	// audience * availability * brands * color_info * conditions * gtin *
	// materials * name * patterns * price_info * rating * sizes * title *
	// uri Supported fields only for Type.PRIMARY and Type.COLLECTION: *
	// categories * description * images Supported fields only for
	// Type.VARIANT: * Only the first image in images To mark attributes as
	// retrievable, include paths of the form "attributes.key" where "key"
	// is the key of a custom attribute, as specified in attributes. For
	// Type.PRIMARY and Type.COLLECTION, the following fields are always
	// returned in SearchResponse by default: * name For Type.VARIANT, the
	// following fields are always returned in by default: * name *
	// color_info Maximum number of paths is 30. Otherwise, an
	// INVALID_ARGUMENT error is returned. Note: Returning more fields in
	// SearchResponse may increase response payload size and serving
	// latency.
	RetrievableFields string `json:"retrievableFields,omitempty"`

	// Sizes: The size of the product. To represent different size systems
	// or size types, consider using this format:
	// [[[size_system:]size_type:]size_value]. For example, in "US:MENS:M",
	// "US" represents size system; "MENS" represents size type; "M"
	// represents size value. In "GIRLS:27", size system is empty; "GIRLS"
	// represents size type; "27" represents size value. In "32 inches",
	// both size system and size type are empty, while size value is "32
	// inches". A maximum of 20 values are allowed per Product. Each value
	// must be a UTF-8 encoded string with a length limit of 128 characters.
	// Otherwise, an INVALID_ARGUMENT error is returned. Google Merchant
	// Center property size
	// (https://support.google.com/merchants/answer/6324492), size_type
	// (https://support.google.com/merchants/answer/6324497) and size_system
	// (https://support.google.com/merchants/answer/6324502). Schema.org
	// property Product.size (https://schema.org/size).
	Sizes []string `json:"sizes,omitempty"`

	// Tags: Custom tags associated with the product. At most 250 values are
	// allowed per Product. This value must be a UTF-8 encoded string with a
	// length limit of 1,000 characters. Otherwise, an INVALID_ARGUMENT
	// error is returned. This tag can be used for filtering recommendation
	// results by passing the tag as part of the PredictRequest.filter.
	// Google Merchant Center property custom_label_0–4
	// (https://support.google.com/merchants/answer/6324473).
	Tags []string `json:"tags,omitempty"`

	// Title: Required. Product title. This field must be a UTF-8 encoded
	// string with a length limit of 1,000 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned. Google Merchant Center property
	// title (https://support.google.com/merchants/answer/6324415).
	// Schema.org property Product.name (https://schema.org/name).
	Title string `json:"title,omitempty"`

	// Ttl: Input only. The TTL (time to live) of the product. If it is set,
	// it must be a non-negative value, and expire_time is set as current
	// timestamp plus ttl. The derived expire_time is returned in the output
	// and ttl is left blank when retrieving the Product. If it is set, the
	// product is not available for SearchService.Search after current
	// timestamp plus ttl. However, the product can still be retrieved by
	// ProductService.GetProduct and ProductService.ListProducts.
	Ttl string `json:"ttl,omitempty"`

	// Type: Immutable. The type of the product. Default to
	// Catalog.product_level_config.ingestion_product_type if unset.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default value. Default to
	// Catalog.product_level_config.ingestion_product_type if unset.
	//   "PRIMARY" - The primary type. As the primary unit for predicting,
	// indexing and search serving, a Type.PRIMARY Product is grouped with
	// multiple Type.VARIANT Products.
	//   "VARIANT" - The variant type. Type.VARIANT Products usually share
	// some common attributes on the same Type.PRIMARY Products, but they
	// have variant attributes like different colors, sizes and prices, etc.
	//   "COLLECTION" - The collection type. Collection products are bundled
	// Type.PRIMARY Products or Type.VARIANT Products that are sold
	// together, such as a jewelry set with necklaces, earrings and rings,
	// etc.
	Type string `json:"type,omitempty"`

	// Uri: Canonical URL directly linking to the product detail page. It is
	// strongly recommended to provide a valid uri for the product,
	// otherwise the service performance could be significantly degraded.
	// This field must be a UTF-8 encoded string with a length limit of
	// 5,000 characters. Otherwise, an INVALID_ARGUMENT error is returned.
	// Google Merchant Center property link
	// (https://support.google.com/merchants/answer/6324416). Schema.org
	// property Offer.url (https://schema.org/url).
	Uri string `json:"uri,omitempty"`

	// Variants: Output only. Product variants grouped together on primary
	// product which share similar product attributes. It's automatically
	// grouped by primary_product_id for all the product variants. Only
	// populated for Type.PRIMARY Products. Note: This field is OUTPUT_ONLY
	// for ProductService.GetProduct. Do not set this field in API requests.
	Variants []*GoogleCloudRetailV2Product `json:"variants,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Attributes") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2Product) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2Product
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2ProductDetail: Detailed product information
// associated with a user event.
type GoogleCloudRetailV2ProductDetail struct {
	// Product: Required. Product information. Required field(s): *
	// Product.id Optional override field(s): * Product.price_info If any
	// supported optional fields are provided, we will treat them as a full
	// override when looking up product information from the catalog. Thus,
	// it is important to ensure that the overriding fields are accurate and
	// complete. All other product fields are ignored and instead populated
	// via catalog lookup after event ingestion.
	Product *GoogleCloudRetailV2Product `json:"product,omitempty"`

	// Quantity: Quantity of the product associated with the user event. For
	// example, this field will be 2 if two products are added to the
	// shopping cart for `purchase-complete` event. Required for
	// `add-to-cart` and `purchase-complete` event types.
	Quantity int64 `json:"quantity,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Product") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Product") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2ProductDetail) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ProductDetail
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2ProductInlineSource: The inline source for the
// input config for ImportProducts method.
type GoogleCloudRetailV2ProductInlineSource struct {
	// Products: Required. A list of products to update/create. Each product
	// must have a valid Product.id. Recommended max of 100 items.
	Products []*GoogleCloudRetailV2Product `json:"products,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Products") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Products") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2ProductInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ProductInlineSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2ProductInputConfig: The input config source for
// products.
type GoogleCloudRetailV2ProductInputConfig struct {
	// BigQuerySource: BigQuery input source.
	BigQuerySource *GoogleCloudRetailV2BigQuerySource `json:"bigQuerySource,omitempty"`

	// GcsSource: Google Cloud Storage location for the input content.
	GcsSource *GoogleCloudRetailV2GcsSource `json:"gcsSource,omitempty"`

	// ProductInlineSource: The Inline source for the input content for
	// products.
	ProductInlineSource *GoogleCloudRetailV2ProductInlineSource `json:"productInlineSource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BigQuerySource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigQuerySource") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2ProductInputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ProductInputConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2ProductLevelConfig: Configures what level the
// product should be uploaded with regards to how users will be send
// events and how predictions will be made.
type GoogleCloudRetailV2ProductLevelConfig struct {
	// IngestionProductType: The type of Products allowed to be ingested
	// into the catalog. Acceptable values are: * `primary` (default): You
	// can ingest Products of all types. When ingesting a Product, its type
	// will default to Product.Type.PRIMARY if unset. * `variant`: You can
	// only ingest Product.Type.VARIANT Products. This means
	// Product.primary_product_id cannot be empty. If this field is set to
	// an invalid value other than these, an INVALID_ARGUMENT error is
	// returned. If this field is `variant` and
	// merchant_center_product_id_field is `itemGroupId`, an
	// INVALID_ARGUMENT error is returned. See Using product levels
	// (https://cloud.google.com/retail/recommendations-ai/docs/catalog#product-levels)
	// for more details.
	IngestionProductType string `json:"ingestionProductType,omitempty"`

	// MerchantCenterProductIdField: Which field of Merchant Center Product
	// (/bigquery-transfer/docs/merchant-center-products-schema) should be
	// imported as Product.id. Acceptable values are: * `offerId` (default):
	// Import `offerId` as the product ID. * `itemGroupId`: Import
	// `itemGroupId` as the product ID. Notice that Retail API will choose
	// one item from the ones with the same `itemGroupId`, and use it to
	// represent the item group. If this field is set to an invalid value
	// other than these, an INVALID_ARGUMENT error is returned. If this
	// field is `itemGroupId` and ingestion_product_type is `variant`, an
	// INVALID_ARGUMENT error is returned. See Using product levels
	// (https://cloud.google.com/retail/recommendations-ai/docs/catalog#product-levels)
	// for more details.
	MerchantCenterProductIdField string `json:"merchantCenterProductIdField,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "IngestionProductType") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IngestionProductType") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2ProductLevelConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2ProductLevelConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2Promotion: Promotion information.
type GoogleCloudRetailV2Promotion struct {
	// PromotionId: ID of the promotion. For example, "free gift". The value
	// value must be a UTF-8 encoded string with a length limit of 128
	// characters, and match the pattern: `a-zA-Z*`. For example,
	// id0LikeThis or ID_1_LIKE_THIS. Otherwise, an INVALID_ARGUMENT error
	// is returned. Google Merchant Center property promotion
	// (https://support.google.com/merchants/answer/7050148).
	PromotionId string `json:"promotionId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PromotionId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PromotionId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2Promotion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2Promotion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2PurchaseTransaction: A transaction represents the
// entire purchase transaction.
type GoogleCloudRetailV2PurchaseTransaction struct {
	// Cost: All the costs associated with the products. These can be
	// manufacturing costs, shipping expenses not borne by the end user, or
	// any other costs, such that: * Profit = revenue - tax - cost
	Cost float64 `json:"cost,omitempty"`

	// CurrencyCode: Required. Currency code. Use three-character ISO-4217
	// code.
	CurrencyCode string `json:"currencyCode,omitempty"`

	// Id: The transaction ID with a length limit of 128 characters.
	Id string `json:"id,omitempty"`

	// Revenue: Required. Total non-zero revenue or grand total associated
	// with the transaction. This value include shipping, tax, or other
	// adjustments to total revenue that you want to include as part of your
	// revenue calculations.
	Revenue float64 `json:"revenue,omitempty"`

	// Tax: All the taxes associated with the transaction.
	Tax float64 `json:"tax,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cost") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cost") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2PurchaseTransaction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2PurchaseTransaction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudRetailV2PurchaseTransaction) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudRetailV2PurchaseTransaction
	var s1 struct {
		Cost    gensupport.JSONFloat64 `json:"cost"`
		Revenue gensupport.JSONFloat64 `json:"revenue"`
		Tax     gensupport.JSONFloat64 `json:"tax"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Cost = float64(s1.Cost)
	s.Revenue = float64(s1.Revenue)
	s.Tax = float64(s1.Tax)
	return nil
}

// GoogleCloudRetailV2PurgeMetadata: Metadata related to the progress of
// the Purge operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudRetailV2PurgeMetadata struct {
}

// GoogleCloudRetailV2PurgeUserEventsRequest: Request message for
// PurgeUserEvents method.
type GoogleCloudRetailV2PurgeUserEventsRequest struct {
	// Filter: Required. The filter string to specify the events to be
	// deleted with a length limit of 5,000 characters. Empty string filter
	// is not allowed. The eligible fields for filtering are: * `eventType`:
	// Double quoted UserEvent.event_type string. * `eventTime`: in ISO 8601
	// "zulu" format. * `visitorId`: Double quoted string. Specifying this
	// will delete all events associated with a visitor. * `userId`: Double
	// quoted string. Specifying this will delete all events associated with
	// a user. Examples: * Deleting all events in a time range: `eventTime >
	// "2012-04-23T18:25:43.511Z" eventTime < "2012-04-23T18:30:43.511Z" *
	// Deleting specific eventType in time range: `eventTime >
	// "2012-04-23T18:25:43.511Z" eventType = "detail-page-view" * Deleting
	// all events for a specific visitor: `visitorId = "visitor1024" The
	// filtering fields are assumed to have an implicit AND.
	Filter string `json:"filter,omitempty"`

	// Force: Actually perform the purge. If `force` is set to false, the
	// method will return the expected purge count without deleting any user
	// events.
	Force bool `json:"force,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Filter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2PurgeUserEventsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2PurgeUserEventsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2PurgeUserEventsResponse: Response of the
// PurgeUserEventsRequest. If the long running operation is successfully
// done, then this message is returned by the
// google.longrunning.Operations.response field.
type GoogleCloudRetailV2PurgeUserEventsResponse struct {
	// PurgedEventsCount: The total count of events purged as a result of
	// the operation.
	PurgedEventsCount int64 `json:"purgedEventsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "PurgedEventsCount")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PurgedEventsCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2PurgeUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2PurgeUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2Rating: The rating of a Product.
type GoogleCloudRetailV2Rating struct {
	// AverageRating: The average rating of the Product. The rating is
	// scaled at 1-5. Otherwise, an INVALID_ARGUMENT error is returned.
	AverageRating float64 `json:"averageRating,omitempty"`

	// RatingCount: The total number of ratings. This value is independent
	// of the value of rating_histogram. This value must be nonnegative.
	// Otherwise, an INVALID_ARGUMENT error is returned.
	RatingCount int64 `json:"ratingCount,omitempty"`

	// RatingHistogram: List of rating counts per rating value (index =
	// rating - 1). The list is empty if there is no rating. If the list is
	// non-empty, its size is always 5. Otherwise, an INVALID_ARGUMENT error
	// is returned. For example, [41, 14, 13, 47, 303]. It means that the
	// Product got 41 ratings with 1 star, 14 ratings with 2 star, and so
	// on.
	RatingHistogram []int64 `json:"ratingHistogram,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AverageRating") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AverageRating") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2Rating) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2Rating
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudRetailV2Rating) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudRetailV2Rating
	var s1 struct {
		AverageRating gensupport.JSONFloat64 `json:"averageRating"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AverageRating = float64(s1.AverageRating)
	return nil
}

// GoogleCloudRetailV2RejoinUserEventsMetadata: Metadata for
// RejoinUserEvents method.
type GoogleCloudRetailV2RejoinUserEventsMetadata struct {
}

// GoogleCloudRetailV2RejoinUserEventsRequest: Request message for
// RejoinUserEvents method.
type GoogleCloudRetailV2RejoinUserEventsRequest struct {
	// UserEventRejoinScope: The type of the user event rejoin to define the
	// scope and range of the user events to be rejoined with the latest
	// product catalog. Defaults to USER_EVENT_REJOIN_SCOPE_UNSPECIFIED if
	// this field is not set, or set to an invalid integer value.
	//
	// Possible values:
	//   "USER_EVENT_REJOIN_SCOPE_UNSPECIFIED" - Rejoin all events with the
	// latest product catalog, including both joined events and unjoined
	// events.
	//   "JOINED_EVENTS" - Only rejoin joined events with the latest product
	// catalog.
	//   "UNJOINED_EVENTS" - Only rejoin unjoined events with the latest
	// product catalog.
	UserEventRejoinScope string `json:"userEventRejoinScope,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "UserEventRejoinScope") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UserEventRejoinScope") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2RejoinUserEventsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2RejoinUserEventsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2RejoinUserEventsResponse: Response message for
// RejoinUserEvents method.
type GoogleCloudRetailV2RejoinUserEventsResponse struct {
	// RejoinedUserEventsCount: Number of user events that were joined with
	// latest product catalog.
	RejoinedUserEventsCount int64 `json:"rejoinedUserEventsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g.
	// "RejoinedUserEventsCount") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RejoinedUserEventsCount")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2RejoinUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2RejoinUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2RemoveFulfillmentPlacesMetadata: Metadata related
// to the progress of the RemoveFulfillmentPlaces operation. Currently
// empty because there is no meaningful metadata populated from the
// RemoveFulfillmentPlaces method.
type GoogleCloudRetailV2RemoveFulfillmentPlacesMetadata struct {
}

// GoogleCloudRetailV2RemoveFulfillmentPlacesRequest: Request message
// for RemoveFulfillmentPlaces method.
type GoogleCloudRetailV2RemoveFulfillmentPlacesRequest struct {
	// AllowMissing: If set to true, and the Product is not found, the
	// fulfillment information will still be processed and retained for at
	// most 1 day and processed once the Product is created. If set to
	// false, a NOT_FOUND error is returned if the Product is not found.
	AllowMissing bool `json:"allowMissing,omitempty"`

	// PlaceIds: Required. The IDs for this type, such as the store IDs for
	// "pickup-in-store" or the region IDs for "same-day-delivery", to be
	// removed for this type. At least 1 value is required, and a maximum of
	// 2000 values are allowed. Each value must be a string with a length
	// limit of 10 characters, matching the pattern `[a-zA-Z0-9_-]+`, such
	// as "store1" or "REGION-2". Otherwise, an INVALID_ARGUMENT error is
	// returned.
	PlaceIds []string `json:"placeIds,omitempty"`

	// RemoveTime: The time when the fulfillment updates are issued, used to
	// prevent out-of-order updates on fulfillment information. If not
	// provided, the internal system time will be used.
	RemoveTime string `json:"removeTime,omitempty"`

	// Type: Required. The fulfillment type, including commonly used types
	// (such as pickup in store and same day delivery), and custom types.
	// Supported values: * "pickup-in-store" * "ship-to-store" *
	// "same-day-delivery" * "next-day-delivery" * "custom-type-1" *
	// "custom-type-2" * "custom-type-3" * "custom-type-4" * "custom-type-5"
	// If this field is set to an invalid value other than these, an
	// INVALID_ARGUMENT error is returned. This field directly corresponds
	// to Product.fulfillment_info.type.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AllowMissing") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowMissing") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2RemoveFulfillmentPlacesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2RemoveFulfillmentPlacesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2RemoveFulfillmentPlacesResponse: Response of the
// RemoveFulfillmentPlacesRequest. Currently empty because there is no
// meaningful response populated from the RemoveFulfillmentPlaces
// method.
type GoogleCloudRetailV2RemoveFulfillmentPlacesResponse struct {
}

// GoogleCloudRetailV2SearchRequest: Request message for
// SearchService.Search method.
type GoogleCloudRetailV2SearchRequest struct {
	// BoostSpec: Boost specification to boost certain products. See more
	// details at this user guide
	// (https://cloud.google.com/retail/docs/boosting). Notice that if both
	// ServingConfig.boost_control_ids and [SearchRequest.boost_spec] are
	// set, the boost conditions from both places are evaluated. If a search
	// request matches multiple boost conditions, the final boost score is
	// equal to the sum of the boost scores from all matched boost
	// conditions.
	BoostSpec *GoogleCloudRetailV2SearchRequestBoostSpec `json:"boostSpec,omitempty"`

	// Branch: The branch resource name, such as
	// `projects/*/locations/global/catalogs/default_catalog/branches/0`.
	// Use "default_branch" as the branch ID or leave this field empty, to
	// search products under the default branch.
	Branch string `json:"branch,omitempty"`

	// CanonicalFilter: The filter applied to every search request when
	// quality improvement such as query expansion is needed. For example,
	// if a query does not have enough results, an expanded query with
	// SearchRequest.canonical_filter will be returned as a supplement of
	// the original query. This field is strongly recommended to achieve
	// high search quality. See SearchRequest.filter for more details about
	// filter syntax.
	CanonicalFilter string `json:"canonicalFilter,omitempty"`

	// DynamicFacetSpec: The specification for dynamically generated facets.
	// Notice that only textual facets can be dynamically generated. This
	// feature requires additional allowlisting. Contact Retail Search
	// support team if you are interested in using dynamic facet feature.
	DynamicFacetSpec *GoogleCloudRetailV2SearchRequestDynamicFacetSpec `json:"dynamicFacetSpec,omitempty"`

	// FacetSpecs: Facet specifications for faceted search. If empty, no
	// facets are returned. A maximum of 100 values are allowed. Otherwise,
	// an INVALID_ARGUMENT error is returned.
	FacetSpecs []*GoogleCloudRetailV2SearchRequestFacetSpec `json:"facetSpecs,omitempty"`

	// Filter: The filter syntax consists of an expression language for
	// constructing a predicate from one or more fields of the products
	// being filtered. Filter expression is case-sensitive. See more details
	// at this user guide
	// (https://cloud.google.com/retail/docs/filter-and-order#filter). If
	// this field is unrecognizable, an INVALID_ARGUMENT is returned.
	Filter string `json:"filter,omitempty"`

	// Offset: A 0-indexed integer that specifies the current offset (that
	// is, starting result location, amongst the Products deemed by the API
	// as relevant) in search results. This field is only considered if
	// page_token is unset. If this field is negative, an INVALID_ARGUMENT
	// is returned.
	Offset int64 `json:"offset,omitempty"`

	// OrderBy: The order in which products are returned. Products can be
	// ordered by a field in an Product object. Leave it unset if ordered by
	// relevance. OrderBy expression is case-sensitive. See more details at
	// this user guide
	// (https://cloud.google.com/retail/docs/filter-and-order#order). If
	// this field is unrecognizable, an INVALID_ARGUMENT is returned.
	OrderBy string `json:"orderBy,omitempty"`

	// PageCategories: The categories associated with a category page.
	// Required for category navigation queries to achieve good search
	// quality. The format should be the same as UserEvent.page_categories;
	// To represent full path of category, use '>' sign to separate
	// different hierarchies. If '>' is part of the category name, please
	// replace it with other character(s). Category pages include special
	// pages such as sales or promotions. For instance, a special sale page
	// may have the category hierarchy: "pageCategories" : ["Sales > 2017
	// Black Friday Deals"].
	PageCategories []string `json:"pageCategories,omitempty"`

	// PageSize: Maximum number of Products to return. If unspecified,
	// defaults to a reasonable value. The maximum allowed value is 120.
	// Values above 120 will be coerced to 120. If this field is negative,
	// an INVALID_ARGUMENT is returned.
	PageSize int64 `json:"pageSize,omitempty"`

	// PageToken: A page token SearchResponse.next_page_token, received from
	// a previous SearchService.Search call. Provide this to retrieve the
	// subsequent page. When paginating, all other parameters provided to
	// SearchService.Search must match the call that provided the page
	// token. Otherwise, an INVALID_ARGUMENT error is returned.
	PageToken string `json:"pageToken,omitempty"`

	// Query: Raw search query.
	Query string `json:"query,omitempty"`

	// QueryExpansionSpec: The query expansion specification that specifies
	// the conditions under which query expansion will occur. See more
	// details at this user guide
	// (https://cloud.google.com/retail/docs/result-size#query_expansion).
	QueryExpansionSpec *GoogleCloudRetailV2SearchRequestQueryExpansionSpec `json:"queryExpansionSpec,omitempty"`

	// SearchMode: The search mode of the search request. If not specified,
	// a single search request triggers both product search and faceted
	// search.
	//
	// Possible values:
	//   "SEARCH_MODE_UNSPECIFIED" - Default value. In this case both
	// product search and faceted search will be performed. Both
	// [SearchResponse.SearchResult] and [SearchResponse.Facet] will be
	// returned.
	//   "PRODUCT_SEARCH_ONLY" - Only product search will be performed. The
	// faceted search will be disabled. Only [SearchResponse.SearchResult]
	// will be returned. [SearchResponse.Facet] will not be returned, even
	// if SearchRequest.facet_specs or SearchRequest.dynamic_facet_spec is
	// set.
	//   "FACETED_SEARCH_ONLY" - Only faceted search will be performed. The
	// product search will be disabled. When in this mode, one or both of
	// SearchRequest.facet_spec and SearchRequest.dynamic_facet_spec should
	// be set. Otherwise, an INVALID_ARGUMENT error is returned. Only
	// [SearchResponse.Facet] will be returned.
	// [SearchResponse.SearchResult] will not be returned.
	SearchMode string `json:"searchMode,omitempty"`

	// UserInfo: User information.
	UserInfo *GoogleCloudRetailV2UserInfo `json:"userInfo,omitempty"`

	// VariantRollupKeys: The keys to fetch and rollup the matching variant
	// Products attributes. The attributes from all the matching variant
	// Products are merged and de-duplicated. Notice that rollup variant
	// Products attributes will lead to extra query latency. Maximum number
	// of keys is 10. For FulfillmentInfo, a fulfillment type and a
	// fulfillment ID must be provided in the format of
	// "fulfillmentType.fulfillmentId". E.g., in "pickupInStore.store123",
	// "pickupInStore" is fulfillment type and "store123" is the store ID.
	// Supported keys are: * colorFamilies * price * originalPrice *
	// discount * inventory(place_id,price) *
	// inventory(place_id,attributes.key), where key is any key in the
	// Product.inventories.attributes map. * attributes.key, where key is
	// any key in the Product.attributes map. * pickupInStore.id, where id
	// is any FulfillmentInfo.place_ids for FulfillmentInfo.type
	// "pickup-in-store". * shipToStore.id, where id is any
	// FulfillmentInfo.place_ids for FulfillmentInfo.type "ship-to-store". *
	// sameDayDelivery.id, where id is any FulfillmentInfo.place_ids for
	// FulfillmentInfo.type "same-day-delivery". * nextDayDelivery.id, where
	// id is any FulfillmentInfo.place_ids for FulfillmentInfo.type
	// "next-day-delivery". * customFulfillment1.id, where id is any
	// FulfillmentInfo.place_ids for FulfillmentInfo.type "custom-type-1". *
	// customFulfillment2.id, where id is any FulfillmentInfo.place_ids for
	// FulfillmentInfo.type "custom-type-2". * customFulfillment3.id, where
	// id is any FulfillmentInfo.place_ids for FulfillmentInfo.type
	// "custom-type-3". * customFulfillment4.id, where id is any
	// FulfillmentInfo.place_ids for FulfillmentInfo.type "custom-type-4". *
	// customFulfillment5.id, where id is any FulfillmentInfo.place_ids for
	// FulfillmentInfo.type "custom-type-5". If this field is set to an
	// invalid value other than these, an INVALID_ARGUMENT error is
	// returned.
	VariantRollupKeys []string `json:"variantRollupKeys,omitempty"`

	// VisitorId: Required. A unique identifier for tracking visitors. For
	// example, this could be implemented with an HTTP cookie, which should
	// be able to uniquely identify a visitor on a single device. This
	// unique identifier should not change if the visitor logs in or out of
	// the website. The field must be a UTF-8 encoded string with a length
	// limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is
	// returned.
	VisitorId string `json:"visitorId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BoostSpec") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BoostSpec") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2SearchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2SearchRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2SearchRequestBoostSpec: Boost specification to
// boost certain items.
type GoogleCloudRetailV2SearchRequestBoostSpec struct {
	// ConditionBoostSpecs: Condition boost specifications. If a product
	// matches multiple conditions in the specifictions, boost scores from
	// these specifications are all applied and combined in a non-linear
	// way. Maximum number of specifications is 10.
	ConditionBoostSpecs []*GoogleCloudRetailV2SearchRequestBoostSpecConditionBoostSpec `json:"conditionBoostSpecs,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConditionBoostSpecs")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConditionBoostSpecs") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2SearchRequestBoostSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2SearchRequestBoostSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2SearchRequestBoostSpecConditionBoostSpec: Boost
// applies to products which match a condition.
type GoogleCloudRetailV2SearchRequestBoostSpecConditionBoostSpec struct {
	// Boost: Strength of the condition boost, which should be in [-1, 1].
	// Negative boost means demotion. Default is 0.0. Setting to 1.0 gives
	// the item a big promotion. However, it does not necessarily mean that
	// the boosted item will be the top result at all times, nor that other
	// items will be excluded. Results could still be shown even when none
	// of them matches the condition. And results that are significantly
	// more relevant to the search query can still trump your heavily
	// favored but irrelevant items. Setting to -1.0 gives the item a big
	// demotion. However, results that are deeply relevant might still be
	// shown. The item will have an upstream battle to get a fairly high
	// ranking, but it is not blocked out completely. Setting to 0.0 means
	// no boost applied. The boosting condition is ignored.
	Boost float64 `json:"boost,omitempty"`

	// Condition: An expression which specifies a boost condition. The
	// syntax and supported fields are the same as a filter expression. See
	// SearchRequest.filter for detail syntax and limitations. Examples: *
	// To boost products with product ID "product_1" or "product_2", and
	// color "Red" or "Blue": * (id: ANY("product_1", "product_2")) AND
	// (colorFamilies: ANY("Red","Blue"))
	Condition string `json:"condition,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Boost") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Boost") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2SearchRequestBoostSpecConditionBoostSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2SearchRequestBoostSpecConditionBoostSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudRetailV2SearchRequestBoostSpecConditionBoostSpec) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudRetailV2SearchRequestBoostSpecConditionBoostSpec
	var s1 struct {
		Boost gensupport.JSONFloat64 `json:"boost"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Boost = float64(s1.Boost)
	return nil
}

// GoogleCloudRetailV2SearchRequestDynamicFacetSpec: The specifications
// of dynamically generated facets.
type GoogleCloudRetailV2SearchRequestDynamicFacetSpec struct {
	// Mode: Mode of the DynamicFacet feature. Defaults to Mode.DISABLED if
	// it's unset.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Default value.
	//   "DISABLED" - Disable Dynamic Facet.
	//   "ENABLED" - Automatic mode built by Google Retail Search.
	Mode string `json:"mode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Mode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Mode") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2SearchRequestDynamicFacetSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2SearchRequestDynamicFacetSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2SearchRequestFacetSpec: A facet specification to
// perform faceted search.
type GoogleCloudRetailV2SearchRequestFacetSpec struct {
	// EnableDynamicPosition: Enables dynamic position for this facet. If
	// set to true, the position of this facet among all facets in the
	// response is determined by Google Retail Search. It will be ordered
	// together with dynamic facets if dynamic facets is enabled. If set to
	// false, the position of this facet in the response will be the same as
	// in the request, and it will be ranked before the facets with dynamic
	// position enable and all dynamic facets. For example, you may always
	// want to have rating facet returned in the response, but it's not
	// necessarily to always display the rating facet at the top. In that
	// case, you can set enable_dynamic_position to true so that the
	// position of rating facet in response will be determined by Google
	// Retail Search. Another example, assuming you have the following
	// facets in the request: * "rating", enable_dynamic_position = true *
	// "price", enable_dynamic_position = false * "brands",
	// enable_dynamic_position = false And also you have a dynamic facets
	// enable, which will generate a facet 'gender'. Then the final order of
	// the facets in the response can be ("price", "brands", "rating",
	// "gender") or ("price", "brands", "gender", "rating") depends on how
	// Google Retail Search orders "gender" and "rating" facets. However,
	// notice that "price" and "brands" will always be ranked at 1st and 2nd
	// position since their enable_dynamic_position are false.
	EnableDynamicPosition bool `json:"enableDynamicPosition,omitempty"`

	// ExcludedFilterKeys: List of keys to exclude when faceting. By
	// default, FacetKey.key is not excluded from the filter unless it is
	// listed in this field. For example, suppose there are 100 products
	// with color facet "Red" and 200 products with color facet "Blue". A
	// query containing the filter "colorFamilies:ANY("Red")" and have
	// "colorFamilies" as FacetKey.key will by default return the "Red" with
	// count 100. If this field contains "colorFamilies", then the query
	// returns both the "Red" with count 100 and "Blue" with count 200,
	// because the "colorFamilies" key is now excluded from the filter. A
	// maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT
	// error is returned.
	ExcludedFilterKeys []string `json:"excludedFilterKeys,omitempty"`

	// FacetKey: Required. The facet key specification.
	FacetKey *GoogleCloudRetailV2SearchRequestFacetSpecFacetKey `json:"facetKey,omitempty"`

	// Limit: Maximum of facet values that should be returned for this
	// facet. If unspecified, defaults to 20. The maximum allowed value is
	// 300. Values above 300 will be coerced to 300. If this field is
	// negative, an INVALID_ARGUMENT is returned.
	Limit int64 `json:"limit,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "EnableDynamicPosition") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EnableDynamicPosition") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2SearchRequestFacetSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2SearchRequestFacetSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2SearchRequestFacetSpecFacetKey: Specifies how a
// facet is computed.
type GoogleCloudRetailV2SearchRequestFacetSpecFacetKey struct {
	// Contains: Only get facet values that contains the given strings. For
	// example, suppose "categories" has three values "Women > Shoe", "Women
	// > Dress" and "Men > Shoe". If set "contains" to "Shoe", the
	// "categories" facet will give only "Women > Shoe" and "Men > Shoe".
	// Only supported on textual fields. Maximum is 10.
	Contains []string `json:"contains,omitempty"`

	// Intervals: Set only if values should be bucketized into intervals.
	// Must be set for facets with numerical values. Must not be set for
	// facet with text values. Maximum number of intervals is 30.
	Intervals []*GoogleCloudRetailV2Interval `json:"intervals,omitempty"`

	// Key: Required. Supported textual and numerical facet keys in Product
	// object, over which the facet values are computed. Facet key is
	// case-sensitive. Allowed facet keys when FacetKey.query is not
	// specified: * textual_field = * "brands" * "categories" * "genders" *
	// "ageGroups" * "availability" * "colorFamilies" * "colors" * "sizes" *
	// "materials" * "patterns" * "conditions" * "attributes.key" *
	// "pickupInStore" * "shipToStore" * "sameDayDelivery" *
	// "nextDayDelivery" * "customFulfillment1" * "customFulfillment2" *
	// "customFulfillment3" * "customFulfillment4" * "customFulfillment5" *
	// "inventory(place_id,attributes.key)" * numerical_field = * "price" *
	// "discount" * "rating" * "ratingCount" * "attributes.key" *
	// "inventory(place_id,price)" * "inventory(place_id,attributes.key)"
	Key string `json:"key,omitempty"`

	// OrderBy: The order in which Facet.values are returned. Allowed values
	// are: * "count desc", which means order by Facet.FacetValue.count
	// descending. * "value desc", which means order by
	// Facet.FacetValue.value descending. Only applies to textual facets. If
	// not set, textual values are sorted in natural order
	// (https://en.wikipedia.org/wiki/Natural_sort_order); numerical
	// intervals are sorted in the order given by
	// FacetSpec.FacetKey.intervals; FulfillmentInfo.place_ids are sorted in
	// the order given by FacetSpec.FacetKey.restricted_values.
	OrderBy string `json:"orderBy,omitempty"`

	// Prefixes: Only get facet values that start with the given string
	// prefix. For example, suppose "categories" has three values "Women >
	// Shoe", "Women > Dress" and "Men > Shoe". If set "prefixes" to
	// "Women", the "categories" facet will give only "Women > Shoe" and
	// "Women > Dress". Only supported on textual fields. Maximum is 10.
	Prefixes []string `json:"prefixes,omitempty"`

	// Query: The query that is used to compute facet for the given facet
	// key. When provided, it will override the default behavior of facet
	// computation. The query syntax is the same as a filter expression. See
	// SearchRequest.filter for detail syntax and limitations. Notice that
	// there is no limitation on FacetKey.key when query is specified. In
	// the response, FacetValue.value will be always "1" and
	// FacetValue.count will be the number of results that matches the
	// query. For example, you can set a customized facet for "shipToStore",
	// where FacetKey.key is "customizedShipToStore", and FacetKey.query is
	// "availability: ANY(\"IN_STOCK\") AND shipToStore: ANY(\"123\")". Then
	// the facet will count the products that are both in stock and ship to
	// store "123".
	Query string `json:"query,omitempty"`

	// RestrictedValues: Only get facet for the given restricted values. For
	// example, when using "pickupInStore" as key and set restricted values
	// to ["store123", "store456"], only facets for "store123" and
	// "store456" are returned. Only supported on textual fields and
	// fulfillments. Maximum is 20. Must be set for the fulfillment facet
	// keys: * pickupInStore * shipToStore * sameDayDelivery *
	// nextDayDelivery * customFulfillment1 * customFulfillment2 *
	// customFulfillment3 * customFulfillment4 * customFulfillment5
	RestrictedValues []string `json:"restrictedValues,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Contains") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Contains") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2SearchRequestFacetSpecFacetKey) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2SearchRequestFacetSpecFacetKey
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2SearchRequestQueryExpansionSpec: Specification to
// determine under which conditions query expansion should occur.
type GoogleCloudRetailV2SearchRequestQueryExpansionSpec struct {
	// Condition: The condition under which query expansion should occur.
	// Default to Condition.DISABLED.
	//
	// Possible values:
	//   "CONDITION_UNSPECIFIED" - Unspecified query expansion condition.
	// This defaults to Condition.DISABLED.
	//   "DISABLED" - Disabled query expansion. Only the exact search query
	// is used, even if SearchResponse.total_size is zero.
	//   "AUTO" - Automatic query expansion built by Google Retail Search.
	Condition string `json:"condition,omitempty"`

	// PinUnexpandedResults: Whether to pin unexpanded results. If this
	// field is set to true, unexpanded products are always at the top of
	// the search results, followed by the expanded results.
	PinUnexpandedResults bool `json:"pinUnexpandedResults,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Condition") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2SearchRequestQueryExpansionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2SearchRequestQueryExpansionSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2SearchResponse: Response message for
// SearchService.Search method.
type GoogleCloudRetailV2SearchResponse struct {
	// AttributionToken: A unique search token. This should be included in
	// the UserEvent logs resulting from this search, which enables accurate
	// attribution of search model performance.
	AttributionToken string `json:"attributionToken,omitempty"`

	// CorrectedQuery: If spell correction applies, the corrected query.
	// Otherwise, empty.
	CorrectedQuery string `json:"correctedQuery,omitempty"`

	// Facets: Results of facets requested by user.
	Facets []*GoogleCloudRetailV2SearchResponseFacet `json:"facets,omitempty"`

	// NextPageToken: A token that can be sent as SearchRequest.page_token
	// to retrieve the next page. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// QueryExpansionInfo: Query expansion information for the returned
	// results.
	QueryExpansionInfo *GoogleCloudRetailV2SearchResponseQueryExpansionInfo `json:"queryExpansionInfo,omitempty"`

	// RedirectUri: The URI of a customer-defined redirect page. If redirect
	// action is triggered, no search will be performed, and only
	// redirect_uri and attribution_token will be set in the response.
	RedirectUri string `json:"redirectUri,omitempty"`

	// Results: A list of matched items. The order represents the ranking.
	Results []*GoogleCloudRetailV2SearchResponseSearchResult `json:"results,omitempty"`

	// TotalSize: The estimated total count of matched items irrespective of
	// pagination. The count of results returned by pagination may be less
	// than the total_size that matches.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AttributionToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttributionToken") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2SearchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2SearchResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2SearchResponseFacet: A facet result.
type GoogleCloudRetailV2SearchResponseFacet struct {
	// DynamicFacet: Whether the facet is dynamically generated.
	DynamicFacet bool `json:"dynamicFacet,omitempty"`

	// Key: The key for this facet. E.g., "colorFamilies" or "price" or
	// "attributes.attr1".
	Key string `json:"key,omitempty"`

	// Values: The facet values for this field.
	Values []*GoogleCloudRetailV2SearchResponseFacetFacetValue `json:"values,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DynamicFacet") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DynamicFacet") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2SearchResponseFacet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2SearchResponseFacet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2SearchResponseFacetFacetValue: A facet value which
// contains value names and their count.
type GoogleCloudRetailV2SearchResponseFacetFacetValue struct {
	// Count: Number of items that have this facet value.
	Count int64 `json:"count,omitempty,string"`

	// Interval: Interval value for a facet, such as [10, 20) for facet
	// "price".
	Interval *GoogleCloudRetailV2Interval `json:"interval,omitempty"`

	// Value: Text value of a facet, such as "Black" for facet
	// "colorFamilies".
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Count") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2SearchResponseFacetFacetValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2SearchResponseFacetFacetValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2SearchResponseQueryExpansionInfo: Information
// describing query expansion including whether expansion has occurred.
type GoogleCloudRetailV2SearchResponseQueryExpansionInfo struct {
	// ExpandedQuery: Bool describing whether query expansion has occurred.
	ExpandedQuery bool `json:"expandedQuery,omitempty"`

	// PinnedResultCount: Number of pinned results. This field will only be
	// set when expansion happens and
	// SearchRequest.QueryExpansionSpec.pin_unexpanded_results is set to
	// true.
	PinnedResultCount int64 `json:"pinnedResultCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "ExpandedQuery") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExpandedQuery") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2SearchResponseQueryExpansionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2SearchResponseQueryExpansionInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2SearchResponseSearchResult: Represents the search
// results.
type GoogleCloudRetailV2SearchResponseSearchResult struct {
	// Id: Product.id of the searched Product.
	Id string `json:"id,omitempty"`

	// MatchingVariantCount: The count of matched variant Products.
	MatchingVariantCount int64 `json:"matchingVariantCount,omitempty"`

	// MatchingVariantFields: If a variant Product matches the search query,
	// this map indicates which Product fields are matched. The key is the
	// Product.name, the value is a field mask of the matched Product
	// fields. If matched attributes cannot be determined, this map will be
	// empty. For example, a key "sku1" with field mask
	// "products.color_info" indicates there is a match between "sku1"
	// ColorInfo and the query.
	MatchingVariantFields map[string]string `json:"matchingVariantFields,omitempty"`

	// Product: The product data snippet in the search response. Only
	// Product.name is guaranteed to be populated. Product.variants contains
	// the product variants that match the search query. If there are
	// multiple product variants matching the query, top 5 most relevant
	// product variants are returned and ordered by relevancy. If relevancy
	// can be deternmined, use matching_variant_fields to look up matched
	// product variants fields. If relevancy cannot be determined, e.g. when
	// searching "shoe" all products in a shoe product can be a match, 5
	// product variants are returned but order is meaningless.
	Product *GoogleCloudRetailV2Product `json:"product,omitempty"`

	// VariantRollupValues: The rollup matching variant Product attributes.
	// The key is one of the SearchRequest.variant_rollup_keys. The values
	// are the merged and de-duplicated Product attributes. Notice that the
	// rollup values are respect filter. For example, when filtering by
	// "colorFamilies:ANY(\"red\")" and rollup "colorFamilies", only "red"
	// is returned. For textual and numerical attributes, the rollup values
	// is a list of string or double values with type
	// google.protobuf.ListValue. For example, if there are two variants
	// with colors "red" and "blue", the rollup values are { key:
	// "colorFamilies" value { list_value { values { string_value: "red" }
	// values { string_value: "blue" } } } } For FulfillmentInfo, the rollup
	// values is a double value with type google.protobuf.Value. For
	// example, `{key: "pickupInStore.store1" value { number_value: 10 }}`
	// means a there are 10 variants in this product are available in the
	// store "store1".
	VariantRollupValues googleapi.RawMessage `json:"variantRollupValues,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2SearchResponseSearchResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2SearchResponseSearchResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2SetDefaultBranchRequest: Request message to set a
// specified branch as new default_branch.
type GoogleCloudRetailV2SetDefaultBranchRequest struct {
	// BranchId: The final component of the resource name of a branch. This
	// field must be one of "0", "1" or "2". Otherwise, an INVALID_ARGUMENT
	// error is returned.
	BranchId string `json:"branchId,omitempty"`

	// Note: Some note on this request, this can be retrieved by
	// CatalogService.GetDefaultBranch before next valid default branch set
	// occurs. This field must be a UTF-8 encoded string with a length limit
	// of 1,000 characters. Otherwise, an INVALID_ARGUMENT error is
	// returned.
	Note string `json:"note,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BranchId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BranchId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2SetDefaultBranchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2SetDefaultBranchRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2SetInventoryMetadata: Metadata related to the
// progress of the SetInventory operation. Currently empty because there
// is no meaningful metadata populated from the SetInventory method.
type GoogleCloudRetailV2SetInventoryMetadata struct {
}

// GoogleCloudRetailV2SetInventoryRequest: Request message for
// SetInventory method.
type GoogleCloudRetailV2SetInventoryRequest struct {
	// AllowMissing: If set to true, and the Product with name Product.name
	// is not found, the inventory update will still be processed and
	// retained for at most 1 day until the Product is created. If set to
	// false, a NOT_FOUND error is returned if the Product is not found.
	AllowMissing bool `json:"allowMissing,omitempty"`

	// Inventory: Required. The inventory information to update. The
	// allowable fields to update are: * Product.price_info *
	// Product.availability * Product.available_quantity *
	// Product.fulfillment_info The updated inventory fields must be
	// specified in SetInventoryRequest.set_mask. If
	// SetInventoryRequest.inventory.name is empty or invalid, an
	// INVALID_ARGUMENT error is returned. If the caller does not have
	// permission to update the Product named in Product.name, regardless of
	// whether or not it exists, a PERMISSION_DENIED error is returned. If
	// the Product to update does not have existing inventory information,
	// the provided inventory information will be inserted. If the Product
	// to update has existing inventory information, the provided inventory
	// information will be merged while respecting the last update time for
	// each inventory field, using the provided or default value for
	// SetInventoryRequest.set_time. The last update time is recorded for
	// the following inventory fields: * Product.price_info *
	// Product.availability * Product.available_quantity *
	// Product.fulfillment_info If a full overwrite of inventory information
	// while ignoring timestamps is needed, UpdateProduct should be invoked
	// instead.
	Inventory *GoogleCloudRetailV2Product `json:"inventory,omitempty"`

	// SetMask: Indicates which inventory fields in the provided Product to
	// update. If not set or set with empty paths, all inventory fields will
	// be updated. If an unsupported or unknown field is provided, an
	// INVALID_ARGUMENT error is returned and the entire update will be
	// ignored.
	SetMask string `json:"setMask,omitempty"`

	// SetTime: The time when the request is issued, used to prevent
	// out-of-order updates on inventory fields with the last update time
	// recorded. If not provided, the internal system time will be used.
	SetTime string `json:"setTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AllowMissing") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowMissing") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2SetInventoryRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2SetInventoryRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2SetInventoryResponse: Response of the
// SetInventoryRequest. Currently empty because there is no meaningful
// response populated from the SetInventory method.
type GoogleCloudRetailV2SetInventoryResponse struct {
}

// GoogleCloudRetailV2UserEvent: UserEvent captures all metadata
// information Retail API needs to know about how end users interact
// with customers' website.
type GoogleCloudRetailV2UserEvent struct {
	// Attributes: Extra user event features to include in the
	// recommendation model. The key must be a UTF-8 encoded string with a
	// length limit of 5,000 characters. Otherwise, an INVALID_ARGUMENT
	// error is returned. For product recommendation, an example of extra
	// user information is traffic_channel, i.e. how user arrives at the
	// site. Users can arrive at the site by coming to the site directly, or
	// coming through Google search, and etc.
	Attributes map[string]GoogleCloudRetailV2CustomAttribute `json:"attributes,omitempty"`

	// AttributionToken: Highly recommended for user events that are the
	// result of PredictionService.Predict. This field enables accurate
	// attribution of recommendation model performance. The value must be a
	// valid PredictResponse.attribution_token for user events that are the
	// result of PredictionService.Predict. The value must be a valid
	// SearchResponse.attribution_token for user events that are the result
	// of SearchService.Search. This token enables us to accurately
	// attribute page view or purchase back to the event and the particular
	// predict response containing this clicked/purchased product. If user
	// clicks on product K in the recommendation results, pass
	// PredictResponse.attribution_token as a URL parameter to product K's
	// page. When recording events on product K's page, log the
	// PredictResponse.attribution_token to this field.
	AttributionToken string `json:"attributionToken,omitempty"`

	// CartId: The ID or name of the associated shopping cart. This ID is
	// used to associate multiple items added or present in the cart before
	// purchase. This can only be set for `add-to-cart`,
	// `purchase-complete`, or `shopping-cart-page-view` events.
	CartId string `json:"cartId,omitempty"`

	// CompletionDetail: The main completion details related to the event.
	// In a `completion` event, this field represents the completions
	// returned to the end user and the clicked completion by the end user.
	// In a `search` event, it represents the search event happens after
	// clicking completion.
	CompletionDetail *GoogleCloudRetailV2CompletionDetail `json:"completionDetail,omitempty"`

	// EventTime: Only required for UserEventService.ImportUserEvents
	// method. Timestamp of when the user event happened.
	EventTime string `json:"eventTime,omitempty"`

	// EventType: Required. User event type. Allowed values are: *
	// `add-to-cart`: Products being added to cart. * `category-page-view`:
	// Special pages such as sale or promotion pages viewed. * `completion`:
	// Completion query result showed/clicked. * `detail-page-view`:
	// Products detail page viewed. * `home-page-view`: Homepage viewed. *
	// `promotion-offered`: Promotion is offered to a user. *
	// `promotion-not-offered`: Promotion is not offered to a user. *
	// `purchase-complete`: User finishing a purchase. * `search`: Product
	// search. * `shopping-cart-page-view`: User viewing a shopping cart.
	EventType string `json:"eventType,omitempty"`

	// ExperimentIds: A list of identifiers for the independent experiment
	// groups this user event belongs to. This is used to distinguish
	// between user events associated with different experiment setups (e.g.
	// using Retail API, using different recommendation models).
	ExperimentIds []string `json:"experimentIds,omitempty"`

	// Filter: The filter syntax consists of an expression language for
	// constructing a predicate from one or more fields of the products
	// being filtered. See SearchRequest.filter for definition and syntax.
	// The value must be a UTF-8 encoded string with a length limit of 1,000
	// characters. Otherwise, an INVALID_ARGUMENT error is returned.
	Filter string `json:"filter,omitempty"`

	// Offset: An integer that specifies the current offset for pagination
	// (the 0-indexed starting location, amongst the products deemed by the
	// API as relevant). See SearchRequest.offset for definition. If this
	// field is negative, an INVALID_ARGUMENT is returned. This can only be
	// set for `search` events. Other event types should not set this field.
	// Otherwise, an INVALID_ARGUMENT error is returned.
	Offset int64 `json:"offset,omitempty"`

	// OrderBy: The order in which products are returned. See
	// SearchRequest.order_by for definition and syntax. The value must be a
	// UTF-8 encoded string with a length limit of 1,000 characters.
	// Otherwise, an INVALID_ARGUMENT error is returned. This can only be
	// set for `search` events. Other event types should not set this field.
	// Otherwise, an INVALID_ARGUMENT error is returned.
	OrderBy string `json:"orderBy,omitempty"`

	// PageCategories: The categories associated with a category page. To
	// represent full path of category, use '>' sign to separate different
	// hierarchies. If '>' is part of the category name, please replace it
	// with other character(s). Category pages include special pages such as
	// sales or promotions. For instance, a special sale page may have the
	// category hierarchy: "pageCategories" : ["Sales > 2017 Black Friday
	// Deals"]. Required for `category-page-view` events. At least one of
	// search_query or page_categories is required for `search` events.
	// Other event types should not set this field. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	PageCategories []string `json:"pageCategories,omitempty"`

	// PageViewId: A unique ID of a web page view. This should be kept the
	// same for all user events triggered from the same pageview. For
	// example, an item detail page view could trigger multiple events as
	// the user is browsing the page. The `pageViewId` property should be
	// kept the same for all these events so that they can be grouped
	// together properly. When using the client side event reporting with
	// JavaScript pixel and Google Tag Manager, this value is filled in
	// automatically.
	PageViewId string `json:"pageViewId,omitempty"`

	// ProductDetails: The main product details related to the event. This
	// field is required for the following event types: * `add-to-cart` *
	// `detail-page-view` * `purchase-complete` In a `search` event, this
	// field represents the products returned to the end user on the current
	// page (the end user may have not finished browsing the whole page
	// yet). When a new page is returned to the end user, after
	// pagination/filtering/ordering even for the same query, a new `search`
	// event with different product_details is desired. The end user may
	// have not finished browsing the whole page yet.
	ProductDetails []*GoogleCloudRetailV2ProductDetail `json:"productDetails,omitempty"`

	// PurchaseTransaction: A transaction represents the entire purchase
	// transaction. Required for `purchase-complete` events. Other event
	// types should not set this field. Otherwise, an INVALID_ARGUMENT error
	// is returned.
	PurchaseTransaction *GoogleCloudRetailV2PurchaseTransaction `json:"purchaseTransaction,omitempty"`

	// ReferrerUri: The referrer URL of the current page. When using the
	// client side event reporting with JavaScript pixel and Google Tag
	// Manager, this value is filled in automatically.
	ReferrerUri string `json:"referrerUri,omitempty"`

	// SearchQuery: The user's search query. See SearchRequest.query for
	// definition. The value must be a UTF-8 encoded string with a length
	// limit of 5,000 characters. Otherwise, an INVALID_ARGUMENT error is
	// returned. At least one of search_query or page_categories is required
	// for `search` events. Other event types should not set this field.
	// Otherwise, an INVALID_ARGUMENT error is returned.
	SearchQuery string `json:"searchQuery,omitempty"`

	// SessionId: A unique identifier for tracking a visitor session with a
	// length limit of 128 bytes. A session is an aggregation of an end user
	// behavior in a time span. A general guideline to populate the
	// sesion_id: 1. If user has no activity for 30 min, a new session_id
	// should be assigned. 2. The session_id should be unique across users,
	// suggest use uuid or add visitor_id as prefix.
	SessionId string `json:"sessionId,omitempty"`

	// Uri: Complete URL (window.location.href) of the user's current page.
	// When using the client side event reporting with JavaScript pixel and
	// Google Tag Manager, this value is filled in automatically. Maximum
	// length 5,000 characters.
	Uri string `json:"uri,omitempty"`

	// UserInfo: User information.
	UserInfo *GoogleCloudRetailV2UserInfo `json:"userInfo,omitempty"`

	// VisitorId: Required. A unique identifier for tracking visitors. For
	// example, this could be implemented with an HTTP cookie, which should
	// be able to uniquely identify a visitor on a single device. This
	// unique identifier should not change if the visitor log in/out of the
	// website. The field must be a UTF-8 encoded string with a length limit
	// of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned.
	// The field should not contain PII or user-data. We recommend to use
	// Google Analystics Client ID
	// (https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId)
	// for this field.
	VisitorId string `json:"visitorId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Attributes") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2UserEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2UserEvent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2UserEventImportSummary: A summary of import
// result. The UserEventImportSummary summarizes the import status for
// user events.
type GoogleCloudRetailV2UserEventImportSummary struct {
	// JoinedEventsCount: Count of user events imported with complete
	// existing catalog information.
	JoinedEventsCount int64 `json:"joinedEventsCount,omitempty,string"`

	// UnjoinedEventsCount: Count of user events imported, but with catalog
	// information not found in the imported catalog.
	UnjoinedEventsCount int64 `json:"unjoinedEventsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "JoinedEventsCount")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "JoinedEventsCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2UserEventImportSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2UserEventImportSummary
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2UserEventInlineSource: The inline source for the
// input config for ImportUserEvents method.
type GoogleCloudRetailV2UserEventInlineSource struct {
	// UserEvents: Required. A list of user events to import. Recommended
	// max of 10k items.
	UserEvents []*GoogleCloudRetailV2UserEvent `json:"userEvents,omitempty"`

	// ForceSendFields is a list of field names (e.g. "UserEvents") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UserEvents") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2UserEventInlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2UserEventInlineSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2UserEventInputConfig: The input config source for
// user events.
type GoogleCloudRetailV2UserEventInputConfig struct {
	// BigQuerySource: Required. BigQuery input source.
	BigQuerySource *GoogleCloudRetailV2BigQuerySource `json:"bigQuerySource,omitempty"`

	// GcsSource: Required. Google Cloud Storage location for the input
	// content.
	GcsSource *GoogleCloudRetailV2GcsSource `json:"gcsSource,omitempty"`

	// UserEventInlineSource: Required. The Inline source for the input
	// content for UserEvents.
	UserEventInlineSource *GoogleCloudRetailV2UserEventInlineSource `json:"userEventInlineSource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BigQuerySource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigQuerySource") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2UserEventInputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2UserEventInputConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2UserInfo: Information of an end user.
type GoogleCloudRetailV2UserInfo struct {
	// DirectUserRequest: True if the request is made directly from the end
	// user, in which case the ip_address and user_agent can be populated
	// from the HTTP request. This flag should be set only if the API
	// request is made directly from the end user such as a mobile app (and
	// not if a gateway or a server is processing and pushing the user
	// events). This should not be set when using the JavaScript tag in
	// UserEventService.CollectUserEvent.
	DirectUserRequest bool `json:"directUserRequest,omitempty"`

	// IpAddress: The end user's IP address. Required for getting
	// SearchResponse.sponsored_results. This field is used to extract
	// location information for personalization. This field must be either
	// an IPv4 address (e.g. "104.133.9.80") or an IPv6 address (e.g.
	// "2001:0db8:85a3:0000:0000:8a2e:0370:7334"). Otherwise, an
	// INVALID_ARGUMENT error is returned. This should not be set when using
	// the JavaScript tag in UserEventService.CollectUserEvent or if
	// direct_user_request is set.
	IpAddress string `json:"ipAddress,omitempty"`

	// UserAgent: User agent as included in the HTTP header. Required for
	// getting SearchResponse.sponsored_results. The field must be a UTF-8
	// encoded string with a length limit of 1,000 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned. This should not be set when using
	// the client side event reporting with GTM or JavaScript tag in
	// UserEventService.CollectUserEvent or if direct_user_request is set.
	UserAgent string `json:"userAgent,omitempty"`

	// UserId: Highly recommended for logged-in users. Unique identifier for
	// logged-in user, such as a user name. The field must be a UTF-8
	// encoded string with a length limit of 128 characters. Otherwise, an
	// INVALID_ARGUMENT error is returned.
	UserId string `json:"userId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DirectUserRequest")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DirectUserRequest") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2UserInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2UserInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaAddFulfillmentPlacesMetadata: Metadata
// related to the progress of the AddFulfillmentPlaces operation.
// Currently empty because there is no meaningful metadata populated
// from the AddFulfillmentPlaces method.
type GoogleCloudRetailV2alphaAddFulfillmentPlacesMetadata struct {
}

// GoogleCloudRetailV2alphaAddFulfillmentPlacesResponse: Response of the
// AddFulfillmentPlacesRequest. Currently empty because there is no
// meaningful response populated from the AddFulfillmentPlaces method.
type GoogleCloudRetailV2alphaAddFulfillmentPlacesResponse struct {
}

// GoogleCloudRetailV2alphaAddLocalInventoriesMetadata: Metadata related
// to the progress of the AddLocalInventories operation. Currently empty
// because there is no meaningful metadata populated from the
// AddLocalInventories method.
type GoogleCloudRetailV2alphaAddLocalInventoriesMetadata struct {
}

// GoogleCloudRetailV2alphaAddLocalInventoriesResponse: Response of the
// AddLocalInventories API. Currently empty because there is no
// meaningful response populated from the AddLocalInventories method.
type GoogleCloudRetailV2alphaAddLocalInventoriesResponse struct {
}

// GoogleCloudRetailV2alphaExportErrorsConfig: Configuration of
// destination for Export related errors.
type GoogleCloudRetailV2alphaExportErrorsConfig struct {
	// GcsPrefix: Google Cloud Storage path for import errors. This must be
	// an empty, existing Cloud Storage bucket. Export errors will be
	// written to a file in this bucket, one per line, as a JSON-encoded
	// `google.rpc.Status` message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsPrefix") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaExportErrorsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaExportErrorsConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaExportMetadata: Metadata related to the
// progress of the Export operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudRetailV2alphaExportMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaExportMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaExportMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaExportProductsResponse: Response of the
// ExportProductsRequest. If the long running operation is done, then
// this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudRetailV2alphaExportProductsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ErrorsConfig: Echoes the destination for the complete errors in the
	// request if set.
	ErrorsConfig *GoogleCloudRetailV2alphaExportErrorsConfig `json:"errorsConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorSamples") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaExportProductsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaExportProductsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaExportUserEventsResponse: Response of the
// ExportUserEventsRequest. If the long running operation was
// successful, then this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudRetailV2alphaExportUserEventsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ErrorsConfig: Echoes the destination for the complete errors if this
	// field was set in the request.
	ErrorsConfig *GoogleCloudRetailV2alphaExportErrorsConfig `json:"errorsConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorSamples") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaExportUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaExportUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaImportCompletionDataResponse: Response of the
// ImportCompletionDataRequest. If the long running operation is done,
// this message is returned by the
// google.longrunning.Operations.response field if the operation is
// successful.
type GoogleCloudRetailV2alphaImportCompletionDataResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorSamples") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaImportCompletionDataResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaImportCompletionDataResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaImportErrorsConfig: Configuration of
// destination for Import related errors.
type GoogleCloudRetailV2alphaImportErrorsConfig struct {
	// GcsPrefix: Google Cloud Storage path for import errors. This must be
	// an empty, existing Cloud Storage bucket. Import errors will be
	// written to a file in this bucket, one per line, as a JSON-encoded
	// `google.rpc.Status` message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsPrefix") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaImportErrorsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaImportErrorsConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaImportMetadata: Metadata related to the
// progress of the Import operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudRetailV2alphaImportMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// FailureCount: Count of entries that encountered errors while
	// processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`

	// NotificationPubsubTopic: Pub/Sub topic for receiving notification. If
	// this field is set, when the import is finished, a notification will
	// be sent to specified Pub/Sub topic. The message data will be JSON
	// string of a Operation. Format of the Pub/Sub topic is
	// `projects/{project}/topics/{topic}`.
	NotificationPubsubTopic string `json:"notificationPubsubTopic,omitempty"`

	// RequestId: Id of the request / operation. This is parroting back the
	// requestId that was passed in the request.
	RequestId string `json:"requestId,omitempty"`

	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaImportMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaImportMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaImportProductsResponse: Response of the
// ImportProductsRequest. If the long running operation is done, then
// this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudRetailV2alphaImportProductsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ErrorsConfig: Echoes the destination for the complete errors in the
	// request if set.
	ErrorsConfig *GoogleCloudRetailV2alphaImportErrorsConfig `json:"errorsConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorSamples") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaImportProductsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaImportProductsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaImportUserEventsResponse: Response of the
// ImportUserEventsRequest. If the long running operation was
// successful, then this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudRetailV2alphaImportUserEventsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ErrorsConfig: Echoes the destination for the complete errors if this
	// field was set in the request.
	ErrorsConfig *GoogleCloudRetailV2alphaImportErrorsConfig `json:"errorsConfig,omitempty"`

	// ImportSummary: Aggregated statistics of user event import status.
	ImportSummary *GoogleCloudRetailV2alphaUserEventImportSummary `json:"importSummary,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorSamples") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaImportUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaImportUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaPurgeMetadata: Metadata related to the
// progress of the Purge operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudRetailV2alphaPurgeMetadata struct {
}

// GoogleCloudRetailV2alphaPurgeUserEventsResponse: Response of the
// PurgeUserEventsRequest. If the long running operation is successfully
// done, then this message is returned by the
// google.longrunning.Operations.response field.
type GoogleCloudRetailV2alphaPurgeUserEventsResponse struct {
	// PurgedEventsCount: The total count of events purged as a result of
	// the operation.
	PurgedEventsCount int64 `json:"purgedEventsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "PurgedEventsCount")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PurgedEventsCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaPurgeUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaPurgeUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaRejoinUserEventsMetadata: Metadata for
// RejoinUserEvents method.
type GoogleCloudRetailV2alphaRejoinUserEventsMetadata struct {
}

// GoogleCloudRetailV2alphaRejoinUserEventsResponse: Response message
// for RejoinUserEvents method.
type GoogleCloudRetailV2alphaRejoinUserEventsResponse struct {
	// RejoinedUserEventsCount: Number of user events that were joined with
	// latest product catalog.
	RejoinedUserEventsCount int64 `json:"rejoinedUserEventsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g.
	// "RejoinedUserEventsCount") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RejoinedUserEventsCount")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaRejoinUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaRejoinUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2alphaRemoveFulfillmentPlacesMetadata: Metadata
// related to the progress of the RemoveFulfillmentPlaces operation.
// Currently empty because there is no meaningful metadata populated
// from the RemoveFulfillmentPlaces method.
type GoogleCloudRetailV2alphaRemoveFulfillmentPlacesMetadata struct {
}

// GoogleCloudRetailV2alphaRemoveFulfillmentPlacesResponse: Response of
// the RemoveFulfillmentPlacesRequest. Currently empty because there is
// no meaningful response populated from the RemoveFulfillmentPlaces
// method.
type GoogleCloudRetailV2alphaRemoveFulfillmentPlacesResponse struct {
}

// GoogleCloudRetailV2alphaRemoveLocalInventoriesMetadata: Metadata
// related to the progress of the RemoveLocalInventories operation.
// Currently empty because there is no meaningful metadata populated
// from the RemoveLocalInventories method.
type GoogleCloudRetailV2alphaRemoveLocalInventoriesMetadata struct {
}

// GoogleCloudRetailV2alphaRemoveLocalInventoriesResponse: Response of
// the RemoveLocalInventories API. Currently empty because there is no
// meaningful response populated from the RemoveLocalInventories method.
type GoogleCloudRetailV2alphaRemoveLocalInventoriesResponse struct {
}

// GoogleCloudRetailV2alphaSetInventoryMetadata: Metadata related to the
// progress of the SetInventory operation. Currently empty because there
// is no meaningful metadata populated from the SetInventory method.
type GoogleCloudRetailV2alphaSetInventoryMetadata struct {
}

// GoogleCloudRetailV2alphaSetInventoryResponse: Response of the
// SetInventoryRequest. Currently empty because there is no meaningful
// response populated from the SetInventory method.
type GoogleCloudRetailV2alphaSetInventoryResponse struct {
}

// GoogleCloudRetailV2alphaUserEventImportSummary: A summary of import
// result. The UserEventImportSummary summarizes the import status for
// user events.
type GoogleCloudRetailV2alphaUserEventImportSummary struct {
	// JoinedEventsCount: Count of user events imported with complete
	// existing catalog information.
	JoinedEventsCount int64 `json:"joinedEventsCount,omitempty,string"`

	// UnjoinedEventsCount: Count of user events imported, but with catalog
	// information not found in the imported catalog.
	UnjoinedEventsCount int64 `json:"unjoinedEventsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "JoinedEventsCount")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "JoinedEventsCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2alphaUserEventImportSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2alphaUserEventImportSummary
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaAddFulfillmentPlacesMetadata: Metadata related
// to the progress of the AddFulfillmentPlaces operation. Currently
// empty because there is no meaningful metadata populated from the
// AddFulfillmentPlaces method.
type GoogleCloudRetailV2betaAddFulfillmentPlacesMetadata struct {
}

// GoogleCloudRetailV2betaAddFulfillmentPlacesResponse: Response of the
// AddFulfillmentPlacesRequest. Currently empty because there is no
// meaningful response populated from the AddFulfillmentPlaces method.
type GoogleCloudRetailV2betaAddFulfillmentPlacesResponse struct {
}

// GoogleCloudRetailV2betaExportErrorsConfig: Configuration of
// destination for Export related errors.
type GoogleCloudRetailV2betaExportErrorsConfig struct {
	// GcsPrefix: Google Cloud Storage path for import errors. This must be
	// an empty, existing Cloud Storage bucket. Export errors will be
	// written to a file in this bucket, one per line, as a JSON-encoded
	// `google.rpc.Status` message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsPrefix") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2betaExportErrorsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaExportErrorsConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaExportMetadata: Metadata related to the
// progress of the Export operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudRetailV2betaExportMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2betaExportMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaExportMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaExportProductsResponse: Response of the
// ExportProductsRequest. If the long running operation is done, then
// this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudRetailV2betaExportProductsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ErrorsConfig: Echoes the destination for the complete errors in the
	// request if set.
	ErrorsConfig *GoogleCloudRetailV2betaExportErrorsConfig `json:"errorsConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorSamples") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2betaExportProductsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaExportProductsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaExportUserEventsResponse: Response of the
// ExportUserEventsRequest. If the long running operation was
// successful, then this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudRetailV2betaExportUserEventsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ErrorsConfig: Echoes the destination for the complete errors if this
	// field was set in the request.
	ErrorsConfig *GoogleCloudRetailV2betaExportErrorsConfig `json:"errorsConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorSamples") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2betaExportUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaExportUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaImportCompletionDataResponse: Response of the
// ImportCompletionDataRequest. If the long running operation is done,
// this message is returned by the
// google.longrunning.Operations.response field if the operation is
// successful.
type GoogleCloudRetailV2betaImportCompletionDataResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorSamples") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2betaImportCompletionDataResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaImportCompletionDataResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaImportErrorsConfig: Configuration of
// destination for Import related errors.
type GoogleCloudRetailV2betaImportErrorsConfig struct {
	// GcsPrefix: Google Cloud Storage path for import errors. This must be
	// an empty, existing Cloud Storage bucket. Import errors will be
	// written to a file in this bucket, one per line, as a JSON-encoded
	// `google.rpc.Status` message.
	GcsPrefix string `json:"gcsPrefix,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GcsPrefix") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GcsPrefix") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2betaImportErrorsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaImportErrorsConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaImportMetadata: Metadata related to the
// progress of the Import operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudRetailV2betaImportMetadata struct {
	// CreateTime: Operation create time.
	CreateTime string `json:"createTime,omitempty"`

	// FailureCount: Count of entries that encountered errors while
	// processing.
	FailureCount int64 `json:"failureCount,omitempty,string"`

	// NotificationPubsubTopic: Pub/Sub topic for receiving notification. If
	// this field is set, when the import is finished, a notification will
	// be sent to specified Pub/Sub topic. The message data will be JSON
	// string of a Operation. Format of the Pub/Sub topic is
	// `projects/{project}/topics/{topic}`.
	NotificationPubsubTopic string `json:"notificationPubsubTopic,omitempty"`

	// RequestId: Id of the request / operation. This is parroting back the
	// requestId that was passed in the request.
	RequestId string `json:"requestId,omitempty"`

	// SuccessCount: Count of entries that were processed successfully.
	SuccessCount int64 `json:"successCount,omitempty,string"`

	// UpdateTime: Operation last update time. If the operation is done,
	// this is also the finish time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2betaImportMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaImportMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaImportProductsResponse: Response of the
// ImportProductsRequest. If the long running operation is done, then
// this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudRetailV2betaImportProductsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ErrorsConfig: Echoes the destination for the complete errors in the
	// request if set.
	ErrorsConfig *GoogleCloudRetailV2betaImportErrorsConfig `json:"errorsConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorSamples") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2betaImportProductsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaImportProductsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaImportUserEventsResponse: Response of the
// ImportUserEventsRequest. If the long running operation was
// successful, then this message is returned by the
// google.longrunning.Operations.response field if the operation was
// successful.
type GoogleCloudRetailV2betaImportUserEventsResponse struct {
	// ErrorSamples: A sample of errors encountered while processing the
	// request.
	ErrorSamples []*GoogleRpcStatus `json:"errorSamples,omitempty"`

	// ErrorsConfig: Echoes the destination for the complete errors if this
	// field was set in the request.
	ErrorsConfig *GoogleCloudRetailV2betaImportErrorsConfig `json:"errorsConfig,omitempty"`

	// ImportSummary: Aggregated statistics of user event import status.
	ImportSummary *GoogleCloudRetailV2betaUserEventImportSummary `json:"importSummary,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ErrorSamples") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorSamples") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2betaImportUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaImportUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaPurgeMetadata: Metadata related to the
// progress of the Purge operation. This will be returned by the
// google.longrunning.Operation.metadata field.
type GoogleCloudRetailV2betaPurgeMetadata struct {
}

// GoogleCloudRetailV2betaPurgeUserEventsResponse: Response of the
// PurgeUserEventsRequest. If the long running operation is successfully
// done, then this message is returned by the
// google.longrunning.Operations.response field.
type GoogleCloudRetailV2betaPurgeUserEventsResponse struct {
	// PurgedEventsCount: The total count of events purged as a result of
	// the operation.
	PurgedEventsCount int64 `json:"purgedEventsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "PurgedEventsCount")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PurgedEventsCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2betaPurgeUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaPurgeUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaRejoinUserEventsMetadata: Metadata for
// RejoinUserEvents method.
type GoogleCloudRetailV2betaRejoinUserEventsMetadata struct {
}

// GoogleCloudRetailV2betaRejoinUserEventsResponse: Response message for
// RejoinUserEvents method.
type GoogleCloudRetailV2betaRejoinUserEventsResponse struct {
	// RejoinedUserEventsCount: Number of user events that were joined with
	// latest product catalog.
	RejoinedUserEventsCount int64 `json:"rejoinedUserEventsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g.
	// "RejoinedUserEventsCount") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RejoinedUserEventsCount")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2betaRejoinUserEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaRejoinUserEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudRetailV2betaRemoveFulfillmentPlacesMetadata: Metadata
// related to the progress of the RemoveFulfillmentPlaces operation.
// Currently empty because there is no meaningful metadata populated
// from the RemoveFulfillmentPlaces method.
type GoogleCloudRetailV2betaRemoveFulfillmentPlacesMetadata struct {
}

// GoogleCloudRetailV2betaRemoveFulfillmentPlacesResponse: Response of
// the RemoveFulfillmentPlacesRequest. Currently empty because there is
// no meaningful response populated from the RemoveFulfillmentPlaces
// method.
type GoogleCloudRetailV2betaRemoveFulfillmentPlacesResponse struct {
}

// GoogleCloudRetailV2betaSetInventoryMetadata: Metadata related to the
// progress of the SetInventory operation. Currently empty because there
// is no meaningful metadata populated from the SetInventory method.
type GoogleCloudRetailV2betaSetInventoryMetadata struct {
}

// GoogleCloudRetailV2betaSetInventoryResponse: Response of the
// SetInventoryRequest. Currently empty because there is no meaningful
// response populated from the SetInventory method.
type GoogleCloudRetailV2betaSetInventoryResponse struct {
}

// GoogleCloudRetailV2betaUserEventImportSummary: A summary of import
// result. The UserEventImportSummary summarizes the import status for
// user events.
type GoogleCloudRetailV2betaUserEventImportSummary struct {
	// JoinedEventsCount: Count of user events imported with complete
	// existing catalog information.
	JoinedEventsCount int64 `json:"joinedEventsCount,omitempty,string"`

	// UnjoinedEventsCount: Count of user events imported, but with catalog
	// information not found in the imported catalog.
	UnjoinedEventsCount int64 `json:"unjoinedEventsCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "JoinedEventsCount")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "JoinedEventsCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudRetailV2betaUserEventImportSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRetailV2betaUserEventImportSummary
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningListOperationsResponse: The response message for
// Operations.ListOperations.
type GoogleLongrunningListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Operations: A list of operations that matches the specified filter in
	// the request.
	Operations []*GoogleLongrunningOperation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleLongrunningListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningListOperationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningOperation: This resource represents a long-running
// operation that is the result of a network API call.
type GoogleLongrunningOperation struct {
	// Done: If the value is `false`, it means the operation is still in
	// progress. If `true`, the operation is completed, and either `error`
	// or `response` is available.
	Done bool `json:"done,omitempty"`

	// Error: The error result of the operation in case of failure or
	// cancellation.
	Error *GoogleRpcStatus `json:"error,omitempty"`

	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as
	// create time. Some services might not provide such metadata. Any
	// method that returns a long-running operation should document the
	// metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: The server-assigned name, which is only unique within the same
	// service that originally returns it. If you use the default HTTP
	// mapping, the `name` should be a resource name ending with
	// `operations/{unique_id}`.
	Name string `json:"name,omitempty"`

	// Response: The normal response of the operation in case of success. If
	// the original method returns no data on success, such as `Delete`, the
	// response is `google.protobuf.Empty`. If the original method is
	// standard `Get`/`Create`/`Update`, the response should be the
	// resource. For other methods, the response should have the type
	// `XxxResponse`, where `Xxx` is the original method name. For example,
	// if the original method name is `TakeSnapshot()`, the inferred
	// response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Done") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Done") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleLongrunningOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningOperation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to
// avoid defining duplicated empty messages in your APIs. A typical
// example is to use it as the request or the response type of an API
// method. For instance: service Foo { rpc Bar(google.protobuf.Empty)
// returns (google.protobuf.Empty); } The JSON representation for
// `Empty` is empty JSON object `{}`.
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleRpcStatus: The `Status` type defines a logical error model that
// is suitable for different programming environments, including REST
// APIs and RPC APIs. It is used by gRPC (https://github.com/grpc). Each
// `Status` message contains three pieces of data: error code, error
// message, and error details. You can find out more about this error
// model and how to work with it in the API Design Guide
// (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of
	// google.rpc.Code.
	Code int64 `json:"code,omitempty"`

	// Details: A list of messages that carry the error details. There is a
	// common set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`

	// Message: A developer-facing error message, which should be in
	// English. Any user-facing error message should be localized and sent
	// in the google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleTypeDate: Represents a whole or partial calendar date, such as
// a birthday. The time of day and time zone are either specified
// elsewhere or are insignificant. The date is relative to the Gregorian
// Calendar. This can represent one of the following: * A full date,
// with non-zero year, month, and day values * A month and day value,
// with a zero year, such as an anniversary * A year on its own, with
// zero month and day values * A year and month value, with a zero day,
// such as a credit card expiration date Related types are
// google.type.TimeOfDay and `google.protobuf.Timestamp`.
type GoogleTypeDate struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and
	// month, or 0 to specify a year by itself or a year and month where the
	// day isn't significant.
	Day int64 `json:"day,omitempty"`

	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year
	// without a month and day.
	Month int64 `json:"month,omitempty"`

	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a
	// date without a year.
	Year int64 `json:"year,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Day") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Day") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeDate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeDate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "retail.projects.locations.catalogs.completeQuery":

type ProjectsLocationsCatalogsCompleteQueryCall struct {
	s            *Service
	catalog      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// CompleteQuery: Completes the specified prefix with keyword
// suggestions. This feature is only available for users who have Retail
// Search enabled. Please submit a form here
// (https://cloud.google.com/contact) to contact cloud sales if you are
// interested in using Retail Search.
//
// - catalog: Catalog for which the completion is performed. Full
//   resource name of catalog, such as
//   `projects/*/locations/global/catalogs/default_catalog`.
func (r *ProjectsLocationsCatalogsService) CompleteQuery(catalog string) *ProjectsLocationsCatalogsCompleteQueryCall {
	c := &ProjectsLocationsCatalogsCompleteQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.catalog = catalog
	return c
}

// Dataset sets the optional parameter "dataset": Determines which
// dataset to use for fetching completion. "user-data" will use the
// imported dataset through CompletionService.ImportCompletionData.
// "cloud-retail" will use the dataset generated by cloud retail based
// on user events. If leave empty, it will use the "user-data". Current
// supported values: * user-data * cloud-retail This option requires
// additional allowlisting. Before using cloud-retail, contact Cloud
// Retail support team first.
func (c *ProjectsLocationsCatalogsCompleteQueryCall) Dataset(dataset string) *ProjectsLocationsCatalogsCompleteQueryCall {
	c.urlParams_.Set("dataset", dataset)
	return c
}

// DeviceType sets the optional parameter "deviceType": The device type
// context for completion suggestions. It is useful to apply different
// suggestions on different device types, e.g. `DESKTOP`, `MOBILE`. If
// it is empty, the suggestions are across all device types. Supported
// formats: * `UNKNOWN_DEVICE_TYPE` * `DESKTOP` * `MOBILE` * A
// customized string starts with `OTHER_`, e.g. `OTHER_IPHONE`.
func (c *ProjectsLocationsCatalogsCompleteQueryCall) DeviceType(deviceType string) *ProjectsLocationsCatalogsCompleteQueryCall {
	c.urlParams_.Set("deviceType", deviceType)
	return c
}

// LanguageCodes sets the optional parameter "languageCodes": The list
// of languages of the query. This is the BCP-47 language code, such as
// "en-US" or "sr-Latn". For more information, see Tags for Identifying
// Languages (https://tools.ietf.org/html/bcp47). The maximum number of
// allowed characters is 255. Only "en-US" is currently supported.
func (c *ProjectsLocationsCatalogsCompleteQueryCall) LanguageCodes(languageCodes ...string) *ProjectsLocationsCatalogsCompleteQueryCall {
	c.urlParams_.SetMulti("languageCodes", append([]string{}, languageCodes...))
	return c
}

// MaxSuggestions sets the optional parameter "maxSuggestions":
// Completion max suggestions. If left unset or set to 0, then will
// fallback to the configured value CompletionConfig.max_suggestions.
// The maximum allowed max suggestions is 20. If it is set higher, it
// will be capped by 20.
func (c *ProjectsLocationsCatalogsCompleteQueryCall) MaxSuggestions(maxSuggestions int64) *ProjectsLocationsCatalogsCompleteQueryCall {
	c.urlParams_.Set("maxSuggestions", fmt.Sprint(maxSuggestions))
	return c
}

// Query sets the optional parameter "query": Required. The query used
// to generate suggestions. The maximum number of allowed characters is
// 255.
func (c *ProjectsLocationsCatalogsCompleteQueryCall) Query(query string) *ProjectsLocationsCatalogsCompleteQueryCall {
	c.urlParams_.Set("query", query)
	return c
}

// VisitorId sets the optional parameter "visitorId": A unique
// identifier for tracking visitors. For example, this could be
// implemented with an HTTP cookie, which should be able to uniquely
// identify a visitor on a single device. This unique identifier should
// not change if the visitor logs in or out of the website. The field
// must be a UTF-8 encoded string with a length limit of 128 characters.
// Otherwise, an INVALID_ARGUMENT error is returned.
func (c *ProjectsLocationsCatalogsCompleteQueryCall) VisitorId(visitorId string) *ProjectsLocationsCatalogsCompleteQueryCall {
	c.urlParams_.Set("visitorId", visitorId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsCompleteQueryCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsCompleteQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCatalogsCompleteQueryCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsCompleteQueryCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsCompleteQueryCall) Context(ctx context.Context) *ProjectsLocationsCatalogsCompleteQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsCompleteQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsCompleteQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+catalog}:completeQuery")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"catalog": c.catalog,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.completeQuery" call.
// Exactly one of *GoogleCloudRetailV2CompleteQueryResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudRetailV2CompleteQueryResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCatalogsCompleteQueryCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2CompleteQueryResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRetailV2CompleteQueryResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Completes the specified prefix with keyword suggestions. This feature is only available for users who have Retail Search enabled. Please submit a form [here](https://cloud.google.com/contact) to contact cloud sales if you are interested in using Retail Search.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}:completeQuery",
	//   "httpMethod": "GET",
	//   "id": "retail.projects.locations.catalogs.completeQuery",
	//   "parameterOrder": [
	//     "catalog"
	//   ],
	//   "parameters": {
	//     "catalog": {
	//       "description": "Required. Catalog for which the completion is performed. Full resource name of catalog, such as `projects/*/locations/global/catalogs/default_catalog`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "dataset": {
	//       "description": "Determines which dataset to use for fetching completion. \"user-data\" will use the imported dataset through CompletionService.ImportCompletionData. \"cloud-retail\" will use the dataset generated by cloud retail based on user events. If leave empty, it will use the \"user-data\". Current supported values: * user-data * cloud-retail This option requires additional allowlisting. Before using cloud-retail, contact Cloud Retail support team first.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "deviceType": {
	//       "description": "The device type context for completion suggestions. It is useful to apply different suggestions on different device types, e.g. `DESKTOP`, `MOBILE`. If it is empty, the suggestions are across all device types. Supported formats: * `UNKNOWN_DEVICE_TYPE` * `DESKTOP` * `MOBILE` * A customized string starts with `OTHER_`, e.g. `OTHER_IPHONE`.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "languageCodes": {
	//       "description": "The list of languages of the query. This is the BCP-47 language code, such as \"en-US\" or \"sr-Latn\". For more information, see [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47). The maximum number of allowed characters is 255. Only \"en-US\" is currently supported.",
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "maxSuggestions": {
	//       "description": "Completion max suggestions. If left unset or set to 0, then will fallback to the configured value CompletionConfig.max_suggestions. The maximum allowed max suggestions is 20. If it is set higher, it will be capped by 20.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "query": {
	//       "description": "Required. The query used to generate suggestions. The maximum number of allowed characters is 255.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "visitorId": {
	//       "description": "A unique identifier for tracking visitors. For example, this could be implemented with an HTTP cookie, which should be able to uniquely identify a visitor on a single device. This unique identifier should not change if the visitor logs in or out of the website. The field must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+catalog}:completeQuery",
	//   "response": {
	//     "$ref": "GoogleCloudRetailV2CompleteQueryResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.getDefaultBranch":

type ProjectsLocationsCatalogsGetDefaultBranchCall struct {
	s            *Service
	catalog      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetDefaultBranch: Get which branch is currently default branch set by
// CatalogService.SetDefaultBranch method under a specified parent
// catalog. This feature is only available for users who have Retail
// Search enabled. Please submit a form here
// (https://cloud.google.com/contact) to contact cloud sales if you are
// interested in using Retail Search.
//
// - catalog: The parent catalog resource name, such as
//   `projects/*/locations/global/catalogs/default_catalog`.
func (r *ProjectsLocationsCatalogsService) GetDefaultBranch(catalog string) *ProjectsLocationsCatalogsGetDefaultBranchCall {
	c := &ProjectsLocationsCatalogsGetDefaultBranchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.catalog = catalog
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsGetDefaultBranchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsGetDefaultBranchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCatalogsGetDefaultBranchCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsGetDefaultBranchCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsGetDefaultBranchCall) Context(ctx context.Context) *ProjectsLocationsCatalogsGetDefaultBranchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsGetDefaultBranchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsGetDefaultBranchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+catalog}:getDefaultBranch")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"catalog": c.catalog,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.getDefaultBranch" call.
// Exactly one of *GoogleCloudRetailV2GetDefaultBranchResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudRetailV2GetDefaultBranchResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCatalogsGetDefaultBranchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2GetDefaultBranchResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRetailV2GetDefaultBranchResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get which branch is currently default branch set by CatalogService.SetDefaultBranch method under a specified parent catalog. This feature is only available for users who have Retail Search enabled. Please submit a form [here](https://cloud.google.com/contact) to contact cloud sales if you are interested in using Retail Search.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}:getDefaultBranch",
	//   "httpMethod": "GET",
	//   "id": "retail.projects.locations.catalogs.getDefaultBranch",
	//   "parameterOrder": [
	//     "catalog"
	//   ],
	//   "parameters": {
	//     "catalog": {
	//       "description": "The parent catalog resource name, such as `projects/*/locations/global/catalogs/default_catalog`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+catalog}:getDefaultBranch",
	//   "response": {
	//     "$ref": "GoogleCloudRetailV2GetDefaultBranchResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.list":

type ProjectsLocationsCatalogsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the Catalogs associated with the project.
//
// - parent: The account resource name with an associated location. If
//   the caller does not have permission to list Catalogs under this
//   location, regardless of whether or not this location exists, a
//   PERMISSION_DENIED error is returned.
func (r *ProjectsLocationsCatalogsService) List(parent string) *ProjectsLocationsCatalogsListCall {
	c := &ProjectsLocationsCatalogsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// Catalogs to return. If unspecified, defaults to 50. The maximum
// allowed value is 1000. Values above 1000 will be coerced to 1000. If
// this field is negative, an INVALID_ARGUMENT is returned.
func (c *ProjectsLocationsCatalogsListCall) PageSize(pageSize int64) *ProjectsLocationsCatalogsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token
// ListCatalogsResponse.next_page_token, received from a previous
// CatalogService.ListCatalogs call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// CatalogService.ListCatalogs must match the call that provided the
// page token. Otherwise, an INVALID_ARGUMENT error is returned.
func (c *ProjectsLocationsCatalogsListCall) PageToken(pageToken string) *ProjectsLocationsCatalogsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCatalogsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsListCall) Context(ctx context.Context) *ProjectsLocationsCatalogsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/catalogs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.list" call.
// Exactly one of *GoogleCloudRetailV2ListCatalogsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudRetailV2ListCatalogsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2ListCatalogsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRetailV2ListCatalogsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all the Catalogs associated with the project.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/catalogs",
	//   "httpMethod": "GET",
	//   "id": "retail.projects.locations.catalogs.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "Maximum number of Catalogs to return. If unspecified, defaults to 50. The maximum allowed value is 1000. Values above 1000 will be coerced to 1000. If this field is negative, an INVALID_ARGUMENT is returned.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token ListCatalogsResponse.next_page_token, received from a previous CatalogService.ListCatalogs call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to CatalogService.ListCatalogs must match the call that provided the page token. Otherwise, an INVALID_ARGUMENT error is returned.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The account resource name with an associated location. If the caller does not have permission to list Catalogs under this location, regardless of whether or not this location exists, a PERMISSION_DENIED error is returned.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+parent}/catalogs",
	//   "response": {
	//     "$ref": "GoogleCloudRetailV2ListCatalogsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCatalogsListCall) Pages(ctx context.Context, f func(*GoogleCloudRetailV2ListCatalogsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "retail.projects.locations.catalogs.patch":

type ProjectsLocationsCatalogsPatchCall struct {
	s                          *Service
	name                       string
	googlecloudretailv2catalog *GoogleCloudRetailV2Catalog
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// Patch: Updates the Catalogs.
//
// - name: Immutable. The fully qualified resource name of the catalog.
func (r *ProjectsLocationsCatalogsService) Patch(name string, googlecloudretailv2catalog *GoogleCloudRetailV2Catalog) *ProjectsLocationsCatalogsPatchCall {
	c := &ProjectsLocationsCatalogsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudretailv2catalog = googlecloudretailv2catalog
	return c
}

// UpdateMask sets the optional parameter "updateMask": Indicates which
// fields in the provided Catalog to update. If an unsupported or
// unknown field is provided, an INVALID_ARGUMENT error is returned.
func (c *ProjectsLocationsCatalogsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsCatalogsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsPatchCall) Context(ctx context.Context) *ProjectsLocationsCatalogsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2catalog)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.patch" call.
// Exactly one of *GoogleCloudRetailV2Catalog or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2Catalog.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2Catalog, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRetailV2Catalog{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the Catalogs.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}",
	//   "httpMethod": "PATCH",
	//   "id": "retail.projects.locations.catalogs.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Immutable. The fully qualified resource name of the catalog.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Indicates which fields in the provided Catalog to update. If an unsupported or unknown field is provided, an INVALID_ARGUMENT error is returned.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudRetailV2Catalog"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRetailV2Catalog"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.setDefaultBranch":

type ProjectsLocationsCatalogsSetDefaultBranchCall struct {
	s                                          *Service
	catalog                                    string
	googlecloudretailv2setdefaultbranchrequest *GoogleCloudRetailV2SetDefaultBranchRequest
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// SetDefaultBranch: Set a specified branch id as default branch. API
// methods such as SearchService.Search, ProductService.GetProduct,
// ProductService.ListProducts will treat requests using
// "default_branch" to the actual branch id set as default. For example,
// if `projects/*/locations/*/catalogs/*/branches/1` is set as default,
// setting SearchRequest.branch to
// `projects/*/locations/*/catalogs/*/branches/default_branch` is
// equivalent to setting SearchRequest.branch to
// `projects/*/locations/*/catalogs/*/branches/1`. Using multiple
// branches can be useful when developers would like to have a staging
// branch to test and verify for future usage. When it becomes ready,
// developers switch on the staging branch using this API while keeping
// using `projects/*/locations/*/catalogs/*/branches/default_branch` as
// SearchRequest.branch to route the traffic to this staging branch.
// CAUTION: If you have live predict/search traffic, switching the
// default branch could potentially cause outages if the ID space of the
// new branch is very different from the old one. More specifically: *
// PredictionService will only return product IDs from branch
// {newBranch}. * SearchService will only return product IDs from branch
// {newBranch} (if branch is not explicitly set). * UserEventService
// will only join events with products from branch {newBranch}. This
// feature is only available for users who have Retail Search enabled.
// Please submit a form here (https://cloud.google.com/contact) to
// contact cloud sales if you are interested in using Retail Search.
//
// - catalog: Full resource name of the catalog, such as
//   `projects/*/locations/global/catalogs/default_catalog`.
func (r *ProjectsLocationsCatalogsService) SetDefaultBranch(catalog string, googlecloudretailv2setdefaultbranchrequest *GoogleCloudRetailV2SetDefaultBranchRequest) *ProjectsLocationsCatalogsSetDefaultBranchCall {
	c := &ProjectsLocationsCatalogsSetDefaultBranchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.catalog = catalog
	c.googlecloudretailv2setdefaultbranchrequest = googlecloudretailv2setdefaultbranchrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsSetDefaultBranchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsSetDefaultBranchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsSetDefaultBranchCall) Context(ctx context.Context) *ProjectsLocationsCatalogsSetDefaultBranchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsSetDefaultBranchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsSetDefaultBranchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2setdefaultbranchrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+catalog}:setDefaultBranch")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"catalog": c.catalog,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.setDefaultBranch" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsSetDefaultBranchCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Set a specified branch id as default branch. API methods such as SearchService.Search, ProductService.GetProduct, ProductService.ListProducts will treat requests using \"default_branch\" to the actual branch id set as default. For example, if `projects/*/locations/*/catalogs/*/branches/1` is set as default, setting SearchRequest.branch to `projects/*/locations/*/catalogs/*/branches/default_branch` is equivalent to setting SearchRequest.branch to `projects/*/locations/*/catalogs/*/branches/1`. Using multiple branches can be useful when developers would like to have a staging branch to test and verify for future usage. When it becomes ready, developers switch on the staging branch using this API while keeping using `projects/*/locations/*/catalogs/*/branches/default_branch` as SearchRequest.branch to route the traffic to this staging branch. CAUTION: If you have live predict/search traffic, switching the default branch could potentially cause outages if the ID space of the new branch is very different from the old one. More specifically: * PredictionService will only return product IDs from branch {newBranch}. * SearchService will only return product IDs from branch {newBranch} (if branch is not explicitly set). * UserEventService will only join events with products from branch {newBranch}. This feature is only available for users who have Retail Search enabled. Please submit a form [here](https://cloud.google.com/contact) to contact cloud sales if you are interested in using Retail Search.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}:setDefaultBranch",
	//   "httpMethod": "POST",
	//   "id": "retail.projects.locations.catalogs.setDefaultBranch",
	//   "parameterOrder": [
	//     "catalog"
	//   ],
	//   "parameters": {
	//     "catalog": {
	//       "description": "Full resource name of the catalog, such as `projects/*/locations/global/catalogs/default_catalog`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+catalog}:setDefaultBranch",
	//   "request": {
	//     "$ref": "GoogleCloudRetailV2SetDefaultBranchRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.branches.operations.get":

type ProjectsLocationsCatalogsBranchesOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsCatalogsBranchesOperationsService) Get(name string) *ProjectsLocationsCatalogsBranchesOperationsGetCall {
	c := &ProjectsLocationsCatalogsBranchesOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsBranchesOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCatalogsBranchesOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsBranchesOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsBranchesOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsBranchesOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.operations.get" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/branches/{branchesId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "retail.projects.locations.catalogs.branches.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+/branches/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.branches.products.addFulfillmentPlaces":

type ProjectsLocationsCatalogsBranchesProductsAddFulfillmentPlacesCall struct {
	s                                              *Service
	product                                        string
	googlecloudretailv2addfulfillmentplacesrequest *GoogleCloudRetailV2AddFulfillmentPlacesRequest
	urlParams_                                     gensupport.URLParams
	ctx_                                           context.Context
	header_                                        http.Header
}

// AddFulfillmentPlaces: Incrementally adds place IDs to
// Product.fulfillment_info.place_ids. This process is asynchronous and
// does not require the Product to exist before updating fulfillment
// information. If the request is valid, the update will be enqueued and
// processed downstream. As a consequence, when a response is returned,
// the added place IDs are not immediately manifested in the Product
// queried by GetProduct or ListProducts. This feature is only available
// for users who have Retail Search enabled. Please submit a form here
// (https://cloud.google.com/contact) to contact cloud sales if you are
// interested in using Retail Search.
//
// - product: Full resource name of Product, such as
//   `projects/*/locations/global/catalogs/default_catalog/branches/defau
//   lt_branch/products/some_product_id`. If the caller does not have
//   permission to access the Product, regardless of whether or not it
//   exists, a PERMISSION_DENIED error is returned.
func (r *ProjectsLocationsCatalogsBranchesProductsService) AddFulfillmentPlaces(product string, googlecloudretailv2addfulfillmentplacesrequest *GoogleCloudRetailV2AddFulfillmentPlacesRequest) *ProjectsLocationsCatalogsBranchesProductsAddFulfillmentPlacesCall {
	c := &ProjectsLocationsCatalogsBranchesProductsAddFulfillmentPlacesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.product = product
	c.googlecloudretailv2addfulfillmentplacesrequest = googlecloudretailv2addfulfillmentplacesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsBranchesProductsAddFulfillmentPlacesCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesProductsAddFulfillmentPlacesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsBranchesProductsAddFulfillmentPlacesCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesProductsAddFulfillmentPlacesCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsBranchesProductsAddFulfillmentPlacesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesProductsAddFulfillmentPlacesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2addfulfillmentplacesrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+product}:addFulfillmentPlaces")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"product": c.product,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.products.addFulfillmentPlaces" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesProductsAddFulfillmentPlacesCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Incrementally adds place IDs to Product.fulfillment_info.place_ids. This process is asynchronous and does not require the Product to exist before updating fulfillment information. If the request is valid, the update will be enqueued and processed downstream. As a consequence, when a response is returned, the added place IDs are not immediately manifested in the Product queried by GetProduct or ListProducts. This feature is only available for users who have Retail Search enabled. Please submit a form [here](https://cloud.google.com/contact) to contact cloud sales if you are interested in using Retail Search.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/branches/{branchesId}/products/{productsId}:addFulfillmentPlaces",
	//   "httpMethod": "POST",
	//   "id": "retail.projects.locations.catalogs.branches.products.addFulfillmentPlaces",
	//   "parameterOrder": [
	//     "product"
	//   ],
	//   "parameters": {
	//     "product": {
	//       "description": "Required. Full resource name of Product, such as `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`. If the caller does not have permission to access the Product, regardless of whether or not it exists, a PERMISSION_DENIED error is returned.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+/branches/[^/]+/products/.*$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+product}:addFulfillmentPlaces",
	//   "request": {
	//     "$ref": "GoogleCloudRetailV2AddFulfillmentPlacesRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.branches.products.create":

type ProjectsLocationsCatalogsBranchesProductsCreateCall struct {
	s                          *Service
	parent                     string
	googlecloudretailv2product *GoogleCloudRetailV2Product
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// Create: Creates a Product.
//
// - parent: The parent catalog resource name, such as
//   `projects/*/locations/global/catalogs/default_catalog/branches/defau
//   lt_branch`.
func (r *ProjectsLocationsCatalogsBranchesProductsService) Create(parent string, googlecloudretailv2product *GoogleCloudRetailV2Product) *ProjectsLocationsCatalogsBranchesProductsCreateCall {
	c := &ProjectsLocationsCatalogsBranchesProductsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudretailv2product = googlecloudretailv2product
	return c
}

// ProductId sets the optional parameter "productId": Required. The ID
// to use for the Product, which will become the final component of the
// Product.name. If the caller does not have permission to create the
// Product, regardless of whether or not it exists, a PERMISSION_DENIED
// error is returned. This field must be unique among all Products with
// the same parent. Otherwise, an ALREADY_EXISTS error is returned. This
// field must be a UTF-8 encoded string with a length limit of 128
// characters. Otherwise, an INVALID_ARGUMENT error is returned.
func (c *ProjectsLocationsCatalogsBranchesProductsCreateCall) ProductId(productId string) *ProjectsLocationsCatalogsBranchesProductsCreateCall {
	c.urlParams_.Set("productId", productId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsBranchesProductsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesProductsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsBranchesProductsCreateCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesProductsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsBranchesProductsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesProductsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2product)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/products")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.products.create" call.
// Exactly one of *GoogleCloudRetailV2Product or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2Product.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesProductsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2Product, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRetailV2Product{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a Product.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/branches/{branchesId}/products",
	//   "httpMethod": "POST",
	//   "id": "retail.projects.locations.catalogs.branches.products.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent catalog resource name, such as `projects/*/locations/global/catalogs/default_catalog/branches/default_branch`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+/branches/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "productId": {
	//       "description": "Required. The ID to use for the Product, which will become the final component of the Product.name. If the caller does not have permission to create the Product, regardless of whether or not it exists, a PERMISSION_DENIED error is returned. This field must be unique among all Products with the same parent. Otherwise, an ALREADY_EXISTS error is returned. This field must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+parent}/products",
	//   "request": {
	//     "$ref": "GoogleCloudRetailV2Product"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRetailV2Product"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.branches.products.delete":

type ProjectsLocationsCatalogsBranchesProductsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Product.
//
// - name: Full resource name of Product, such as
//   `projects/*/locations/global/catalogs/default_catalog/branches/defau
//   lt_branch/products/some_product_id`. If the caller does not have
//   permission to delete the Product, regardless of whether or not it
//   exists, a PERMISSION_DENIED error is returned. If the Product to
//   delete does not exist, a NOT_FOUND error is returned. The Product
//   to delete can neither be a Product.Type.COLLECTION Product member
//   nor a Product.Type.PRIMARY Product with more than one variants.
//   Otherwise, an INVALID_ARGUMENT error is returned. All inventory
//   information for the named Product will be deleted.
func (r *ProjectsLocationsCatalogsBranchesProductsService) Delete(name string) *ProjectsLocationsCatalogsBranchesProductsDeleteCall {
	c := &ProjectsLocationsCatalogsBranchesProductsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsBranchesProductsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesProductsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsBranchesProductsDeleteCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesProductsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsBranchesProductsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesProductsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.products.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesProductsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a Product.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/branches/{branchesId}/products/{productsId}",
	//   "httpMethod": "DELETE",
	//   "id": "retail.projects.locations.catalogs.branches.products.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Full resource name of Product, such as `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`. If the caller does not have permission to delete the Product, regardless of whether or not it exists, a PERMISSION_DENIED error is returned. If the Product to delete does not exist, a NOT_FOUND error is returned. The Product to delete can neither be a Product.Type.COLLECTION Product member nor a Product.Type.PRIMARY Product with more than one variants. Otherwise, an INVALID_ARGUMENT error is returned. All inventory information for the named Product will be deleted.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+/branches/[^/]+/products/.*$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.branches.products.get":

type ProjectsLocationsCatalogsBranchesProductsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a Product.
//
// - name: Full resource name of Product, such as
//   `projects/*/locations/global/catalogs/default_catalog/branches/defau
//   lt_branch/products/some_product_id`. If the caller does not have
//   permission to access the Product, regardless of whether or not it
//   exists, a PERMISSION_DENIED error is returned. If the requested
//   Product does not exist, a NOT_FOUND error is returned.
func (r *ProjectsLocationsCatalogsBranchesProductsService) Get(name string) *ProjectsLocationsCatalogsBranchesProductsGetCall {
	c := &ProjectsLocationsCatalogsBranchesProductsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsBranchesProductsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesProductsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCatalogsBranchesProductsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsBranchesProductsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsBranchesProductsGetCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesProductsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsBranchesProductsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesProductsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.products.get" call.
// Exactly one of *GoogleCloudRetailV2Product or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2Product.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesProductsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2Product, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRetailV2Product{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a Product.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/branches/{branchesId}/products/{productsId}",
	//   "httpMethod": "GET",
	//   "id": "retail.projects.locations.catalogs.branches.products.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Full resource name of Product, such as `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`. If the caller does not have permission to access the Product, regardless of whether or not it exists, a PERMISSION_DENIED error is returned. If the requested Product does not exist, a NOT_FOUND error is returned.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+/branches/[^/]+/products/.*$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudRetailV2Product"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.branches.products.import":

type ProjectsLocationsCatalogsBranchesProductsImportCall struct {
	s                                        *Service
	parent                                   string
	googlecloudretailv2importproductsrequest *GoogleCloudRetailV2ImportProductsRequest
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// Import: Bulk import of multiple Products. Request processing may be
// synchronous. No partial updating is supported. Non-existing items are
// created. Note that it is possible for a subset of the Products to be
// successfully updated.
//
// - parent:
//   `projects/1234/locations/global/catalogs/default_catalog/branches/de
//   fault_branch` If no updateMask is specified, requires
//   products.create permission. If updateMask is specified, requires
//   products.update permission.
func (r *ProjectsLocationsCatalogsBranchesProductsService) Import(parent string, googlecloudretailv2importproductsrequest *GoogleCloudRetailV2ImportProductsRequest) *ProjectsLocationsCatalogsBranchesProductsImportCall {
	c := &ProjectsLocationsCatalogsBranchesProductsImportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudretailv2importproductsrequest = googlecloudretailv2importproductsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsBranchesProductsImportCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesProductsImportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsBranchesProductsImportCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesProductsImportCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsBranchesProductsImportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesProductsImportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2importproductsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/products:import")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.products.import" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesProductsImportCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Bulk import of multiple Products. Request processing may be synchronous. No partial updating is supported. Non-existing items are created. Note that it is possible for a subset of the Products to be successfully updated.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/branches/{branchesId}/products:import",
	//   "httpMethod": "POST",
	//   "id": "retail.projects.locations.catalogs.branches.products.import",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. `projects/1234/locations/global/catalogs/default_catalog/branches/default_branch` If no updateMask is specified, requires products.create permission. If updateMask is specified, requires products.update permission.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+/branches/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+parent}/products:import",
	//   "request": {
	//     "$ref": "GoogleCloudRetailV2ImportProductsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.branches.products.list":

type ProjectsLocationsCatalogsBranchesProductsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Gets a list of Products.
//
// - parent: The parent branch resource name, such as
//   `projects/*/locations/global/catalogs/default_catalog/branches/0`.
//   Use `default_branch` as the branch ID, to list products under the
//   default branch. If the caller does not have permission to list
//   Products under this branch, regardless of whether or not this
//   branch exists, a PERMISSION_DENIED error is returned.
func (r *ProjectsLocationsCatalogsBranchesProductsService) List(parent string) *ProjectsLocationsCatalogsBranchesProductsListCall {
	c := &ProjectsLocationsCatalogsBranchesProductsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to apply on the
// list results. Supported features: * List all the products under the
// parent branch if filter is unset. * List Product.Type.VARIANT
// Products sharing the same Product.Type.PRIMARY Product. For example:
// `primary_product_id = "some_product_id" * List Products bundled in a
// Product.Type.COLLECTION Product. For example: `collection_product_id
// = "some_product_id" * List Products with a partibular type. For
// example: `type = "PRIMARY" `type = "VARIANT" `type = "COLLECTION"
// If the field is unrecognizable, an INVALID_ARGUMENT error is
// returned. If the specified Product.Type.PRIMARY Product or
// Product.Type.COLLECTION Product does not exist, a NOT_FOUND error is
// returned.
func (c *ProjectsLocationsCatalogsBranchesProductsListCall) Filter(filter string) *ProjectsLocationsCatalogsBranchesProductsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// Products to return. If unspecified, defaults to 100. The maximum
// allowed value is 1000. Values above 1000 will be coerced to 1000. If
// this field is negative, an INVALID_ARGUMENT error is returned.
func (c *ProjectsLocationsCatalogsBranchesProductsListCall) PageSize(pageSize int64) *ProjectsLocationsCatalogsBranchesProductsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token
// ListProductsResponse.next_page_token, received from a previous
// ProductService.ListProducts call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// ProductService.ListProducts must match the call that provided the
// page token. Otherwise, an INVALID_ARGUMENT error is returned.
func (c *ProjectsLocationsCatalogsBranchesProductsListCall) PageToken(pageToken string) *ProjectsLocationsCatalogsBranchesProductsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReadMask sets the optional parameter "readMask": The fields of
// Product to return in the responses. If not set or empty, the
// following fields are returned: * Product.name * Product.id *
// Product.title * Product.uri * Product.images * Product.price_info *
// Product.brands If "*" is provided, all fields are returned.
// Product.name is always returned no matter what mask is set. If an
// unsupported or unknown field is provided, an INVALID_ARGUMENT error
// is returned.
func (c *ProjectsLocationsCatalogsBranchesProductsListCall) ReadMask(readMask string) *ProjectsLocationsCatalogsBranchesProductsListCall {
	c.urlParams_.Set("readMask", readMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsBranchesProductsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesProductsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCatalogsBranchesProductsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsBranchesProductsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsBranchesProductsListCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesProductsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsBranchesProductsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesProductsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/products")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.products.list" call.
// Exactly one of *GoogleCloudRetailV2ListProductsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudRetailV2ListProductsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesProductsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2ListProductsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRetailV2ListProductsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a list of Products.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/branches/{branchesId}/products",
	//   "httpMethod": "GET",
	//   "id": "retail.projects.locations.catalogs.branches.products.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "A filter to apply on the list results. Supported features: * List all the products under the parent branch if filter is unset. * List Product.Type.VARIANT Products sharing the same Product.Type.PRIMARY Product. For example: `primary_product_id = \"some_product_id\"` * List Products bundled in a Product.Type.COLLECTION Product. For example: `collection_product_id = \"some_product_id\"` * List Products with a partibular type. For example: `type = \"PRIMARY\"` `type = \"VARIANT\"` `type = \"COLLECTION\"` If the field is unrecognizable, an INVALID_ARGUMENT error is returned. If the specified Product.Type.PRIMARY Product or Product.Type.COLLECTION Product does not exist, a NOT_FOUND error is returned.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Maximum number of Products to return. If unspecified, defaults to 100. The maximum allowed value is 1000. Values above 1000 will be coerced to 1000. If this field is negative, an INVALID_ARGUMENT error is returned.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token ListProductsResponse.next_page_token, received from a previous ProductService.ListProducts call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to ProductService.ListProducts must match the call that provided the page token. Otherwise, an INVALID_ARGUMENT error is returned.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent branch resource name, such as `projects/*/locations/global/catalogs/default_catalog/branches/0`. Use `default_branch` as the branch ID, to list products under the default branch. If the caller does not have permission to list Products under this branch, regardless of whether or not this branch exists, a PERMISSION_DENIED error is returned.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+/branches/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "readMask": {
	//       "description": "The fields of Product to return in the responses. If not set or empty, the following fields are returned: * Product.name * Product.id * Product.title * Product.uri * Product.images * Product.price_info * Product.brands If \"*\" is provided, all fields are returned. Product.name is always returned no matter what mask is set. If an unsupported or unknown field is provided, an INVALID_ARGUMENT error is returned.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+parent}/products",
	//   "response": {
	//     "$ref": "GoogleCloudRetailV2ListProductsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCatalogsBranchesProductsListCall) Pages(ctx context.Context, f func(*GoogleCloudRetailV2ListProductsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "retail.projects.locations.catalogs.branches.products.patch":

type ProjectsLocationsCatalogsBranchesProductsPatchCall struct {
	s                          *Service
	name                       string
	googlecloudretailv2product *GoogleCloudRetailV2Product
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// Patch: Updates a Product.
//
// - name: Immutable. Full resource name of the product, such as
//   `projects/*/locations/global/catalogs/default_catalog/branches/defau
//   lt_branch/products/product_id`.
func (r *ProjectsLocationsCatalogsBranchesProductsService) Patch(name string, googlecloudretailv2product *GoogleCloudRetailV2Product) *ProjectsLocationsCatalogsBranchesProductsPatchCall {
	c := &ProjectsLocationsCatalogsBranchesProductsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudretailv2product = googlecloudretailv2product
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to
// true, and the Product is not found, a new Product will be created. In
// this situation, `update_mask` is ignored.
func (c *ProjectsLocationsCatalogsBranchesProductsPatchCall) AllowMissing(allowMissing bool) *ProjectsLocationsCatalogsBranchesProductsPatchCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// UpdateMask sets the optional parameter "updateMask": Indicates which
// fields in the provided Product to update. The immutable and output
// only fields are NOT supported. If not set, all supported fields (the
// fields that are neither immutable nor output only) are updated. If an
// unsupported or unknown field is provided, an INVALID_ARGUMENT error
// is returned.
func (c *ProjectsLocationsCatalogsBranchesProductsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsCatalogsBranchesProductsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsBranchesProductsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesProductsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsBranchesProductsPatchCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesProductsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsBranchesProductsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesProductsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2product)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.products.patch" call.
// Exactly one of *GoogleCloudRetailV2Product or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRetailV2Product.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesProductsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2Product, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRetailV2Product{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a Product.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/branches/{branchesId}/products/{productsId}",
	//   "httpMethod": "PATCH",
	//   "id": "retail.projects.locations.catalogs.branches.products.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "allowMissing": {
	//       "description": "If set to true, and the Product is not found, a new Product will be created. In this situation, `update_mask` is ignored.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "name": {
	//       "description": "Immutable. Full resource name of the product, such as `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/product_id`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+/branches/[^/]+/products/.*$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Indicates which fields in the provided Product to update. The immutable and output only fields are NOT supported. If not set, all supported fields (the fields that are neither immutable nor output only) are updated. If an unsupported or unknown field is provided, an INVALID_ARGUMENT error is returned.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudRetailV2Product"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRetailV2Product"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.branches.products.removeFulfillmentPlaces":

type ProjectsLocationsCatalogsBranchesProductsRemoveFulfillmentPlacesCall struct {
	s                                                 *Service
	product                                           string
	googlecloudretailv2removefulfillmentplacesrequest *GoogleCloudRetailV2RemoveFulfillmentPlacesRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// RemoveFulfillmentPlaces: Incrementally removes place IDs from a
// Product.fulfillment_info.place_ids. This process is asynchronous and
// does not require the Product to exist before updating fulfillment
// information. If the request is valid, the update will be enqueued and
// processed downstream. As a consequence, when a response is returned,
// the removed place IDs are not immediately manifested in the Product
// queried by GetProduct or ListProducts. This feature is only available
// for users who have Retail Search enabled. Please submit a form here
// (https://cloud.google.com/contact) to contact cloud sales if you are
// interested in using Retail Search.
//
// - product: Full resource name of Product, such as
//   `projects/*/locations/global/catalogs/default_catalog/branches/defau
//   lt_branch/products/some_product_id`. If the caller does not have
//   permission to access the Product, regardless of whether or not it
//   exists, a PERMISSION_DENIED error is returned.
func (r *ProjectsLocationsCatalogsBranchesProductsService) RemoveFulfillmentPlaces(product string, googlecloudretailv2removefulfillmentplacesrequest *GoogleCloudRetailV2RemoveFulfillmentPlacesRequest) *ProjectsLocationsCatalogsBranchesProductsRemoveFulfillmentPlacesCall {
	c := &ProjectsLocationsCatalogsBranchesProductsRemoveFulfillmentPlacesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.product = product
	c.googlecloudretailv2removefulfillmentplacesrequest = googlecloudretailv2removefulfillmentplacesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsBranchesProductsRemoveFulfillmentPlacesCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesProductsRemoveFulfillmentPlacesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsBranchesProductsRemoveFulfillmentPlacesCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesProductsRemoveFulfillmentPlacesCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsBranchesProductsRemoveFulfillmentPlacesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesProductsRemoveFulfillmentPlacesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2removefulfillmentplacesrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+product}:removeFulfillmentPlaces")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"product": c.product,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.products.removeFulfillmentPlaces" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesProductsRemoveFulfillmentPlacesCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Incrementally removes place IDs from a Product.fulfillment_info.place_ids. This process is asynchronous and does not require the Product to exist before updating fulfillment information. If the request is valid, the update will be enqueued and processed downstream. As a consequence, when a response is returned, the removed place IDs are not immediately manifested in the Product queried by GetProduct or ListProducts. This feature is only available for users who have Retail Search enabled. Please submit a form [here](https://cloud.google.com/contact) to contact cloud sales if you are interested in using Retail Search.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/branches/{branchesId}/products/{productsId}:removeFulfillmentPlaces",
	//   "httpMethod": "POST",
	//   "id": "retail.projects.locations.catalogs.branches.products.removeFulfillmentPlaces",
	//   "parameterOrder": [
	//     "product"
	//   ],
	//   "parameters": {
	//     "product": {
	//       "description": "Required. Full resource name of Product, such as `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/some_product_id`. If the caller does not have permission to access the Product, regardless of whether or not it exists, a PERMISSION_DENIED error is returned.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+/branches/[^/]+/products/.*$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+product}:removeFulfillmentPlaces",
	//   "request": {
	//     "$ref": "GoogleCloudRetailV2RemoveFulfillmentPlacesRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.branches.products.setInventory":

type ProjectsLocationsCatalogsBranchesProductsSetInventoryCall struct {
	s                                      *Service
	name                                   string
	googlecloudretailv2setinventoryrequest *GoogleCloudRetailV2SetInventoryRequest
	urlParams_                             gensupport.URLParams
	ctx_                                   context.Context
	header_                                http.Header
}

// SetInventory: Updates inventory information for a Product while
// respecting the last update timestamps of each inventory field. This
// process is asynchronous and does not require the Product to exist
// before updating fulfillment information. If the request is valid, the
// update will be enqueued and processed downstream. As a consequence,
// when a response is returned, updates are not immediately manifested
// in the Product queried by GetProduct or ListProducts. When inventory
// is updated with CreateProduct and UpdateProduct, the specified
// inventory field value(s) will overwrite any existing value(s) while
// ignoring the last update time for this field. Furthermore, the last
// update time for the specified inventory fields will be overwritten to
// the time of the CreateProduct or UpdateProduct request. If no
// inventory fields are set in CreateProductRequest.product, then any
// pre-existing inventory information for this product will be used. If
// no inventory fields are set in UpdateProductRequest.set_mask, then
// any existing inventory information will be preserved. Pre-existing
// inventory information can only be updated with SetInventory,
// AddFulfillmentPlaces, and RemoveFulfillmentPlaces. This feature is
// only available for users who have Retail Search enabled. Please
// submit a form here (https://cloud.google.com/contact) to contact
// cloud sales if you are interested in using Retail Search.
//
// - name: Immutable. Full resource name of the product, such as
//   `projects/*/locations/global/catalogs/default_catalog/branches/defau
//   lt_branch/products/product_id`.
func (r *ProjectsLocationsCatalogsBranchesProductsService) SetInventory(name string, googlecloudretailv2setinventoryrequest *GoogleCloudRetailV2SetInventoryRequest) *ProjectsLocationsCatalogsBranchesProductsSetInventoryCall {
	c := &ProjectsLocationsCatalogsBranchesProductsSetInventoryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudretailv2setinventoryrequest = googlecloudretailv2setinventoryrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsBranchesProductsSetInventoryCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsBranchesProductsSetInventoryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsBranchesProductsSetInventoryCall) Context(ctx context.Context) *ProjectsLocationsCatalogsBranchesProductsSetInventoryCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsBranchesProductsSetInventoryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsBranchesProductsSetInventoryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2setinventoryrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:setInventory")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.branches.products.setInventory" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsBranchesProductsSetInventoryCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates inventory information for a Product while respecting the last update timestamps of each inventory field. This process is asynchronous and does not require the Product to exist before updating fulfillment information. If the request is valid, the update will be enqueued and processed downstream. As a consequence, when a response is returned, updates are not immediately manifested in the Product queried by GetProduct or ListProducts. When inventory is updated with CreateProduct and UpdateProduct, the specified inventory field value(s) will overwrite any existing value(s) while ignoring the last update time for this field. Furthermore, the last update time for the specified inventory fields will be overwritten to the time of the CreateProduct or UpdateProduct request. If no inventory fields are set in CreateProductRequest.product, then any pre-existing inventory information for this product will be used. If no inventory fields are set in UpdateProductRequest.set_mask, then any existing inventory information will be preserved. Pre-existing inventory information can only be updated with SetInventory, AddFulfillmentPlaces, and RemoveFulfillmentPlaces. This feature is only available for users who have Retail Search enabled. Please submit a form [here](https://cloud.google.com/contact) to contact cloud sales if you are interested in using Retail Search.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/branches/{branchesId}/products/{productsId}:setInventory",
	//   "httpMethod": "POST",
	//   "id": "retail.projects.locations.catalogs.branches.products.setInventory",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Immutable. Full resource name of the product, such as `projects/*/locations/global/catalogs/default_catalog/branches/default_branch/products/product_id`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+/branches/[^/]+/products/.*$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+name}:setInventory",
	//   "request": {
	//     "$ref": "GoogleCloudRetailV2SetInventoryRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.completionData.import":

type ProjectsLocationsCatalogsCompletionDataImportCall struct {
	s                                              *Service
	parent                                         string
	googlecloudretailv2importcompletiondatarequest *GoogleCloudRetailV2ImportCompletionDataRequest
	urlParams_                                     gensupport.URLParams
	ctx_                                           context.Context
	header_                                        http.Header
}

// Import: Bulk import of processed completion dataset. Request
// processing may be synchronous. Partial updating is not supported.
// This feature is only available for users who have Retail Search
// enabled. Please submit a form here (https://cloud.google.com/contact)
// to contact cloud sales if you are interested in using Retail Search.
//
// - parent: The catalog which the suggestions dataset belongs to.
//   Format: `projects/1234/locations/global/catalogs/default_catalog`.
func (r *ProjectsLocationsCatalogsCompletionDataService) Import(parent string, googlecloudretailv2importcompletiondatarequest *GoogleCloudRetailV2ImportCompletionDataRequest) *ProjectsLocationsCatalogsCompletionDataImportCall {
	c := &ProjectsLocationsCatalogsCompletionDataImportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudretailv2importcompletiondatarequest = googlecloudretailv2importcompletiondatarequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsCompletionDataImportCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsCompletionDataImportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsCompletionDataImportCall) Context(ctx context.Context) *ProjectsLocationsCatalogsCompletionDataImportCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsCompletionDataImportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsCompletionDataImportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2importcompletiondatarequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/completionData:import")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.completionData.import" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsCompletionDataImportCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Bulk import of processed completion dataset. Request processing may be synchronous. Partial updating is not supported. This feature is only available for users who have Retail Search enabled. Please submit a form [here](https://cloud.google.com/contact) to contact cloud sales if you are interested in using Retail Search.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/completionData:import",
	//   "httpMethod": "POST",
	//   "id": "retail.projects.locations.catalogs.completionData.import",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The catalog which the suggestions dataset belongs to. Format: `projects/1234/locations/global/catalogs/default_catalog`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+parent}/completionData:import",
	//   "request": {
	//     "$ref": "GoogleCloudRetailV2ImportCompletionDataRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.operations.get":

type ProjectsLocationsCatalogsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsCatalogsOperationsService) Get(name string) *ProjectsLocationsCatalogsOperationsGetCall {
	c := &ProjectsLocationsCatalogsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCatalogsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsCatalogsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.operations.get" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "retail.projects.locations.catalogs.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.operations.list":

type ProjectsLocationsCatalogsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`. NOTE: the `name` binding allows API services to
// override the binding to use different resource name schemes, such as
// `users/*/operations`. To override the binding, API services can add a
// binding such as "/v1/{name=users/*}/operations" to their service
// configuration. For backwards compatibility, the default name includes
// the operations collection id, however overriding users must ensure
// the name binding is the parent resource, without the operations
// collection id.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsCatalogsOperationsService) List(name string) *ProjectsLocationsCatalogsOperationsListCall {
	c := &ProjectsLocationsCatalogsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsCatalogsOperationsListCall) Filter(filter string) *ProjectsLocationsCatalogsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsCatalogsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsCatalogsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsCatalogsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsCatalogsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCatalogsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsCatalogsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.operations.list" call.
// Exactly one of *GoogleLongrunningListOperationsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`. NOTE: the `name` binding allows API services to override the binding to use different resource name schemes, such as `users/*/operations`. To override the binding, API services can add a binding such as `\"/v1/{name=users/*}/operations\"` to their service configuration. For backwards compatibility, the default name includes the operations collection id, however overriding users must ensure the name binding is the parent resource, without the operations collection id.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/operations",
	//   "httpMethod": "GET",
	//   "id": "retail.projects.locations.catalogs.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+name}/operations",
	//   "response": {
	//     "$ref": "GoogleLongrunningListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCatalogsOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "retail.projects.locations.catalogs.placements.predict":

type ProjectsLocationsCatalogsPlacementsPredictCall struct {
	s                                 *Service
	placement                         string
	googlecloudretailv2predictrequest *GoogleCloudRetailV2PredictRequest
	urlParams_                        gensupport.URLParams
	ctx_                              context.Context
	header_                           http.Header
}

// Predict: Makes a recommendation prediction.
//
// - placement: Full resource name of the format:
//   {name=projects/*/locations/global/catalogs/default_catalog/placement
//   s/*} The ID of the Recommendations AI placement. Before you can
//   request predictions from your model, you must create at least one
//   placement for it. For more information, see Managing placements
//   (https://cloud.google.com/retail/recommendations-ai/docs/manage-placements).
//   The full list of available placements can be seen at
//   https://console.cloud.google.com/recommendation/catalogs/default_catalog/placements.
func (r *ProjectsLocationsCatalogsPlacementsService) Predict(placement string, googlecloudretailv2predictrequest *GoogleCloudRetailV2PredictRequest) *ProjectsLocationsCatalogsPlacementsPredictCall {
	c := &ProjectsLocationsCatalogsPlacementsPredictCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.placement = placement
	c.googlecloudretailv2predictrequest = googlecloudretailv2predictrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsPlacementsPredictCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsPlacementsPredictCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsPlacementsPredictCall) Context(ctx context.Context) *ProjectsLocationsCatalogsPlacementsPredictCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsPlacementsPredictCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsPlacementsPredictCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2predictrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+placement}:predict")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"placement": c.placement,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.placements.predict" call.
// Exactly one of *GoogleCloudRetailV2PredictResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudRetailV2PredictResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCatalogsPlacementsPredictCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2PredictResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRetailV2PredictResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Makes a recommendation prediction.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/placements/{placementsId}:predict",
	//   "httpMethod": "POST",
	//   "id": "retail.projects.locations.catalogs.placements.predict",
	//   "parameterOrder": [
	//     "placement"
	//   ],
	//   "parameters": {
	//     "placement": {
	//       "description": "Required. Full resource name of the format: {name=projects/*/locations/global/catalogs/default_catalog/placements/*} The ID of the Recommendations AI placement. Before you can request predictions from your model, you must create at least one placement for it. For more information, see [Managing placements](https://cloud.google.com/retail/recommendations-ai/docs/manage-placements). The full list of available placements can be seen at https://console.cloud.google.com/recommendation/catalogs/default_catalog/placements",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+/placements/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+placement}:predict",
	//   "request": {
	//     "$ref": "GoogleCloudRetailV2PredictRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRetailV2PredictResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.placements.search":

type ProjectsLocationsCatalogsPlacementsSearchCall struct {
	s                                *Service
	placement                        string
	googlecloudretailv2searchrequest *GoogleCloudRetailV2SearchRequest
	urlParams_                       gensupport.URLParams
	ctx_                             context.Context
	header_                          http.Header
}

// Search: Performs a search. This feature is only available for users
// who have Retail Search enabled. Please submit a form here
// (https://cloud.google.com/contact) to contact cloud sales if you are
// interested in using Retail Search.
//
// - placement: The resource name of the search engine placement, such
//   as
//   `projects/*/locations/global/catalogs/default_catalog/placements/def
//   ault_search`. This field is used to identify the serving
//   configuration name and the set of models that will be used to make
//   the search.
func (r *ProjectsLocationsCatalogsPlacementsService) Search(placement string, googlecloudretailv2searchrequest *GoogleCloudRetailV2SearchRequest) *ProjectsLocationsCatalogsPlacementsSearchCall {
	c := &ProjectsLocationsCatalogsPlacementsSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.placement = placement
	c.googlecloudretailv2searchrequest = googlecloudretailv2searchrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsPlacementsSearchCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsPlacementsSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsPlacementsSearchCall) Context(ctx context.Context) *ProjectsLocationsCatalogsPlacementsSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsPlacementsSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsPlacementsSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2searchrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+placement}:search")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"placement": c.placement,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.placements.search" call.
// Exactly one of *GoogleCloudRetailV2SearchResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudRetailV2SearchResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsCatalogsPlacementsSearchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2SearchResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRetailV2SearchResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Performs a search. This feature is only available for users who have Retail Search enabled. Please submit a form [here](https://cloud.google.com/contact) to contact cloud sales if you are interested in using Retail Search.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/placements/{placementsId}:search",
	//   "httpMethod": "POST",
	//   "id": "retail.projects.locations.catalogs.placements.search",
	//   "parameterOrder": [
	//     "placement"
	//   ],
	//   "parameters": {
	//     "placement": {
	//       "description": "Required. The resource name of the search engine placement, such as `projects/*/locations/global/catalogs/default_catalog/placements/default_search`. This field is used to identify the serving configuration name and the set of models that will be used to make the search.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+/placements/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+placement}:search",
	//   "request": {
	//     "$ref": "GoogleCloudRetailV2SearchRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRetailV2SearchResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsCatalogsPlacementsSearchCall) Pages(ctx context.Context, f func(*GoogleCloudRetailV2SearchResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.googlecloudretailv2searchrequest.PageToken = pt }(c.googlecloudretailv2searchrequest.PageToken) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googlecloudretailv2searchrequest.PageToken = x.NextPageToken
	}
}

// method id "retail.projects.locations.catalogs.userEvents.collect":

type ProjectsLocationsCatalogsUserEventsCollectCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Collect: Writes a single user event from the browser. This uses a GET
// request to due to browser restriction of POST-ing to a 3rd party
// domain. This method is used only by the Retail API JavaScript pixel
// and Google Tag Manager. Users should not call this method directly.
//
// - parent: The parent catalog name, such as
//   `projects/1234/locations/global/catalogs/default_catalog`.
func (r *ProjectsLocationsCatalogsUserEventsService) Collect(parent string) *ProjectsLocationsCatalogsUserEventsCollectCall {
	c := &ProjectsLocationsCatalogsUserEventsCollectCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Ets sets the optional parameter "ets": The event timestamp in
// milliseconds. This prevents browser caching of otherwise identical
// get requests. The name is abbreviated to reduce the payload bytes.
func (c *ProjectsLocationsCatalogsUserEventsCollectCall) Ets(ets int64) *ProjectsLocationsCatalogsUserEventsCollectCall {
	c.urlParams_.Set("ets", fmt.Sprint(ets))
	return c
}

// Uri sets the optional parameter "uri": The URL including
// cgi-parameters but excluding the hash fragment with a length limit of
// 5,000 characters. This is often more useful than the referer URL,
// because many browsers only send the domain for 3rd party requests.
func (c *ProjectsLocationsCatalogsUserEventsCollectCall) Uri(uri string) *ProjectsLocationsCatalogsUserEventsCollectCall {
	c.urlParams_.Set("uri", uri)
	return c
}

// UserEvent sets the optional parameter "userEvent": Required. URL
// encoded UserEvent proto with a length limit of 2,000,000 characters.
func (c *ProjectsLocationsCatalogsUserEventsCollectCall) UserEvent(userEvent string) *ProjectsLocationsCatalogsUserEventsCollectCall {
	c.urlParams_.Set("userEvent", userEvent)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsUserEventsCollectCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsUserEventsCollectCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsCatalogsUserEventsCollectCall) IfNoneMatch(entityTag string) *ProjectsLocationsCatalogsUserEventsCollectCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsUserEventsCollectCall) Context(ctx context.Context) *ProjectsLocationsCatalogsUserEventsCollectCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsUserEventsCollectCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsUserEventsCollectCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/userEvents:collect")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.userEvents.collect" call.
// Exactly one of *GoogleApiHttpBody or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleApiHttpBody.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsUserEventsCollectCall) Do(opts ...googleapi.CallOption) (*GoogleApiHttpBody, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleApiHttpBody{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Writes a single user event from the browser. This uses a GET request to due to browser restriction of POST-ing to a 3rd party domain. This method is used only by the Retail API JavaScript pixel and Google Tag Manager. Users should not call this method directly.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/userEvents:collect",
	//   "httpMethod": "GET",
	//   "id": "retail.projects.locations.catalogs.userEvents.collect",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "ets": {
	//       "description": "The event timestamp in milliseconds. This prevents browser caching of otherwise identical get requests. The name is abbreviated to reduce the payload bytes.",
	//       "format": "int64",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent catalog name, such as `projects/1234/locations/global/catalogs/default_catalog`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "uri": {
	//       "description": "The URL including cgi-parameters but excluding the hash fragment with a length limit of 5,000 characters. This is often more useful than the referer URL, because many browsers only send the domain for 3rd party requests.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "userEvent": {
	//       "description": "Required. URL encoded UserEvent proto with a length limit of 2,000,000 characters.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+parent}/userEvents:collect",
	//   "response": {
	//     "$ref": "GoogleApiHttpBody"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.userEvents.import":

type ProjectsLocationsCatalogsUserEventsImportCall struct {
	s                                          *Service
	parent                                     string
	googlecloudretailv2importusereventsrequest *GoogleCloudRetailV2ImportUserEventsRequest
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// Import: Bulk import of User events. Request processing might be
// synchronous. Events that already exist are skipped. Use this method
// for backfilling historical user events. Operation.response is of type
// ImportResponse. Note that it is possible for a subset of the items to
// be successfully inserted. Operation.metadata is of type
// ImportMetadata.
//
// - parent: `projects/1234/locations/global/catalogs/default_catalog`.
func (r *ProjectsLocationsCatalogsUserEventsService) Import(parent string, googlecloudretailv2importusereventsrequest *GoogleCloudRetailV2ImportUserEventsRequest) *ProjectsLocationsCatalogsUserEventsImportCall {
	c := &ProjectsLocationsCatalogsUserEventsImportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudretailv2importusereventsrequest = googlecloudretailv2importusereventsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsUserEventsImportCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsUserEventsImportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsUserEventsImportCall) Context(ctx context.Context) *ProjectsLocationsCatalogsUserEventsImportCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsUserEventsImportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsUserEventsImportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2importusereventsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/userEvents:import")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.userEvents.import" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsUserEventsImportCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Bulk import of User events. Request processing might be synchronous. Events that already exist are skipped. Use this method for backfilling historical user events. Operation.response is of type ImportResponse. Note that it is possible for a subset of the items to be successfully inserted. Operation.metadata is of type ImportMetadata.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/userEvents:import",
	//   "httpMethod": "POST",
	//   "id": "retail.projects.locations.catalogs.userEvents.import",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. `projects/1234/locations/global/catalogs/default_catalog`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+parent}/userEvents:import",
	//   "request": {
	//     "$ref": "GoogleCloudRetailV2ImportUserEventsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.userEvents.purge":

type ProjectsLocationsCatalogsUserEventsPurgeCall struct {
	s                                         *Service
	parent                                    string
	googlecloudretailv2purgeusereventsrequest *GoogleCloudRetailV2PurgeUserEventsRequest
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// Purge: Deletes permanently all user events specified by the filter
// provided. Depending on the number of events specified by the filter,
// this operation could take hours or days to complete. To test a
// filter, use the list command first.
//
// - parent: The resource name of the catalog under which the events are
//   created. The format is
//   `projects/${projectId}/locations/global/catalogs/${catalogId}`.
func (r *ProjectsLocationsCatalogsUserEventsService) Purge(parent string, googlecloudretailv2purgeusereventsrequest *GoogleCloudRetailV2PurgeUserEventsRequest) *ProjectsLocationsCatalogsUserEventsPurgeCall {
	c := &ProjectsLocationsCatalogsUserEventsPurgeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudretailv2purgeusereventsrequest = googlecloudretailv2purgeusereventsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsUserEventsPurgeCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsUserEventsPurgeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsUserEventsPurgeCall) Context(ctx context.Context) *ProjectsLocationsCatalogsUserEventsPurgeCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsUserEventsPurgeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsUserEventsPurgeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2purgeusereventsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/userEvents:purge")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.userEvents.purge" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsUserEventsPurgeCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes permanently all user events specified by the filter provided. Depending on the number of events specified by the filter, this operation could take hours or days to complete. To test a filter, use the list command first.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/userEvents:purge",
	//   "httpMethod": "POST",
	//   "id": "retail.projects.locations.catalogs.userEvents.purge",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The resource name of the catalog under which the events are created. The format is `projects/${projectId}/locations/global/catalogs/${catalogId}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+parent}/userEvents:purge",
	//   "request": {
	//     "$ref": "GoogleCloudRetailV2PurgeUserEventsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.userEvents.rejoin":

type ProjectsLocationsCatalogsUserEventsRejoinCall struct {
	s                                          *Service
	parent                                     string
	googlecloudretailv2rejoinusereventsrequest *GoogleCloudRetailV2RejoinUserEventsRequest
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// Rejoin: Triggers a user event rejoin operation with latest product
// catalog. Events will not be annotated with detailed product
// information if product is missing from the catalog at the time the
// user event is ingested, and these events are stored as unjoined
// events with a limited usage on training and serving. This API can be
// used to trigger a 'join' operation on specified events with latest
// version of product catalog. It can also be used to correct events
// joined with wrong product catalog.
//
// - parent: The parent catalog resource name, such as
//   `projects/1234/locations/global/catalogs/default_catalog`.
func (r *ProjectsLocationsCatalogsUserEventsService) Rejoin(parent string, googlecloudretailv2rejoinusereventsrequest *GoogleCloudRetailV2RejoinUserEventsRequest) *ProjectsLocationsCatalogsUserEventsRejoinCall {
	c := &ProjectsLocationsCatalogsUserEventsRejoinCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudretailv2rejoinusereventsrequest = googlecloudretailv2rejoinusereventsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsUserEventsRejoinCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsUserEventsRejoinCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsUserEventsRejoinCall) Context(ctx context.Context) *ProjectsLocationsCatalogsUserEventsRejoinCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsUserEventsRejoinCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsUserEventsRejoinCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2rejoinusereventsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/userEvents:rejoin")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.userEvents.rejoin" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsUserEventsRejoinCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Triggers a user event rejoin operation with latest product catalog. Events will not be annotated with detailed product information if product is missing from the catalog at the time the user event is ingested, and these events are stored as unjoined events with a limited usage on training and serving. This API can be used to trigger a 'join' operation on specified events with latest version of product catalog. It can also be used to correct events joined with wrong product catalog.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/userEvents:rejoin",
	//   "httpMethod": "POST",
	//   "id": "retail.projects.locations.catalogs.userEvents.rejoin",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent catalog resource name, such as `projects/1234/locations/global/catalogs/default_catalog`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+parent}/userEvents:rejoin",
	//   "request": {
	//     "$ref": "GoogleCloudRetailV2RejoinUserEventsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.catalogs.userEvents.write":

type ProjectsLocationsCatalogsUserEventsWriteCall struct {
	s                            *Service
	parent                       string
	googlecloudretailv2userevent *GoogleCloudRetailV2UserEvent
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// Write: Writes a single user event.
//
// - parent: The parent catalog resource name, such as
//   `projects/1234/locations/global/catalogs/default_catalog`.
func (r *ProjectsLocationsCatalogsUserEventsService) Write(parent string, googlecloudretailv2userevent *GoogleCloudRetailV2UserEvent) *ProjectsLocationsCatalogsUserEventsWriteCall {
	c := &ProjectsLocationsCatalogsUserEventsWriteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudretailv2userevent = googlecloudretailv2userevent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsCatalogsUserEventsWriteCall) Fields(s ...googleapi.Field) *ProjectsLocationsCatalogsUserEventsWriteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsCatalogsUserEventsWriteCall) Context(ctx context.Context) *ProjectsLocationsCatalogsUserEventsWriteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsCatalogsUserEventsWriteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsCatalogsUserEventsWriteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudretailv2userevent)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/userEvents:write")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.catalogs.userEvents.write" call.
// Exactly one of *GoogleCloudRetailV2UserEvent or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudRetailV2UserEvent.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsCatalogsUserEventsWriteCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRetailV2UserEvent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudRetailV2UserEvent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Writes a single user event.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/catalogs/{catalogsId}/userEvents:write",
	//   "httpMethod": "POST",
	//   "id": "retail.projects.locations.catalogs.userEvents.write",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent catalog resource name, such as `projects/1234/locations/global/catalogs/default_catalog`.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/catalogs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+parent}/userEvents:write",
	//   "request": {
	//     "$ref": "GoogleCloudRetailV2UserEvent"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudRetailV2UserEvent"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.operations.get":

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.operations.get" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "retail.projects.locations.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/operations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "retail.projects.locations.operations.list":

type ProjectsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the
// request. If the server doesn't support this method, it returns
// `UNIMPLEMENTED`. NOTE: the `name` binding allows API services to
// override the binding to use different resource name schemes, such as
// `users/*/operations`. To override the binding, API services can add a
// binding such as "/v1/{name=users/*}/operations" to their service
// configuration. For backwards compatibility, the default name includes
// the operations collection id, however overriding users must ensure
// the name binding is the parent resource, without the operations
// collection id.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsOperationsService) List(name string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list
// filter.
func (c *ProjectsLocationsOperationsListCall) Filter(filter string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list
// page size.
func (c *ProjectsLocationsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list
// page token.
func (c *ProjectsLocationsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211201")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "retail.projects.locations.operations.list" call.
// Exactly one of *GoogleLongrunningListOperationsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`. NOTE: the `name` binding allows API services to override the binding to use different resource name schemes, such as `users/*/operations`. To override the binding, API services can add a binding such as `\"/v1/{name=users/*}/operations\"` to their service configuration. For backwards compatibility, the default name includes the operations collection id, however overriding users must ensure the name binding is the parent resource, without the operations collection id.",
	//   "flatPath": "v2/projects/{projectsId}/locations/{locationsId}/operations",
	//   "httpMethod": "GET",
	//   "id": "retail.projects.locations.operations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The standard list filter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The name of the operation's parent resource.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The standard list page size.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The standard list page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2/{+name}/operations",
	//   "response": {
	//     "$ref": "GoogleLongrunningListOperationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
