#ifndef MULTIPLICITY_H_INCLUDED
#define MULTIPLICITY_H_INCLUDED

#include "polynomial.h"
#include "matrix.h"

/**
 * By multiplicative coordinate changes in the Laurent polynomial ring this routine produces a simpler ideal (and a ring) with the same multiplicity as g. This routine also preserves the mixed volume of the Newton polytopes.
 */
PolynomialSet idealWithSameMultiplicity(PolynomialSet const &g);

int multiplicity(PolynomialSet const &g);
/* Computes the multiplicity of a d-dimensional ideal with the d-dimensional homogeneity space. The input must be a marked, reduced Gr\"oebner basis */

/**
 * Given a marked list of polynomials, this routine will compute the number of monomials not in
 * the ideal generated by the marked terms. The number is assumed to be finite.
 */
int numberOfStandardMonomials(PolynomialSet const &markedGroebnerBasis);



Polynomial multiplicativeChangeInv(Polynomial const &p, IntegerMatrix const &lattice, PolynomialRing const &r2);

/**
 * Every exponent vector difference of a polynomial in g is assumed to be in the lattice generated by the rows of lattice.
 * The output of this routine is a list of Laurent polynomials which are obtained by expressing these differences
 * in terms of the lattice generators. The resulting polynomials are in r2 which is a polynomial ring with the same coefficient
 * field as that of g and whose number of variables equals the dimension of the lattice.
 */
PolynomialSet multiplicativeChangeInv(PolynomialSet const &g, IntegerMatrix const &lattice, PolynomialRing const &r2);

#endif
