/**************************************************************************\
 gfxdump (Program for dumping graphics chip registers)

  Copyright (C) 1999 yvind Aabling.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#define GETREG(TYPE,PTR,OFFZ)	(*((volatile TYPE*)((PTR)+(OFFZ))))
#define SETREG(TYPE,PTR,OFFZ)	(*((volatile TYPE*)((PTR)+(OFFZ))))

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#ifdef __unix__
#include <sys/mman.h>
#endif
#include "AsmMacros.h"

/* Unsigned 1, 2 and 4 byte ints */
#define u8	unsigned char
#define u16	unsigned short
#define u32	unsigned long

#ifndef __unix__

/*#include "winioctl.h"*/
#define FILE_DEVICE_UNKNOWN             0x00000022
#define METHOD_NEITHER                  3
#define FILE_ANY_ACCESS                 0
#define CTL_CODE( DeviceType, Function, Method, Access ) ( \
    ((DeviceType)<<16) | ((Access)<<14) | ((Function)<<2) | (Method) )

#include <windows.h>
#define NotVxD
#include "mapdev.h"
#endif

/* Memory Map a piece of Real Memory */
static void *mymmap(int mem, u32 base, u32 size) {

  #ifdef __unix__

  void *ptr=mmap(0,size,PROT_READ|PROT_WRITE,MAP_SHARED,mem,base) ;
  if ((int)ptr == -1) { perror("gfxdump: mmap() failed") ; exit(1) ; }

  return ptr ;

  #else

  HANDLE hDevice ;
  PVOID inBuf[1] ;		/* buffer for struct pointer to VxD */
  DWORD RetInfo[2] ;		/* buffer to receive data from VxD */
  DWORD cbBytesReturned ;	/* count of bytes returned from VxD */
  MAPDEVREQUEST req ;		/* map device request structure */
  DWORD *pNicstar, Status, Time ; int i ; char *endptr ;
  const PCHAR VxDName = "\\\\.\\MAPDEV.VXD" ;
  const PCHAR VxDNameAlreadyLoaded = "\\\\.\\MAPDEV" ;

  hDevice = CreateFile(VxDName, 0,0,0,
                       CREATE_NEW, FILE_FLAG_DELETE_ON_CLOSE, 0) ;
  if (hDevice == INVALID_HANDLE_VALUE)
    hDevice = CreateFile(VxDNameAlreadyLoaded, 0,0,0,
                         CREATE_NEW, FILE_FLAG_DELETE_ON_CLOSE, 0) ;
  if (hDevice == INVALID_HANDLE_VALUE) {
    fprintf(stderr, "Cannot open driver, error=%08lx\n", GetLastError()) ;
    exit(1) ; }

  req.mdr_ServiceID = MDR_SERVICE_MAP ;
  req.mdr_PhysicalAddress = (PVOID)base ;
  req.mdr_SizeInBytes = size ;
  inBuf[0] = &req ;

  if ( ! DeviceIoControl(hDevice, MDR_SERVICE_MAP, inBuf, sizeof(PVOID),
         NULL, 0, &cbBytesReturned, NULL) ) {
    fprintf(stderr, "Failed to map device\n") ; exit(1) ; }

  return (void*)req.mdr_LinearAddress ;

  #endif

}

/* Unmap a Memory Mapped piece of Real Memory */
static void mymunmap(void *ptr, u32 size) {

  #ifdef __unix__

  int res=munmap(ptr,size) ;
  if (res == -1) { perror("gfxdump: munmap() failed") ; exit(1) ; }

  #endif

}
