#!/bin/sh

set -u

testname=$1
testbase="$(dirname "$(realpath "$0")")"
testdir="$testbase/$testname"
packagebase="$(dirname "$testbase")"

run_comp() {
	(cd "$testdir" && "$packagebase/dh_shell_completions" -v)
}

comp_path() {
	case $1 in
		bash)
			echo "$testdir/debian/$testname/usr/share/bash-completion/completions/$testname"
			;;
		fish)
			echo "$testdir/debian/$testname/usr/share/fish/vendor_completions.d/$testname.fish"
			;;
		zsh)
			echo "$testdir/debian/$testname/usr/share/zsh/vendor-completions/_$testname"
			;;
	esac
}

clean() {
	(cd "$testdir" && dh clean)
}

run_comp

result=0

for s in bash fish zsh; do
	path="$(comp_path $s)"
	if [ ! -e "$path" ]; then
		result=1
		echo >&2 "  $s completion is not at expected location or does not exist"
	fi

	content="$(cat "$path")"
	expected="$s $s $s $s"
	if [ "$content" != "$expected" ]; then
		result=1
		echo >&2 "  $s completion content is unexpected:"
		echo >&2 "  expected: \`$expected\`"
		echo >&2 "  actual: \`$content\`"
	fi
done

if [ $result -eq 0 ]; then
	clean
else
	exit $result
fi
