/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * @test
 * @bug 8054817
 * @summary File ccache only recognizes Linux and Solaris defaults
 * @modules java.security.jgss/sun.security.krb5.internal.ccache
 */

import sun.security.krb5.internal.ccache.FileCredentialsCache;

public class DefaultFile {
    public static void main(String[] args) throws Exception {
        // There are 2 cases where default ccache name is not
        // /tmp/krb5cc_uid.
        if (System.getenv("KRB5CCNAME") != null) {
            return;
        }
        if (System.getProperty("os.name").startsWith("Windows")) {
            return;
        }
        String name = FileCredentialsCache.getDefaultCacheName();
        if (!name.startsWith("/tmp/krb5cc_")) {
            throw new Exception("default name is " + name);
        }
    }
}
