// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.


//---------------------------------------------------------------------------

//
// This file is automatically generated.  Please do not edit it directly.
//
// File name: generated_process_message.inl
//---------------------------------------------------------------------------

switch (nCmdType)
{
    case MilCmdTransportSyncFlush:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_TRANSPORT_SYNCFLUSH))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_TRANSPORT_SYNCFLUSH* pCmd = 
            reinterpret_cast<const MILCMD_TRANSPORT_SYNCFLUSH*>(pcvData);

        //
        // This command needs a special handler. We will call a special case 
        // CComposition method instead of routing the command to a resource.
        //

        IFC(Transport_SyncFlush(pChannel, pHandleTable, pCmd));
    }
    break;

    case MilCmdTransportDestroyResourcesOnChannel:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_TRANSPORT_DESTROYRESOURCESONCHANNEL))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_TRANSPORT_DESTROYRESOURCESONCHANNEL* pCmd = 
            reinterpret_cast<const MILCMD_TRANSPORT_DESTROYRESOURCESONCHANNEL*>(pcvData);

        //
        // This command needs a special handler. We will call a special case 
        // CComposition method instead of routing the command to a resource.
        //

        IFC(Transport_DestroyResourcesOnChannel(pChannel, pHandleTable, pCmd));
    }
    break;

    case MilCmdPartitionRegisterForNotifications:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_PARTITION_REGISTERFORNOTIFICATIONS))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_PARTITION_REGISTERFORNOTIFICATIONS* pCmd = 
            reinterpret_cast<const MILCMD_PARTITION_REGISTERFORNOTIFICATIONS*>(pcvData);

        //
        // This command needs a special handler. We will call a special case 
        // CComposition method instead of routing the command to a resource.
        //

        IFC(Partition_RegisterForNotifications(pChannel, pHandleTable, pCmd));
    }
    break;

    case MilCmdChannelRequestTier:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_CHANNEL_REQUESTTIER))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_CHANNEL_REQUESTTIER* pCmd = 
            reinterpret_cast<const MILCMD_CHANNEL_REQUESTTIER*>(pcvData);

        //
        // This command needs a special handler. We will call a special case 
        // CComposition method instead of routing the command to a resource.
        //

        IFC(Channel_RequestTier(pChannel, pHandleTable, pCmd));
    }
    break;

    case MilCmdPartitionSetVBlankSyncMode:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_PARTITION_SETVBLANKSYNCMODE))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_PARTITION_SETVBLANKSYNCMODE* pCmd = 
            reinterpret_cast<const MILCMD_PARTITION_SETVBLANKSYNCMODE*>(pcvData);

        //
        // This command needs a special handler. We will call a special case 
        // CComposition method instead of routing the command to a resource.
        //

        IFC(Partition_SetVBlankSyncMode(pChannel, pHandleTable, pCmd));
    }
    break;

    case MilCmdPartitionNotifyPresent:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_PARTITION_NOTIFYPRESENT))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_PARTITION_NOTIFYPRESENT* pCmd = 
            reinterpret_cast<const MILCMD_PARTITION_NOTIFYPRESENT*>(pcvData);

        //
        // This command needs a special handler. We will call a special case 
        // CComposition method instead of routing the command to a resource.
        //

        IFC(Partition_NotifyPresent(pChannel, pHandleTable, pCmd));
    }
    break;

    case MilCmdChannelCreateResource:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_CHANNEL_CREATERESOURCE))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_CHANNEL_CREATERESOURCE* pCmd = 
            reinterpret_cast<const MILCMD_CHANNEL_CREATERESOURCE*>(pcvData);

        //
        // This command needs a special handler. We will call a special case 
        // CComposition method instead of routing the command to a resource.
        //

        IFC(Channel_CreateResource(pChannel, pHandleTable, pCmd));
    }
    break;

    case MilCmdChannelDeleteResource:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_CHANNEL_DELETERESOURCE))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_CHANNEL_DELETERESOURCE* pCmd = 
            reinterpret_cast<const MILCMD_CHANNEL_DELETERESOURCE*>(pcvData);

        //
        // This command needs a special handler. We will call a special case 
        // CComposition method instead of routing the command to a resource.
        //

        IFC(Channel_DeleteResource(pChannel, pHandleTable, pCmd));
    }
    break;

    case MilCmdChannelDuplicateHandle:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_CHANNEL_DUPLICATEHANDLE))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_CHANNEL_DUPLICATEHANDLE* pCmd = 
            reinterpret_cast<const MILCMD_CHANNEL_DUPLICATEHANDLE*>(pcvData);

        //
        // This command needs a special handler. We will call a special case 
        // CComposition method instead of routing the command to a resource.
        //

        IFC(Channel_DuplicateHandle(pChannel, pHandleTable, pCmd));
    }
    break;

    case MilCmdD3DImage:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_D3DIMAGE))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_D3DIMAGE* pCmd = 
            reinterpret_cast<const MILCMD_D3DIMAGE*>(pcvData);

        CMilD3DImageDuce* pResource =
            static_cast<CMilD3DImageDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_D3DIMAGE
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdD3DImagePresent:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_D3DIMAGE_PRESENT))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_D3DIMAGE_PRESENT* pCmd = 
            reinterpret_cast<const MILCMD_D3DIMAGE_PRESENT*>(pcvData);

        CMilD3DImageDuce* pResource =
            static_cast<CMilD3DImageDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_D3DIMAGE
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessPresent(pHandleTable, pCmd));
    }
    break;

    case MilCmdBitmapSource:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_BITMAP_SOURCE))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_BITMAP_SOURCE* pCmd = 
            reinterpret_cast<const MILCMD_BITMAP_SOURCE*>(pcvData);

        CMilSlaveBitmap* pResource =
            static_cast<CMilSlaveBitmap*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_BITMAPSOURCE
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessSource(pHandleTable, pCmd));
    }
    break;

    case MilCmdBitmapInvalidate:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_BITMAP_INVALIDATE))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_BITMAP_INVALIDATE* pCmd = 
            reinterpret_cast<const MILCMD_BITMAP_INVALIDATE*>(pcvData);

        CMilSlaveBitmap* pResource =
            static_cast<CMilSlaveBitmap*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_BITMAPSOURCE
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessInvalidate(pHandleTable, pCmd));
    }
    break;

    case MilCmdDoubleResource:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_DOUBLERESOURCE))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_DOUBLERESOURCE* pCmd = 
            reinterpret_cast<const MILCMD_DOUBLERESOURCE*>(pcvData);

        CMilSlaveDouble* pResource =
            static_cast<CMilSlaveDouble*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_DOUBLERESOURCE
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdColorResource:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_COLORRESOURCE))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_COLORRESOURCE* pCmd = 
            reinterpret_cast<const MILCMD_COLORRESOURCE*>(pcvData);

        CMilSlaveColor* pResource =
            static_cast<CMilSlaveColor*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_COLORRESOURCE
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdPointResource:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_POINTRESOURCE))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_POINTRESOURCE* pCmd = 
            reinterpret_cast<const MILCMD_POINTRESOURCE*>(pcvData);

        CMilSlavePoint* pResource =
            static_cast<CMilSlavePoint*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_POINTRESOURCE
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdRectResource:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_RECTRESOURCE))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_RECTRESOURCE* pCmd = 
            reinterpret_cast<const MILCMD_RECTRESOURCE*>(pcvData);

        CMilSlaveRect* pResource =
            static_cast<CMilSlaveRect*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_RECTRESOURCE
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdSizeResource:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_SIZERESOURCE))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_SIZERESOURCE* pCmd = 
            reinterpret_cast<const MILCMD_SIZERESOURCE*>(pcvData);

        CMilSlaveSize* pResource =
            static_cast<CMilSlaveSize*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_SIZERESOURCE
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdMatrixResource:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_MATRIXRESOURCE))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_MATRIXRESOURCE* pCmd = 
            reinterpret_cast<const MILCMD_MATRIXRESOURCE*>(pcvData);

        CMilSlaveMatrix* pResource =
            static_cast<CMilSlaveMatrix*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_MATRIXRESOURCE
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdPoint3DResource:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_POINT3DRESOURCE))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_POINT3DRESOURCE* pCmd = 
            reinterpret_cast<const MILCMD_POINT3DRESOURCE*>(pcvData);

        CMilSlavePoint3D* pResource =
            static_cast<CMilSlavePoint3D*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_POINT3DRESOURCE
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdVector3DResource:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_VECTOR3DRESOURCE))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_VECTOR3DRESOURCE* pCmd = 
            reinterpret_cast<const MILCMD_VECTOR3DRESOURCE*>(pcvData);

        CMilSlaveVector3D* pResource =
            static_cast<CMilSlaveVector3D*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_VECTOR3DRESOURCE
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdQuaternionResource:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_QUATERNIONRESOURCE))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_QUATERNIONRESOURCE* pCmd = 
            reinterpret_cast<const MILCMD_QUATERNIONRESOURCE*>(pcvData);

        CMilSlaveQuaternion* pResource =
            static_cast<CMilSlaveQuaternion*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_QUATERNIONRESOURCE
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdMediaPlayer:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_MEDIAPLAYER))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_MEDIAPLAYER* pCmd = 
            reinterpret_cast<const MILCMD_MEDIAPLAYER*>(pcvData);

        CMilSlaveVideo* pResource =
            static_cast<CMilSlaveVideo*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_MEDIAPLAYER
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdRenderData:
    {
        #ifdef DEBUG
        if (cbSize < sizeof(MILCMD_RENDERDATA))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_RENDERDATA* pCmd = 
            reinterpret_cast<const MILCMD_RENDERDATA*>(pcvData);

        LPCVOID pPayload = reinterpret_cast<LPCVOID>(pCmd + 1);
        UINT cbPayload = cbSize - sizeof(MILCMD_RENDERDATA);

        CMilSlaveRenderData* pResource =
            static_cast<CMilSlaveRenderData*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_RENDERDATA
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd, pPayload, cbPayload));
    }
    break;

    case MilCmdEtwEventResource:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_ETWEVENTRESOURCE))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_ETWEVENTRESOURCE* pCmd = 
            reinterpret_cast<const MILCMD_ETWEVENTRESOURCE*>(pcvData);

        CSlaveEtwEventResource* pResource =
            static_cast<CSlaveEtwEventResource*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_ETWEVENTRESOURCE
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdVisualCreate:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_VISUAL_CREATE))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_VISUAL_CREATE* pCmd = 
            reinterpret_cast<const MILCMD_VISUAL_CREATE*>(pcvData);

        CMilVisual* pResource =
            static_cast<CMilVisual*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_VISUAL
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessCreate(pHandleTable, pCmd));
    }
    break;

    case MilCmdVisualSetOffset:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_VISUAL_SETOFFSET))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_VISUAL_SETOFFSET* pCmd = 
            reinterpret_cast<const MILCMD_VISUAL_SETOFFSET*>(pcvData);

        CMilVisual* pResource =
            static_cast<CMilVisual*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_VISUAL
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessSetOffset(pHandleTable, pCmd));
    }
    break;

    case MilCmdVisualSetTransform:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_VISUAL_SETTRANSFORM))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_VISUAL_SETTRANSFORM* pCmd = 
            reinterpret_cast<const MILCMD_VISUAL_SETTRANSFORM*>(pcvData);

        #ifdef DEBUG
        if (pCmd->hTransform != NULL) 
        {
            const CMilTransformDuce* pResource = 
                static_cast<const CMilTransformDuce*>(pHandleTable->GetResource(
                    pCmd->hTransform, 
                    TYPE_TRANSFORM
                    ));

            if (pResource == NULL) 
            {
                RIP("Invalid resource handle (expected a CMilTransformDuce).");
                IFC(WGXERR_UCE_MALFORMEDPACKET);
            }
        }
        #endif

        CMilVisual* pResource =
            static_cast<CMilVisual*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_VISUAL
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessSetTransform(pHandleTable, pCmd));
    }
    break;

    case MilCmdVisualSetEffect:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_VISUAL_SETEFFECT))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_VISUAL_SETEFFECT* pCmd = 
            reinterpret_cast<const MILCMD_VISUAL_SETEFFECT*>(pcvData);

        #ifdef DEBUG
        if (pCmd->hEffect != NULL) 
        {
            const CMilEffectDuce* pResource = 
                static_cast<const CMilEffectDuce*>(pHandleTable->GetResource(
                    pCmd->hEffect, 
                    TYPE_EFFECT
                    ));

            if (pResource == NULL) 
            {
                RIP("Invalid resource handle (expected a CMilEffectDuce).");
                IFC(WGXERR_UCE_MALFORMEDPACKET);
            }
        }
        #endif

        CMilVisual* pResource =
            static_cast<CMilVisual*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_VISUAL
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessSetEffect(pHandleTable, pCmd));
    }
    break;

    case MilCmdVisualSetCacheMode:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_VISUAL_SETCACHEMODE))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_VISUAL_SETCACHEMODE* pCmd = 
            reinterpret_cast<const MILCMD_VISUAL_SETCACHEMODE*>(pcvData);

        #ifdef DEBUG
        if (pCmd->hCacheMode != NULL) 
        {
            const CMilCacheModeDuce* pResource = 
                static_cast<const CMilCacheModeDuce*>(pHandleTable->GetResource(
                    pCmd->hCacheMode, 
                    TYPE_CACHEMODE
                    ));

            if (pResource == NULL) 
            {
                RIP("Invalid resource handle (expected a CMilCacheModeDuce).");
                IFC(WGXERR_UCE_MALFORMEDPACKET);
            }
        }
        #endif

        CMilVisual* pResource =
            static_cast<CMilVisual*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_VISUAL
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessSetCacheMode(pHandleTable, pCmd));
    }
    break;

    case MilCmdVisualSetClip:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_VISUAL_SETCLIP))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_VISUAL_SETCLIP* pCmd = 
            reinterpret_cast<const MILCMD_VISUAL_SETCLIP*>(pcvData);

        #ifdef DEBUG
        if (pCmd->hClip != NULL) 
        {
            const CMilGeometryDuce* pResource = 
                static_cast<const CMilGeometryDuce*>(pHandleTable->GetResource(
                    pCmd->hClip, 
                    TYPE_GEOMETRY
                    ));

            if (pResource == NULL) 
            {
                RIP("Invalid resource handle (expected a CMilGeometryDuce).");
                IFC(WGXERR_UCE_MALFORMEDPACKET);
            }
        }
        #endif

        CMilVisual* pResource =
            static_cast<CMilVisual*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_VISUAL
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessSetClip(pHandleTable, pCmd));
    }
    break;

    case MilCmdVisualSetAlpha:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_VISUAL_SETALPHA))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_VISUAL_SETALPHA* pCmd = 
            reinterpret_cast<const MILCMD_VISUAL_SETALPHA*>(pcvData);

        CMilVisual* pResource =
            static_cast<CMilVisual*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_VISUAL
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessSetAlpha(pHandleTable, pCmd));
    }
    break;

    case MilCmdVisualSetRenderOptions:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_VISUAL_SETRENDEROPTIONS))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_VISUAL_SETRENDEROPTIONS* pCmd = 
            reinterpret_cast<const MILCMD_VISUAL_SETRENDEROPTIONS*>(pcvData);

        CMilVisual* pResource =
            static_cast<CMilVisual*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_VISUAL
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessSetRenderOptions(pHandleTable, pCmd));
    }
    break;

    case MilCmdVisualSetContent:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_VISUAL_SETCONTENT))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_VISUAL_SETCONTENT* pCmd = 
            reinterpret_cast<const MILCMD_VISUAL_SETCONTENT*>(pcvData);

        CMilVisual* pResource =
            static_cast<CMilVisual*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_VISUAL
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessSetContent(pHandleTable, pCmd));
    }
    break;

    case MilCmdVisualSetAlphaMask:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_VISUAL_SETALPHAMASK))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_VISUAL_SETALPHAMASK* pCmd = 
            reinterpret_cast<const MILCMD_VISUAL_SETALPHAMASK*>(pcvData);

        CMilVisual* pResource =
            static_cast<CMilVisual*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_VISUAL
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessSetAlphaMask(pHandleTable, pCmd));
    }
    break;

    case MilCmdVisualRemoveAllChildren:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_VISUAL_REMOVEALLCHILDREN))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_VISUAL_REMOVEALLCHILDREN* pCmd = 
            reinterpret_cast<const MILCMD_VISUAL_REMOVEALLCHILDREN*>(pcvData);

        CMilVisual* pResource =
            static_cast<CMilVisual*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_VISUAL
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessRemoveAllChildren(pHandleTable, pCmd));
    }
    break;

    case MilCmdVisualRemoveChild:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_VISUAL_REMOVECHILD))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_VISUAL_REMOVECHILD* pCmd = 
            reinterpret_cast<const MILCMD_VISUAL_REMOVECHILD*>(pcvData);

        #ifdef DEBUG
        if (pCmd->hChild != NULL) 
        {
            const CMilVisual* pResource = 
                static_cast<const CMilVisual*>(pHandleTable->GetResource(
                    pCmd->hChild, 
                    TYPE_VISUAL
                    ));

            if (pResource == NULL) 
            {
                RIP("Invalid resource handle (expected a CMilVisual).");
                IFC(WGXERR_UCE_MALFORMEDPACKET);
            }
        }
        #endif

        CMilVisual* pResource =
            static_cast<CMilVisual*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_VISUAL
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessRemoveChild(pHandleTable, pCmd));
    }
    break;

    case MilCmdVisualInsertChildAt:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_VISUAL_INSERTCHILDAT))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_VISUAL_INSERTCHILDAT* pCmd = 
            reinterpret_cast<const MILCMD_VISUAL_INSERTCHILDAT*>(pcvData);

        #ifdef DEBUG
        if (pCmd->hChild != NULL) 
        {
            const CMilVisual* pResource = 
                static_cast<const CMilVisual*>(pHandleTable->GetResource(
                    pCmd->hChild, 
                    TYPE_VISUAL
                    ));

            if (pResource == NULL) 
            {
                RIP("Invalid resource handle (expected a CMilVisual).");
                IFC(WGXERR_UCE_MALFORMEDPACKET);
            }
        }
        #endif

        CMilVisual* pResource =
            static_cast<CMilVisual*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_VISUAL
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessInsertChildAt(pHandleTable, pCmd));
    }
    break;

    case MilCmdVisualSetGuidelineCollection:
    {
        #ifdef DEBUG
        if (cbSize < sizeof(MILCMD_VISUAL_SETGUIDELINECOLLECTION))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_VISUAL_SETGUIDELINECOLLECTION* pCmd = 
            reinterpret_cast<const MILCMD_VISUAL_SETGUIDELINECOLLECTION*>(pcvData);

        LPCVOID pPayload = reinterpret_cast<LPCVOID>(pCmd + 1);
        UINT cbPayload = cbSize - sizeof(MILCMD_VISUAL_SETGUIDELINECOLLECTION);

        CMilVisual* pResource =
            static_cast<CMilVisual*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_VISUAL
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessSetGuidelineCollection(pHandleTable, pCmd, pPayload, cbPayload));
    }
    break;

    case MilCmdVisualSetScrollableAreaClip:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_VISUAL_SETSCROLLABLEAREACLIP))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_VISUAL_SETSCROLLABLEAREACLIP* pCmd = 
            reinterpret_cast<const MILCMD_VISUAL_SETSCROLLABLEAREACLIP*>(pcvData);

        CMilVisual* pResource =
            static_cast<CMilVisual*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_VISUAL
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessSetScrollableAreaClip(pHandleTable, pCmd));
    }
    break;

    case MilCmdViewport3DVisualSetCamera:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_VIEWPORT3DVISUAL_SETCAMERA))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_VIEWPORT3DVISUAL_SETCAMERA* pCmd = 
            reinterpret_cast<const MILCMD_VIEWPORT3DVISUAL_SETCAMERA*>(pcvData);

        #ifdef DEBUG
        if (pCmd->hCamera != NULL) 
        {
            const CMilCameraDuce* pResource = 
                static_cast<const CMilCameraDuce*>(pHandleTable->GetResource(
                    pCmd->hCamera, 
                    TYPE_CAMERA
                    ));

            if (pResource == NULL) 
            {
                RIP("Invalid resource handle (expected a CMilCameraDuce).");
                IFC(WGXERR_UCE_MALFORMEDPACKET);
            }
        }
        #endif

        CMilViewport3DVisual* pResource =
            static_cast<CMilViewport3DVisual*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_VIEWPORT3DVISUAL
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessSetCamera(pHandleTable, pCmd));
    }
    break;

    case MilCmdViewport3DVisualSetViewport:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_VIEWPORT3DVISUAL_SETVIEWPORT))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_VIEWPORT3DVISUAL_SETVIEWPORT* pCmd = 
            reinterpret_cast<const MILCMD_VIEWPORT3DVISUAL_SETVIEWPORT*>(pcvData);

        CMilViewport3DVisual* pResource =
            static_cast<CMilViewport3DVisual*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_VIEWPORT3DVISUAL
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessSetViewport(pHandleTable, pCmd));
    }
    break;

    case MilCmdViewport3DVisualSet3DChild:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_VIEWPORT3DVISUAL_SET3DCHILD))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_VIEWPORT3DVISUAL_SET3DCHILD* pCmd = 
            reinterpret_cast<const MILCMD_VIEWPORT3DVISUAL_SET3DCHILD*>(pcvData);

        #ifdef DEBUG
        if (pCmd->hChild != NULL) 
        {
            const CMilVisual3D* pResource = 
                static_cast<const CMilVisual3D*>(pHandleTable->GetResource(
                    pCmd->hChild, 
                    TYPE_VISUAL3D
                    ));

            if (pResource == NULL) 
            {
                RIP("Invalid resource handle (expected a CMilVisual3D).");
                IFC(WGXERR_UCE_MALFORMEDPACKET);
            }
        }
        #endif

        CMilViewport3DVisual* pResource =
            static_cast<CMilViewport3DVisual*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_VIEWPORT3DVISUAL
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessSet3DChild(pHandleTable, pCmd));
    }
    break;

    case MilCmdVisual3DSetContent:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_VISUAL3D_SETCONTENT))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_VISUAL3D_SETCONTENT* pCmd = 
            reinterpret_cast<const MILCMD_VISUAL3D_SETCONTENT*>(pcvData);

        #ifdef DEBUG
        if (pCmd->hContent != NULL) 
        {
            const CMilModel3DDuce* pResource = 
                static_cast<const CMilModel3DDuce*>(pHandleTable->GetResource(
                    pCmd->hContent, 
                    TYPE_MODEL3D
                    ));

            if (pResource == NULL) 
            {
                RIP("Invalid resource handle (expected a CMilModel3DDuce).");
                IFC(WGXERR_UCE_MALFORMEDPACKET);
            }
        }
        #endif

        CMilVisual3D* pResource =
            static_cast<CMilVisual3D*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_VISUAL3D
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessSetContent(pHandleTable, pCmd));
    }
    break;

    case MilCmdVisual3DSetTransform:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_VISUAL3D_SETTRANSFORM))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_VISUAL3D_SETTRANSFORM* pCmd = 
            reinterpret_cast<const MILCMD_VISUAL3D_SETTRANSFORM*>(pcvData);

        #ifdef DEBUG
        if (pCmd->hTransform != NULL) 
        {
            const CMilTransform3DDuce* pResource = 
                static_cast<const CMilTransform3DDuce*>(pHandleTable->GetResource(
                    pCmd->hTransform, 
                    TYPE_TRANSFORM3D
                    ));

            if (pResource == NULL) 
            {
                RIP("Invalid resource handle (expected a CMilTransform3DDuce).");
                IFC(WGXERR_UCE_MALFORMEDPACKET);
            }
        }
        #endif

        CMilVisual3D* pResource =
            static_cast<CMilVisual3D*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_VISUAL3D
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessSetTransform(pHandleTable, pCmd));
    }
    break;

    case MilCmdVisual3DRemoveAllChildren:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_VISUAL3D_REMOVEALLCHILDREN))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_VISUAL3D_REMOVEALLCHILDREN* pCmd = 
            reinterpret_cast<const MILCMD_VISUAL3D_REMOVEALLCHILDREN*>(pcvData);

        CMilVisual3D* pResource =
            static_cast<CMilVisual3D*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_VISUAL3D
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessRemoveAllChildren(pHandleTable, pCmd));
    }
    break;

    case MilCmdVisual3DRemoveChild:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_VISUAL3D_REMOVECHILD))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_VISUAL3D_REMOVECHILD* pCmd = 
            reinterpret_cast<const MILCMD_VISUAL3D_REMOVECHILD*>(pcvData);

        #ifdef DEBUG
        if (pCmd->hChild != NULL) 
        {
            const CMilVisual3D* pResource = 
                static_cast<const CMilVisual3D*>(pHandleTable->GetResource(
                    pCmd->hChild, 
                    TYPE_VISUAL3D
                    ));

            if (pResource == NULL) 
            {
                RIP("Invalid resource handle (expected a CMilVisual3D).");
                IFC(WGXERR_UCE_MALFORMEDPACKET);
            }
        }
        #endif

        CMilVisual3D* pResource =
            static_cast<CMilVisual3D*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_VISUAL3D
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessRemoveChild(pHandleTable, pCmd));
    }
    break;

    case MilCmdVisual3DInsertChildAt:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_VISUAL3D_INSERTCHILDAT))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_VISUAL3D_INSERTCHILDAT* pCmd = 
            reinterpret_cast<const MILCMD_VISUAL3D_INSERTCHILDAT*>(pcvData);

        #ifdef DEBUG
        if (pCmd->hChild != NULL) 
        {
            const CMilVisual3D* pResource = 
                static_cast<const CMilVisual3D*>(pHandleTable->GetResource(
                    pCmd->hChild, 
                    TYPE_VISUAL3D
                    ));

            if (pResource == NULL) 
            {
                RIP("Invalid resource handle (expected a CMilVisual3D).");
                IFC(WGXERR_UCE_MALFORMEDPACKET);
            }
        }
        #endif

        CMilVisual3D* pResource =
            static_cast<CMilVisual3D*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_VISUAL3D
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessInsertChildAt(pHandleTable, pCmd));
    }
    break;

    case MilCmdHwndTargetCreate:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_HWNDTARGET_CREATE))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_HWNDTARGET_CREATE* pCmd = 
            reinterpret_cast<const MILCMD_HWNDTARGET_CREATE*>(pcvData);

        #ifdef DEBUG
        if (pCmd->hBitmap != NULL) 
        {
            const CMilSlaveBitmap* pResource = 
                static_cast<const CMilSlaveBitmap*>(pHandleTable->GetResource(
                    pCmd->hBitmap, 
                    TYPE_BITMAPSOURCE
                    ));

            if (pResource == NULL) 
            {
                RIP("Invalid resource handle (expected a CMilSlaveBitmap).");
                IFC(WGXERR_UCE_MALFORMEDPACKET);
            }
        }
        #endif

        //
        // This command needs a special handler. We will call a special case 
        // CComposition method instead of routing the command to a resource.
        //

        IFC(HwndTarget_Create(pChannel, pHandleTable, pCmd));
    }
    break;

    case MilCmdHwndTargetSuppressLayered:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_HWNDTARGET_SUPPRESSLAYERED))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_HWNDTARGET_SUPPRESSLAYERED* pCmd = 
            reinterpret_cast<const MILCMD_HWNDTARGET_SUPPRESSLAYERED*>(pcvData);

        CSlaveHWndRenderTarget* pResource =
            static_cast<CSlaveHWndRenderTarget*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_HWNDRENDERTARGET
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessSuppressLayered(pHandleTable, pCmd));
    }
    break;

    case MilCmdTargetUpdateWindowSettings:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_TARGET_UPDATEWINDOWSETTINGS))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_TARGET_UPDATEWINDOWSETTINGS* pCmd = 
            reinterpret_cast<const MILCMD_TARGET_UPDATEWINDOWSETTINGS*>(pcvData);

        CRenderTarget* pResource =
            static_cast<CRenderTarget*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_RENDERTARGET
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdateWindowSettings(pHandleTable, pCmd));
    }
    break;

    case MilCmdGenericTargetCreate:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_GENERICTARGET_CREATE))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_GENERICTARGET_CREATE* pCmd = 
            reinterpret_cast<const MILCMD_GENERICTARGET_CREATE*>(pcvData);

        //
        // This command needs a special handler. We will call a special case 
        // CComposition method instead of routing the command to a resource.
        //

        IFC(GenericTarget_Create(pChannel, pHandleTable, pCmd));
    }
    break;

    case MilCmdTargetSetRoot:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_TARGET_SETROOT))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_TARGET_SETROOT* pCmd = 
            reinterpret_cast<const MILCMD_TARGET_SETROOT*>(pcvData);

        #ifdef DEBUG
        if (pCmd->hRoot != NULL) 
        {
            const CMilVisual* pResource = 
                static_cast<const CMilVisual*>(pHandleTable->GetResource(
                    pCmd->hRoot, 
                    TYPE_VISUAL
                    ));

            if (pResource == NULL) 
            {
                RIP("Invalid resource handle (expected a CMilVisual).");
                IFC(WGXERR_UCE_MALFORMEDPACKET);
            }
        }
        #endif

        CRenderTarget* pResource =
            static_cast<CRenderTarget*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_RENDERTARGET
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessSetRoot(pHandleTable, pCmd));
    }
    break;

    case MilCmdTargetSetClearColor:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_TARGET_SETCLEARCOLOR))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_TARGET_SETCLEARCOLOR* pCmd = 
            reinterpret_cast<const MILCMD_TARGET_SETCLEARCOLOR*>(pcvData);

        CRenderTarget* pResource =
            static_cast<CRenderTarget*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_RENDERTARGET
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessSetClearColor(pHandleTable, pCmd));
    }
    break;

    case MilCmdTargetInvalidate:
    {
        #ifdef DEBUG
        if (cbSize < sizeof(MILCMD_TARGET_INVALIDATE))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_TARGET_INVALIDATE* pCmd = 
            reinterpret_cast<const MILCMD_TARGET_INVALIDATE*>(pcvData);

        LPCVOID pPayload = reinterpret_cast<LPCVOID>(pCmd + 1);
        UINT cbPayload = cbSize - sizeof(MILCMD_TARGET_INVALIDATE);

        CRenderTarget* pResource =
            static_cast<CRenderTarget*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_RENDERTARGET
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessInvalidate(pHandleTable, pCmd, pPayload, cbPayload));
    }
    break;

    case MilCmdTargetSetFlags:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_TARGET_SETFLAGS))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_TARGET_SETFLAGS* pCmd = 
            reinterpret_cast<const MILCMD_TARGET_SETFLAGS*>(pcvData);

        CRenderTarget* pResource =
            static_cast<CRenderTarget*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_RENDERTARGET
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessSetFlags(pHandleTable, pCmd));
    }
    break;

    case MilCmdHwndTargetDpiChanged:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_HWNDTARGET_DPICHANGED))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_HWNDTARGET_DPICHANGED* pCmd = 
            reinterpret_cast<const MILCMD_HWNDTARGET_DPICHANGED*>(pcvData);

        CSlaveHWndRenderTarget* pResource =
            static_cast<CSlaveHWndRenderTarget*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_HWNDRENDERTARGET
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessDpiChanged(pHandleTable, pCmd));
    }
    break;

    case MilCmdGlyphRunCreate:
    {
        #ifdef DEBUG
        if (cbSize < sizeof(MILCMD_GLYPHRUN_CREATE))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_GLYPHRUN_CREATE* pCmd = 
            reinterpret_cast<const MILCMD_GLYPHRUN_CREATE*>(pcvData);

        LPCVOID pPayload = reinterpret_cast<LPCVOID>(pCmd + 1);
        UINT cbPayload = cbSize - sizeof(MILCMD_GLYPHRUN_CREATE);

        //
        // This command needs a special handler. We will call a special case 
        // CComposition method instead of routing the command to a resource.
        //

        IFC(GlyphRun_Create(pChannel, pHandleTable, pCmd, pPayload, cbPayload));
    }
    break;

    case MilCmdDoubleBufferedBitmap:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_DOUBLEBUFFEREDBITMAP))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_DOUBLEBUFFEREDBITMAP* pCmd = 
            reinterpret_cast<const MILCMD_DOUBLEBUFFEREDBITMAP*>(pcvData);

        CMilSlaveDoubleBufferedBitmap* pResource =
            static_cast<CMilSlaveDoubleBufferedBitmap*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_DOUBLEBUFFEREDBITMAP
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdDoubleBufferedBitmapCopyForward:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_DOUBLEBUFFEREDBITMAP_COPYFORWARD))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_DOUBLEBUFFEREDBITMAP_COPYFORWARD* pCmd = 
            reinterpret_cast<const MILCMD_DOUBLEBUFFEREDBITMAP_COPYFORWARD*>(pcvData);

        CMilSlaveDoubleBufferedBitmap* pResource =
            static_cast<CMilSlaveDoubleBufferedBitmap*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_DOUBLEBUFFEREDBITMAP
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessCopyForward(pHandleTable, pCmd));
    }
    break;

    case MilCmdPartitionNotifyPolicyChangeForNonInteractiveMode:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_PARTITION_NOTIFYPOLICYCHANGEFORNONINTERACTIVEMODE))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_PARTITION_NOTIFYPOLICYCHANGEFORNONINTERACTIVEMODE* pCmd = 
            reinterpret_cast<const MILCMD_PARTITION_NOTIFYPOLICYCHANGEFORNONINTERACTIVEMODE*>(pcvData);

        //
        // This command needs a special handler. We will call a special case 
        // CComposition method instead of routing the command to a resource.
        //

        IFC(Partition_NotifyPolicyChangeForNonInteractiveMode(pChannel, pHandleTable, pCmd));
    }
    break;

    case MilCmdAxisAngleRotation3D:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_AXISANGLEROTATION3D))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_AXISANGLEROTATION3D* pCmd = 
            reinterpret_cast<const MILCMD_AXISANGLEROTATION3D*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilAxisAngleRotation3DDuce* pResource =
            static_cast<CMilAxisAngleRotation3DDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_AXISANGLEROTATION3D
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdQuaternionRotation3D:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_QUATERNIONROTATION3D))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_QUATERNIONROTATION3D* pCmd = 
            reinterpret_cast<const MILCMD_QUATERNIONROTATION3D*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilQuaternionRotation3DDuce* pResource =
            static_cast<CMilQuaternionRotation3DDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_QUATERNIONROTATION3D
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdPerspectiveCamera:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_PERSPECTIVECAMERA))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_PERSPECTIVECAMERA* pCmd = 
            reinterpret_cast<const MILCMD_PERSPECTIVECAMERA*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilPerspectiveCameraDuce* pResource =
            static_cast<CMilPerspectiveCameraDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_PERSPECTIVECAMERA
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdOrthographicCamera:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_ORTHOGRAPHICCAMERA))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_ORTHOGRAPHICCAMERA* pCmd = 
            reinterpret_cast<const MILCMD_ORTHOGRAPHICCAMERA*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilOrthographicCameraDuce* pResource =
            static_cast<CMilOrthographicCameraDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_ORTHOGRAPHICCAMERA
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdMatrixCamera:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_MATRIXCAMERA))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_MATRIXCAMERA* pCmd = 
            reinterpret_cast<const MILCMD_MATRIXCAMERA*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilMatrixCameraDuce* pResource =
            static_cast<CMilMatrixCameraDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_MATRIXCAMERA
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdModel3DGroup:
    {
        #ifdef DEBUG
        if (cbSize < sizeof(MILCMD_MODEL3DGROUP))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_MODEL3DGROUP* pCmd = 
            reinterpret_cast<const MILCMD_MODEL3DGROUP*>(pcvData);

        LPCVOID pPayload = reinterpret_cast<LPCVOID>(pCmd + 1);
        UINT cbPayload = cbSize - sizeof(MILCMD_MODEL3DGROUP);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilModel3DGroupDuce* pResource =
            static_cast<CMilModel3DGroupDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_MODEL3DGROUP
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd, pPayload, cbPayload));
    }
    break;

    case MilCmdAmbientLight:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_AMBIENTLIGHT))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_AMBIENTLIGHT* pCmd = 
            reinterpret_cast<const MILCMD_AMBIENTLIGHT*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilAmbientLightDuce* pResource =
            static_cast<CMilAmbientLightDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_AMBIENTLIGHT
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdDirectionalLight:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_DIRECTIONALLIGHT))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_DIRECTIONALLIGHT* pCmd = 
            reinterpret_cast<const MILCMD_DIRECTIONALLIGHT*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilDirectionalLightDuce* pResource =
            static_cast<CMilDirectionalLightDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_DIRECTIONALLIGHT
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdPointLight:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_POINTLIGHT))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_POINTLIGHT* pCmd = 
            reinterpret_cast<const MILCMD_POINTLIGHT*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilPointLightDuce* pResource =
            static_cast<CMilPointLightDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_POINTLIGHT
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdSpotLight:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_SPOTLIGHT))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_SPOTLIGHT* pCmd = 
            reinterpret_cast<const MILCMD_SPOTLIGHT*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilSpotLightDuce* pResource =
            static_cast<CMilSpotLightDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_SPOTLIGHT
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdGeometryModel3D:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_GEOMETRYMODEL3D))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_GEOMETRYMODEL3D* pCmd = 
            reinterpret_cast<const MILCMD_GEOMETRYMODEL3D*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilGeometryModel3DDuce* pResource =
            static_cast<CMilGeometryModel3DDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_GEOMETRYMODEL3D
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdMeshGeometry3D:
    {
        #ifdef DEBUG
        if (cbSize < sizeof(MILCMD_MESHGEOMETRY3D))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_MESHGEOMETRY3D* pCmd = 
            reinterpret_cast<const MILCMD_MESHGEOMETRY3D*>(pcvData);

        LPCVOID pPayload = reinterpret_cast<LPCVOID>(pCmd + 1);
        UINT cbPayload = cbSize - sizeof(MILCMD_MESHGEOMETRY3D);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilMeshGeometry3DDuce* pResource =
            static_cast<CMilMeshGeometry3DDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_MESHGEOMETRY3D
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd, pPayload, cbPayload));
    }
    break;

    case MilCmdMaterialGroup:
    {
        #ifdef DEBUG
        if (cbSize < sizeof(MILCMD_MATERIALGROUP))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_MATERIALGROUP* pCmd = 
            reinterpret_cast<const MILCMD_MATERIALGROUP*>(pcvData);

        LPCVOID pPayload = reinterpret_cast<LPCVOID>(pCmd + 1);
        UINT cbPayload = cbSize - sizeof(MILCMD_MATERIALGROUP);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilMaterialGroupDuce* pResource =
            static_cast<CMilMaterialGroupDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_MATERIALGROUP
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd, pPayload, cbPayload));
    }
    break;

    case MilCmdDiffuseMaterial:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_DIFFUSEMATERIAL))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_DIFFUSEMATERIAL* pCmd = 
            reinterpret_cast<const MILCMD_DIFFUSEMATERIAL*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilDiffuseMaterialDuce* pResource =
            static_cast<CMilDiffuseMaterialDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_DIFFUSEMATERIAL
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdSpecularMaterial:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_SPECULARMATERIAL))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_SPECULARMATERIAL* pCmd = 
            reinterpret_cast<const MILCMD_SPECULARMATERIAL*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilSpecularMaterialDuce* pResource =
            static_cast<CMilSpecularMaterialDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_SPECULARMATERIAL
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdEmissiveMaterial:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_EMISSIVEMATERIAL))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_EMISSIVEMATERIAL* pCmd = 
            reinterpret_cast<const MILCMD_EMISSIVEMATERIAL*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilEmissiveMaterialDuce* pResource =
            static_cast<CMilEmissiveMaterialDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_EMISSIVEMATERIAL
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdTransform3DGroup:
    {
        #ifdef DEBUG
        if (cbSize < sizeof(MILCMD_TRANSFORM3DGROUP))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_TRANSFORM3DGROUP* pCmd = 
            reinterpret_cast<const MILCMD_TRANSFORM3DGROUP*>(pcvData);

        LPCVOID pPayload = reinterpret_cast<LPCVOID>(pCmd + 1);
        UINT cbPayload = cbSize - sizeof(MILCMD_TRANSFORM3DGROUP);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilTransform3DGroupDuce* pResource =
            static_cast<CMilTransform3DGroupDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_TRANSFORM3DGROUP
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd, pPayload, cbPayload));
    }
    break;

    case MilCmdTranslateTransform3D:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_TRANSLATETRANSFORM3D))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_TRANSLATETRANSFORM3D* pCmd = 
            reinterpret_cast<const MILCMD_TRANSLATETRANSFORM3D*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilTranslateTransform3DDuce* pResource =
            static_cast<CMilTranslateTransform3DDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_TRANSLATETRANSFORM3D
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdScaleTransform3D:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_SCALETRANSFORM3D))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_SCALETRANSFORM3D* pCmd = 
            reinterpret_cast<const MILCMD_SCALETRANSFORM3D*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilScaleTransform3DDuce* pResource =
            static_cast<CMilScaleTransform3DDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_SCALETRANSFORM3D
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdRotateTransform3D:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_ROTATETRANSFORM3D))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_ROTATETRANSFORM3D* pCmd = 
            reinterpret_cast<const MILCMD_ROTATETRANSFORM3D*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilRotateTransform3DDuce* pResource =
            static_cast<CMilRotateTransform3DDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_ROTATETRANSFORM3D
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdMatrixTransform3D:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_MATRIXTRANSFORM3D))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_MATRIXTRANSFORM3D* pCmd = 
            reinterpret_cast<const MILCMD_MATRIXTRANSFORM3D*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilMatrixTransform3DDuce* pResource =
            static_cast<CMilMatrixTransform3DDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_MATRIXTRANSFORM3D
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdPixelShader:
    {
        #ifdef DEBUG
        if (cbSize < sizeof(MILCMD_PIXELSHADER))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_PIXELSHADER* pCmd = 
            reinterpret_cast<const MILCMD_PIXELSHADER*>(pcvData);

        LPCVOID pPayload = reinterpret_cast<LPCVOID>(pCmd + 1);
        UINT cbPayload = cbSize - sizeof(MILCMD_PIXELSHADER);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilPixelShaderDuce* pResource =
            static_cast<CMilPixelShaderDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_PIXELSHADER
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd, pPayload, cbPayload));
    }
    break;

    case MilCmdImplicitInputBrush:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_IMPLICITINPUTBRUSH))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_IMPLICITINPUTBRUSH* pCmd = 
            reinterpret_cast<const MILCMD_IMPLICITINPUTBRUSH*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilImplicitInputBrushDuce* pResource =
            static_cast<CMilImplicitInputBrushDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_IMPLICITINPUTBRUSH
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdBlurEffect:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_BLUREFFECT))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_BLUREFFECT* pCmd = 
            reinterpret_cast<const MILCMD_BLUREFFECT*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilBlurEffectDuce* pResource =
            static_cast<CMilBlurEffectDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_BLUREFFECT
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdDropShadowEffect:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_DROPSHADOWEFFECT))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_DROPSHADOWEFFECT* pCmd = 
            reinterpret_cast<const MILCMD_DROPSHADOWEFFECT*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilDropShadowEffectDuce* pResource =
            static_cast<CMilDropShadowEffectDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_DROPSHADOWEFFECT
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdShaderEffect:
    {
        #ifdef DEBUG
        if (cbSize < sizeof(MILCMD_SHADEREFFECT))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_SHADEREFFECT* pCmd = 
            reinterpret_cast<const MILCMD_SHADEREFFECT*>(pcvData);

        LPCVOID pPayload = reinterpret_cast<LPCVOID>(pCmd + 1);
        UINT cbPayload = cbSize - sizeof(MILCMD_SHADEREFFECT);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilShaderEffectDuce* pResource =
            static_cast<CMilShaderEffectDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_SHADEREFFECT
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd, pPayload, cbPayload));
    }
    break;

    case MilCmdDrawingImage:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_DRAWINGIMAGE))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_DRAWINGIMAGE* pCmd = 
            reinterpret_cast<const MILCMD_DRAWINGIMAGE*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilDrawingImageDuce* pResource =
            static_cast<CMilDrawingImageDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_DRAWINGIMAGE
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdTransformGroup:
    {
        #ifdef DEBUG
        if (cbSize < sizeof(MILCMD_TRANSFORMGROUP))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_TRANSFORMGROUP* pCmd = 
            reinterpret_cast<const MILCMD_TRANSFORMGROUP*>(pcvData);

        LPCVOID pPayload = reinterpret_cast<LPCVOID>(pCmd + 1);
        UINT cbPayload = cbSize - sizeof(MILCMD_TRANSFORMGROUP);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilTransformGroupDuce* pResource =
            static_cast<CMilTransformGroupDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_TRANSFORMGROUP
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd, pPayload, cbPayload));
    }
    break;

    case MilCmdTranslateTransform:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_TRANSLATETRANSFORM))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_TRANSLATETRANSFORM* pCmd = 
            reinterpret_cast<const MILCMD_TRANSLATETRANSFORM*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilTranslateTransformDuce* pResource =
            static_cast<CMilTranslateTransformDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_TRANSLATETRANSFORM
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdScaleTransform:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_SCALETRANSFORM))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_SCALETRANSFORM* pCmd = 
            reinterpret_cast<const MILCMD_SCALETRANSFORM*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilScaleTransformDuce* pResource =
            static_cast<CMilScaleTransformDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_SCALETRANSFORM
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdSkewTransform:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_SKEWTRANSFORM))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_SKEWTRANSFORM* pCmd = 
            reinterpret_cast<const MILCMD_SKEWTRANSFORM*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilSkewTransformDuce* pResource =
            static_cast<CMilSkewTransformDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_SKEWTRANSFORM
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdRotateTransform:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_ROTATETRANSFORM))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_ROTATETRANSFORM* pCmd = 
            reinterpret_cast<const MILCMD_ROTATETRANSFORM*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilRotateTransformDuce* pResource =
            static_cast<CMilRotateTransformDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_ROTATETRANSFORM
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdMatrixTransform:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_MATRIXTRANSFORM))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_MATRIXTRANSFORM* pCmd = 
            reinterpret_cast<const MILCMD_MATRIXTRANSFORM*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilMatrixTransformDuce* pResource =
            static_cast<CMilMatrixTransformDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_MATRIXTRANSFORM
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdLineGeometry:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_LINEGEOMETRY))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_LINEGEOMETRY* pCmd = 
            reinterpret_cast<const MILCMD_LINEGEOMETRY*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilLineGeometryDuce* pResource =
            static_cast<CMilLineGeometryDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_LINEGEOMETRY
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdRectangleGeometry:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_RECTANGLEGEOMETRY))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_RECTANGLEGEOMETRY* pCmd = 
            reinterpret_cast<const MILCMD_RECTANGLEGEOMETRY*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilRectangleGeometryDuce* pResource =
            static_cast<CMilRectangleGeometryDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_RECTANGLEGEOMETRY
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdEllipseGeometry:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_ELLIPSEGEOMETRY))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_ELLIPSEGEOMETRY* pCmd = 
            reinterpret_cast<const MILCMD_ELLIPSEGEOMETRY*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilEllipseGeometryDuce* pResource =
            static_cast<CMilEllipseGeometryDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_ELLIPSEGEOMETRY
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdGeometryGroup:
    {
        #ifdef DEBUG
        if (cbSize < sizeof(MILCMD_GEOMETRYGROUP))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_GEOMETRYGROUP* pCmd = 
            reinterpret_cast<const MILCMD_GEOMETRYGROUP*>(pcvData);

        LPCVOID pPayload = reinterpret_cast<LPCVOID>(pCmd + 1);
        UINT cbPayload = cbSize - sizeof(MILCMD_GEOMETRYGROUP);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilGeometryGroupDuce* pResource =
            static_cast<CMilGeometryGroupDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_GEOMETRYGROUP
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd, pPayload, cbPayload));
    }
    break;

    case MilCmdCombinedGeometry:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_COMBINEDGEOMETRY))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_COMBINEDGEOMETRY* pCmd = 
            reinterpret_cast<const MILCMD_COMBINEDGEOMETRY*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilCombinedGeometryDuce* pResource =
            static_cast<CMilCombinedGeometryDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_COMBINEDGEOMETRY
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdPathGeometry:
    {
        #ifdef DEBUG
        if (cbSize < sizeof(MILCMD_PATHGEOMETRY))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_PATHGEOMETRY* pCmd = 
            reinterpret_cast<const MILCMD_PATHGEOMETRY*>(pcvData);

        LPCVOID pPayload = reinterpret_cast<LPCVOID>(pCmd + 1);
        UINT cbPayload = cbSize - sizeof(MILCMD_PATHGEOMETRY);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilPathGeometryDuce* pResource =
            static_cast<CMilPathGeometryDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_PATHGEOMETRY
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd, pPayload, cbPayload));
    }
    break;

    case MilCmdSolidColorBrush:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_SOLIDCOLORBRUSH))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_SOLIDCOLORBRUSH* pCmd = 
            reinterpret_cast<const MILCMD_SOLIDCOLORBRUSH*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilSolidColorBrushDuce* pResource =
            static_cast<CMilSolidColorBrushDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_SOLIDCOLORBRUSH
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdLinearGradientBrush:
    {
        #ifdef DEBUG
        if (cbSize < sizeof(MILCMD_LINEARGRADIENTBRUSH))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_LINEARGRADIENTBRUSH* pCmd = 
            reinterpret_cast<const MILCMD_LINEARGRADIENTBRUSH*>(pcvData);

        LPCVOID pPayload = reinterpret_cast<LPCVOID>(pCmd + 1);
        UINT cbPayload = cbSize - sizeof(MILCMD_LINEARGRADIENTBRUSH);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilLinearGradientBrushDuce* pResource =
            static_cast<CMilLinearGradientBrushDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_LINEARGRADIENTBRUSH
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd, pPayload, cbPayload));
    }
    break;

    case MilCmdRadialGradientBrush:
    {
        #ifdef DEBUG
        if (cbSize < sizeof(MILCMD_RADIALGRADIENTBRUSH))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_RADIALGRADIENTBRUSH* pCmd = 
            reinterpret_cast<const MILCMD_RADIALGRADIENTBRUSH*>(pcvData);

        LPCVOID pPayload = reinterpret_cast<LPCVOID>(pCmd + 1);
        UINT cbPayload = cbSize - sizeof(MILCMD_RADIALGRADIENTBRUSH);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilRadialGradientBrushDuce* pResource =
            static_cast<CMilRadialGradientBrushDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_RADIALGRADIENTBRUSH
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd, pPayload, cbPayload));
    }
    break;

    case MilCmdImageBrush:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_IMAGEBRUSH))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_IMAGEBRUSH* pCmd = 
            reinterpret_cast<const MILCMD_IMAGEBRUSH*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilImageBrushDuce* pResource =
            static_cast<CMilImageBrushDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_IMAGEBRUSH
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdDrawingBrush:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_DRAWINGBRUSH))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_DRAWINGBRUSH* pCmd = 
            reinterpret_cast<const MILCMD_DRAWINGBRUSH*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilDrawingBrushDuce* pResource =
            static_cast<CMilDrawingBrushDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_DRAWINGBRUSH
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdVisualBrush:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_VISUALBRUSH))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_VISUALBRUSH* pCmd = 
            reinterpret_cast<const MILCMD_VISUALBRUSH*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilVisualBrushDuce* pResource =
            static_cast<CMilVisualBrushDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_VISUALBRUSH
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdBitmapCacheBrush:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_BITMAPCACHEBRUSH))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_BITMAPCACHEBRUSH* pCmd = 
            reinterpret_cast<const MILCMD_BITMAPCACHEBRUSH*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilBitmapCacheBrushDuce* pResource =
            static_cast<CMilBitmapCacheBrushDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_BITMAPCACHEBRUSH
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdDashStyle:
    {
        #ifdef DEBUG
        if (cbSize < sizeof(MILCMD_DASHSTYLE))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_DASHSTYLE* pCmd = 
            reinterpret_cast<const MILCMD_DASHSTYLE*>(pcvData);

        LPCVOID pPayload = reinterpret_cast<LPCVOID>(pCmd + 1);
        UINT cbPayload = cbSize - sizeof(MILCMD_DASHSTYLE);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilDashStyleDuce* pResource =
            static_cast<CMilDashStyleDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_DASHSTYLE
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd, pPayload, cbPayload));
    }
    break;

    case MilCmdPen:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_PEN))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_PEN* pCmd = 
            reinterpret_cast<const MILCMD_PEN*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilPenDuce* pResource =
            static_cast<CMilPenDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_PEN
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdGeometryDrawing:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_GEOMETRYDRAWING))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_GEOMETRYDRAWING* pCmd = 
            reinterpret_cast<const MILCMD_GEOMETRYDRAWING*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilGeometryDrawingDuce* pResource =
            static_cast<CMilGeometryDrawingDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_GEOMETRYDRAWING
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdGlyphRunDrawing:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_GLYPHRUNDRAWING))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_GLYPHRUNDRAWING* pCmd = 
            reinterpret_cast<const MILCMD_GLYPHRUNDRAWING*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilGlyphRunDrawingDuce* pResource =
            static_cast<CMilGlyphRunDrawingDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_GLYPHRUNDRAWING
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdImageDrawing:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_IMAGEDRAWING))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_IMAGEDRAWING* pCmd = 
            reinterpret_cast<const MILCMD_IMAGEDRAWING*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilImageDrawingDuce* pResource =
            static_cast<CMilImageDrawingDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_IMAGEDRAWING
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdVideoDrawing:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_VIDEODRAWING))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_VIDEODRAWING* pCmd = 
            reinterpret_cast<const MILCMD_VIDEODRAWING*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilVideoDrawingDuce* pResource =
            static_cast<CMilVideoDrawingDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_VIDEODRAWING
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    case MilCmdDrawingGroup:
    {
        #ifdef DEBUG
        if (cbSize < sizeof(MILCMD_DRAWINGGROUP))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_DRAWINGGROUP* pCmd = 
            reinterpret_cast<const MILCMD_DRAWINGGROUP*>(pcvData);

        LPCVOID pPayload = reinterpret_cast<LPCVOID>(pCmd + 1);
        UINT cbPayload = cbSize - sizeof(MILCMD_DRAWINGGROUP);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilDrawingGroupDuce* pResource =
            static_cast<CMilDrawingGroupDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_DRAWINGGROUP
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd, pPayload, cbPayload));
    }
    break;

    case MilCmdGuidelineSet:
    {
        #ifdef DEBUG
        if (cbSize < sizeof(MILCMD_GUIDELINESET))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_GUIDELINESET* pCmd = 
            reinterpret_cast<const MILCMD_GUIDELINESET*>(pcvData);

        LPCVOID pPayload = reinterpret_cast<LPCVOID>(pCmd + 1);
        UINT cbPayload = cbSize - sizeof(MILCMD_GUIDELINESET);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilGuidelineSetDuce* pResource =
            static_cast<CMilGuidelineSetDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_GUIDELINESET
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd, pPayload, cbPayload));
    }
    break;

    case MilCmdBitmapCache:
    {
        #ifdef DEBUG
        if (cbSize != sizeof(MILCMD_BITMAPCACHE))
        {
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }
        #endif

        const MILCMD_BITMAPCACHE* pCmd = 
            reinterpret_cast<const MILCMD_BITMAPCACHE*>(pcvData);

        /* Resource handles are validated in the ProcessUpdate method. */

        CMilBitmapCacheDuce* pResource =
            static_cast<CMilBitmapCacheDuce*>(pHandleTable->GetResource(
                pCmd->Handle,
                TYPE_BITMAPCACHE
                ));

        if (pResource == NULL)
        {
            RIP("Invalid resource handle.");
            IFC(WGXERR_UCE_MALFORMEDPACKET);
        }


        IFC(pResource->ProcessUpdate(pHandleTable, pCmd));
    }
    break;

    default:
        RIP("Invalid command type.");
        IFC(WGXERR_UCE_MALFORMEDPACKET);
        break;
}
